/**
 * The SVG element.
 */
var outer=document.getElementById('outer'),
    svg=document.getElementById('svgDiv'),
    zoom=1,scx,scy;

/**
 * Function setSVG(w,h,n,s)
 * 
 * <p>Setup for the content of the SVG preview.
 * 
 * @type Function
 * 
 * @param {String} w  The width.
 * @param {String} h  The height.
 * @param {String} n  The name in Base64. 
 * @param {String} s  The content string in Base64.
 */
window.setSVG=function(w,h,n,s)
  {
  document.getElementById('w').innerText=scx=w;
  document.getElementById('h').innerText=scy=h;
  document.getElementById('n').innerText=atob(n);
  svg.innerHTML=atob(s);
  setScale(zoom);
  };

/**
 * Function setScale(v)
 * 
 * <p>Sets the scaling value.
 * 
 * @type Function
 * 
 * @param {Number} v  The scale: 1=normal.
 */
function setScale(v)
  {
  var s=svg.firstChild;
  if ( s )
    {
    s.setAttribute('width' ,(scx*v)+'px');
    s.setAttribute('height',(scy*v)+'px');
    }
    
  onresize();
  }

/**
 * Ignore mouse and keyboard events.
 */
function ignore(_e)
  {
  // Let it pass for the entry fields.
  document.body.style.cursor='default';
  var e=_e || window.event;
  e.cancelBubble=true; // IE
  if ( e.stopPropagation )
    e.stopPropagation();
  if ( e.preventDefault )
    e.preventDefault();    
  return false;
  }
  
// Disable mouse and keyboard.
document.onmousedown=
document.onmousemove=
document.onmouseup=
document.oncontextmenu=
document.body.onkeydown=
document.body.onkeypress=
document.body.onkeyup=ignore;

// On resize listener and call now.
(window.onresize=function()
  {
  var s=outer.style,
      cx=window.innerWidth,
      cy=window.innerHeight,
      x=outer.offsetLeft,
      y=outer.offsetTop;
  
  cx=Math.max(0,cx-x*2);
  cy=Math.max(0,cy-y-x);
  
  s.width=s.height='';
  
  if ( outer.offsetWidth>cx )
    s.width=cx+'px';
  
  if ( outer.offsetHeight>cy )
    s.height=cy+'px';
  })();
  
///
/// --- Initialize in a jiffy ---
///

// Asynchronous events are only fired if the browser is ready.
// The browser is not ready when loading.
setTimeout(function()
  {
  // Callback to Eclipse when done.
  onJSInitialized();
  },0);
