/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.barcode;

import com.iizix.barcode.BarcodeBuilder;
import com.iizix.barcode.BarcodeType;
import com.iizix.barcode.BarcodeURN;
import com.iizix.urn.IURNProvider;
import com.iizix.urn.NID;
import com.iizix.urn.NIDException;
import com.iizix.urn.NSSException;
import com.iizix.urn.URN;
import com.iizix.urn.URNException;
import com.iizix.urn.URNFactory;
import com.iizix.urn.URNResourceType;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class BarcodeURNFactory
implements IURNProvider {
    private static final BarcodeURNFactory a = new BarcodeURNFactory();

    public static void initialize(URNFactory uRNFactory) {
        uRNFactory.register((IURNProvider)a);
    }

    public static BarcodeURNFactory getInstance() {
        return a;
    }

    private BarcodeURNFactory() {
    }

    public NID getNID() {
        return NID.BARCODE;
    }

    public List<URNResourceType> getResourceTypes() {
        return Collections.emptyList();
    }

    public URN parse(String string, String string2, String string3, String string4, String string5) throws URNException {
        String string6;
        if (string3 != null) {
            throw new NIDException("Barcode URN should not contain a request part '?+': " + string3, string, NID.BARCODE);
        }
        if (string4 != null) {
            throw new NIDException("Barcode URN should not contain a query part '?=': " + string4, string, NID.BARCODE);
        }
        if (string5 != null) {
            throw new NIDException("Barcode URN should not contain a fragment part '#': " + string5, string, NID.BARCODE);
        }
        int n = string2.indexOf(58);
        if (n < 0) {
            throw new NSSException("Missing barcode type and data separator ':'", string, string2);
        }
        String string7 = string2.substring(0, n);
        BarcodeType barcodeType = BarcodeType.from(string7);
        if (barcodeType == null) {
            throw new NSSException("Unknown barcode format or type: " + string7, string, string2);
        }
        String string8 = "";
        int n2 = string2.indexOf(58, n + 1);
        if (n2 < 0) {
            string6 = string2.substring(n + 1);
        } else {
            string6 = string2.substring(n + 1, n2);
            string8 = string2.substring(n2 + 1);
        }
        if (string6.isEmpty()) {
            throw new NSSException("Barcode text string is empty", string, string2);
        }
        string6 = URLDecoder.decode(string6, StandardCharsets.UTF_8);
        try {
            BarcodeBuilder barcodeBuilder = new BarcodeBuilder(barcodeType, string6, string8);
            return new BarcodeURN(string, barcodeBuilder);
        }
        catch (Throwable throwable) {
            throw new NSSException("Barcode URN is invalid", string, string2, throwable);
        }
    }
}

