/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.chat;

import com.tabnine.eclipse.shared.a.c;
import com.tabnine.eclipse.shared.a.d;
import com.tabnine.eclipse.shared.a.e;
import com.tabnine.eclipse.shared.a.g;
import com.tabnine.eclipse.shared.a.i;
import com.tabnine.eclipse.shared.api.DependencyContainer;
import com.tabnine.eclipse.shared.api.binary.BinaryRequestFacade;
import com.tabnine.eclipse.shared.api.binary.requests.EventRequest;
import com.tabnine.eclipse.shared.api.chat.ChatView$1;
import com.tabnine.eclipse.shared.api.chat.ChatView$2;
import com.tabnine.eclipse.shared.api.chat.ChatView$3;
import com.tabnine.eclipse.shared.api.chat.ChatView$ChatBrowserSettings;
import com.tabnine.eclipse.shared.api.chat.ChatView$OpenUrl;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;

public class ChatView
extends ViewPart {
    private static final String TABNINE_ECLIPSE_POST_MESSAGE_FUNCTION_NAME = "tabnineEclipsePostMessage";
    public static final String ID = "com.tabnine.eclipse.shared.chat.ChatBrowserView";
    private final Logger logger = LogManager.getLogger(ChatView.class);
    private BinaryRequestFacade binaryRequestFacade = DependencyContainer.instanceOfBinaryRequestFacade();
    private ExecutorService excutor = Executors.newCachedThreadPool();
    private Optional<Browser> browser = Optional.empty();
    private Optional<Text> text = Optional.empty();
    private Optional<Composite> textAndLinkView = Optional.empty();
    private Optional<Composite> signInView = Optional.empty();
    private d enabledState = DependencyContainer.instanceOfChatEnabledState();
    private Optional<e> listener = Optional.empty();
    private ChatView$OpenUrl openUrl = new ChatView$OpenUrl(this);

    public void init(IViewSite iViewSite) {
        this.excutor.execute(this.enabledState::b);
        super.init(iViewSite);
    }

    public void createPartControl(Composite object) {
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        object = arg_0 -> this.lambda$1((Composite)object, atomicReference, arg_0);
        this.listener.ifPresent(this.enabledState::b);
        this.listener = Optional.of(object);
        this.enabledState.a((e)object);
    }

    private void displayChatApp(Composite composite, ChatView$ChatBrowserSettings object) {
        Browser browser;
        try {
            browser = new Browser(composite, 262144);
            browser.addOpenWindowListener((OpenWindowListener)new ChatView$1(this, composite));
            browser.setUrl(object.chatAppUrl);
            object.messageHandlerInitializaiton.init(browser, TABNINE_ECLIPSE_POST_MESSAGE_FUNCTION_NAME);
            this.browser = Optional.of(browser);
        }
        catch (SWTError sWTError) {
            object = sWTError;
            if (sWTError.code == 20 && SWT.getPlatform() == "win32") {
                this.binaryRequestFacade.executeRequest(new EventRequest("webview2-missing", new HashMap<String, Object>()));
                this.displayTextAndLink(composite, "To use Tabnine chat please make sure you have Webview2 installed", "Go to Webview2 page", "https://developer.microsoft.com/en-us/microsoft-edge/webview2");
                return;
            }
            throw object;
        }
        try {
            object = new ChatView$2(this, browser);
            browser.addProgressListener((ProgressListener)object);
            this.logger.debug("Clipboard polyfill was successfully loaded");
            return;
        }
        catch (Exception exception) {
            this.logger.warn("Clipboard polyfill could not be loaded", (Throwable)exception);
            return;
        }
    }

    private void displayTextAndLink(Composite composite, String string, String string2, String string3) {
        composite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        new GridLayout(1, false).marginWidth = 10;
        composite.setLayout((Layout)gridLayout);
        gridLayout = new Text(composite, 64);
        gridLayout.setText(string);
        string = new Link(composite, 0);
        string.setText(String.format("<a href=\"%s\">%s</a>", string3, string2));
        string.addSelectionListener((SelectionListener)this.openUrl);
        this.textAndLinkView = Optional.of(composite);
    }

    private void displayText(Composite composite, String string) {
        composite = new Text(composite, 1);
        composite.setText(string);
        this.text = Optional.of(composite);
    }

    private void displaySignInView(Composite composite) {
        composite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        new GridLayout(1, false).marginWidth = 10;
        composite.setLayout((Layout)gridLayout);
        gridLayout = new Text(composite, 1);
        gridLayout.setText("Please ensure you\u2019re signed in");
        gridLayout = new Button(composite, 8);
        GridData gridData = new GridData(4, 4, true, false);
        gridLayout.setText("Sign In");
        gridLayout.setLayoutData((Object)gridData);
        gridLayout.addSelectionListener((SelectionListener)new ChatView$3(this));
        this.signInView = Optional.of(composite);
    }

    private void disposeOldParts() {
        if (this.text.isPresent()) {
            this.text.get().dispose();
        }
        if (this.signInView.isPresent()) {
            this.signInView.get().dispose();
        }
        if (this.browser.isPresent()) {
            this.browser.get().dispose();
        }
        if (this.textAndLinkView.isPresent()) {
            this.textAndLinkView.get().dispose();
        }
    }

    public void setFocus() {
        this.browser.ifPresent(Composite::setFocus);
    }

    public void dispose() {
        this.enabledState.c();
        super.dispose();
    }

    private /* synthetic */ void lambda$1(Composite composite, AtomicReference atomicReference, i i2) {
        if (composite.isDisposed()) {
            return;
        }
        composite.getDisplay().asyncExec(() -> {
            if (atomicReference.get() != null && ((i)atomicReference.get()).equals(i2)) {
                return;
            }
            this.disposeOldParts();
            if (i2.c()) {
                this.displayText(composite, "Loading...");
            } else if (i2.d()) {
                this.displayChatApp(composite, g.a());
            } else if (i2.e() == c.AUTHENTICATION_REQUIRED) {
                this.displaySignInView(composite);
            } else {
                this.displayText(composite, "Tabnine Chat is currently in Beta");
            }
            composite.redraw();
            composite.layout();
            atomicReference.set(i.a(i2));
        });
    }
}

