/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.vs.actor;

import com.iizix.actionactor.IActionActor;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.prop.Atom;
import com.iizix.prop.PropException;
import com.iizix.prop.vs.VSAction;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VSFocusReference;
import com.iizix.prop.vs.actor.AbstractPredefinedSettings;
import com.iizix.prop.vs.actor.AbstractVSActionActor;
import com.iizix.txp.impl.AbstractActionActorTXPNode;

public class SetFocus
extends AbstractVSActionActor<Settings> {
    public SetFocus(VSAction vSAction, Settings settings) {
        super(vSAction, settings);
    }

    @Override
    public Settings createSettings() {
        return new Settings(Atom.SETTINGS);
    }

    @Override
    public String getDefaultDescription() {
        return "Set focus";
    }

    @Override
    public String getEnabledState(IAppSessionGyro iAppSessionGyro, VSAction vSAction) {
        VSComponent vSComponent = ((Settings)this.settings).getTargetFocus();
        if (vSComponent == null) {
            return "Focus component not found";
        }
        VSComponent vSComponent2 = vSAction.getVirtualSpace().getAppSessionGyro().getVirtualizedVSComponent(vSComponent);
        if (vSComponent2 == null) {
            return "Virtualized counterpart not found";
        }
        return vSComponent2.couldRequestFocusIfVirtualized(false);
    }

    @Override
    public boolean doesModifyVirtualSpace() {
        return false;
    }

    @Override
    void a(AbstractActionActorTXPNode<Settings> abstractActionActorTXPNode, IAppSessionGyro iAppSessionGyro) throws PropException {
        VSComponent vSComponent = ((Settings)this.settings).getTargetFocus();
        if (vSComponent == null) {
            throw new PropException(this.settings, "Focus component not found");
        }
        VSComponent vSComponent2 = iAppSessionGyro.getVirtualizedVSComponent(vSComponent);
        if (vSComponent2 == null) {
            throw new PropException(vSComponent, "Virtualized counterpart not found");
        }
        vSComponent2.requestFocus(this.action);
    }

    public static class Settings
    extends AbstractPredefinedSettings {
        public Settings() {
        }

        public Settings(Atom atom) {
            super(atom);
        }

        protected IActionActor<Settings> createActor(VSAction vSAction) {
            return new SetFocus(vSAction, this);
        }

        @Override
        public boolean doesModifyVirtualSpace(VSAction vSAction) {
            return false;
        }

        public VSComponent getTargetFocus() {
            VSFocusReference vSFocusReference = this.getTargetFocusReference();
            return vSFocusReference != null ? (VSComponent)vSFocusReference.getVSTarget() : null;
        }

        public VSFocusReference getTargetFocusReference() {
            return this.getProp("targetFocus", VSFocusReference.class);
        }
    }
}

