/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.chart;

import com.iizix.Size;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IPropCnrChoiceSettings;
import com.iizix.prop.IPropCnrColorSettings;
import com.iizix.prop.IPropCnrFontSettings;
import com.iizix.prop.IPropCnrIntegerSettings;
import com.iizix.prop.IPropCnrKStringSettings;
import com.iizix.prop.KStringProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.ui.IUIContextMenuOwner;
import com.iizix.prop.ui.UIComp;
import com.iizix.prop.ui.UIPanelBase;
import com.iizix.prop.ui.chart.ChartColor;
import com.iizix.prop.ui.chart.ChartFont;
import com.iizix.prop.ui.chart.ChartInteger;
import com.iizix.prop.ui.chart.ChartKString;
import com.iizix.prop.ui.chart.ChartTheme;
import com.iizix.prop.ui.chart.IChartChoiceOption;
import com.iizix.prop.ui.chart.IChartContainer;
import com.iizix.prop.ui.chart.TitlePosition;
import com.iizix.prop.ui.chart.axis2d.Axis2D;
import com.iizix.prop.ui.chart.plot2d.Plot2D;
import com.iizix.prop.ui.chart.series.Series;
import com.iizix.prop.vs.VSComponent;
import com.iizix.prop.vs.VSTable;
import com.iizix.prop.vs.VirtualSpace;
import com.iizix.text.ValidationKStringInfoProviderHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class UIChart
extends UIComp
implements IPropCnrChoiceSettings<IChartChoiceOption>,
IPropCnrColorSettings<ChartColor>,
IPropCnrFontSettings<ChartFont>,
IPropCnrIntegerSettings<ChartInteger>,
IPropCnrKStringSettings<ChartKString>,
IUIContextMenuOwner {
    private boolean a;

    public UIChart() {
    }

    public UIChart(Atom atom) {
        super(atom);
    }

    @Override
    public UIChart clone() {
        UIChart uIChart = (UIChart)super.clone();
        uIChart.a = false;
        uIChart.setAutoRendering(true);
        return uIChart;
    }

    @Override
    public final boolean usesPropIndex() {
        return true;
    }

    @Override
    public final int getDeviceType() {
        return 0;
    }

    @Override
    public boolean isMobileContextMenuSupported() {
        return true;
    }

    @Override
    public boolean mustHaveWidth() {
        return true;
    }

    @Override
    public boolean mustHaveHeight() {
        return true;
    }

    @Override
    public boolean hasImplicitAlignFillX() {
        return true;
    }

    @Override
    public boolean hasImplicitAlignFillY() {
        return true;
    }

    @Override
    public boolean canAlignX() {
        return false;
    }

    @Override
    public boolean canAlignY() {
        return false;
    }

    protected KStringProp createTitleProp() {
        return new KStringProp(Atom.TITLE);
    }

    public ChartTheme getTheme() {
        Atom.get("myName");
        return (ChartTheme)ChartTheme.Gradient_Julie.get(this);
    }

    public void setTheme(ChartTheme chartTheme) {
        if (chartTheme != null) {
            chartTheme.set(this);
        } else {
            ChartTheme.Gradient_Julie.set(this);
        }
    }

    public TitlePosition getTitlePosition() {
        return (TitlePosition)TitlePosition.TOP.get(this);
    }

    public UIChart addAxis(Axis2D axis2D) throws PropException {
        this.addProp(axis2D);
        this.setAutoRendering(false);
        return this;
    }

    public Axis2D getAxis(String string) {
        return this.getProp(string, Axis2D.class);
    }

    public Axis2D[] getAxes() {
        return this.getProps(Axis2D.class);
    }

    public boolean removeAxis(String string) throws PropException {
        return this.removeAxis(this.getAxis(string));
    }

    public boolean removeAxis(Axis2D axis2D) throws PropException {
        return axis2D != null ? this.removeProp(axis2D) : false;
    }

    public Plot2D getDefaultPlot() {
        return this.getProp(Plot2D.DEFAULT, Plot2D.class);
    }

    public UIChart addPlot(Plot2D plot2D) throws PropException {
        this.addProp(plot2D);
        this.setAutoRendering(false);
        return this;
    }

    public Plot2D getPlot(String string) {
        return this.getProp(string, Plot2D.class);
    }

    public Plot2D[] getPlots() {
        return this.getProps(Plot2D.class);
    }

    public boolean removePlot(String string) throws PropException {
        return this.removePlot(this.getPlot(string));
    }

    public boolean removePlot(Plot2D plot2D) throws PropException {
        return plot2D != null ? this.removeProp(plot2D) : false;
    }

    public UIChart addSeries(Series series) throws PropException {
        this.addProp(series);
        this.setAutoRendering(false);
        return this;
    }

    public Series getSeries(String string) {
        return this.getProp(string, Series.class);
    }

    public Series[] getSeries() {
        return this.getProps(Series.class);
    }

    public boolean removeSeries(String string) throws PropException {
        return this.removeSeries(this.getSeries(string));
    }

    public boolean removeSeries(Series series) throws PropException {
        return series != null ? this.removeProp(series) : false;
    }

    public boolean hasSeries(int n2) {
        GProp<?>[] gPropArray = this.getProps();
        int n3 = gPropArray.length;
        int n4 = 0;
        while (n4 < n3) {
            GProp<?> gProp = gPropArray[n4];
            if (gProp instanceof Series && ((Series)gProp).hasConnection(n2)) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    public final int moveToFront(String string) throws PropException {
        return this.moveToFront(this.getProp(string, IChartContainer.class));
    }

    public final int moveToFront(IChartContainer iChartContainer) throws PropException {
        if (iChartContainer == null || iChartContainer.getParent() != this) {
            return -1;
        }
        ArrayList<Atom> arrayList = new ArrayList<Atom>(Arrays.asList(this.getPropIndexes()));
        int n2 = arrayList.indexOf(iChartContainer.getPropAtom());
        if (n2 < 0) {
            return -1;
        }
        int n3 = -1;
        IChartContainer.Type type = iChartContainer.getContainerType();
        int n4 = 0;
        while (n4 < n2) {
            if (this.getProp(arrayList.get(n4), IChartContainer.class).getContainerType() == type) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n3 < 0) {
            return 0;
        }
        arrayList.remove(n2);
        arrayList.add(n3, iChartContainer.getPropAtom());
        this.reorderProps(arrayList.toArray(new Atom[arrayList.size()]));
        return 1;
    }

    public final int moveToBack(String string) throws PropException {
        return this.moveToBack(this.getProp(string, IChartContainer.class));
    }

    public final int moveToBack(IChartContainer iChartContainer) throws PropException {
        if (iChartContainer == null || iChartContainer.getParent() != this) {
            return -1;
        }
        ArrayList<Atom> arrayList = new ArrayList<Atom>(Arrays.asList(this.getPropIndexes()));
        int n2 = arrayList.indexOf(iChartContainer.getPropAtom());
        if (n2 < 0) {
            return -1;
        }
        int n3 = arrayList.size();
        int n4 = -1;
        IChartContainer.Type type = iChartContainer.getContainerType();
        int n5 = n3;
        while (--n5 > n2) {
            if (this.getProp(arrayList.get(n5), IChartContainer.class).getContainerType() == type) {
                n4 = n5;
                break;
            }
            --n5;
        }
        if (n4 < 0) {
            return 0;
        }
        arrayList.remove(n2);
        arrayList.add(n4 - 1, iChartContainer.getPropAtom());
        this.reorderProps(arrayList.toArray(new Atom[arrayList.size()]));
        return 1;
    }

    public String validate() {
        ValidationKStringInfoProviderHolder validationKStringInfoProviderHolder = new ValidationKStringInfoProviderHolder(this, null);
        PropVerification propVerification = new PropVerification(validationKStringInfoProviderHolder);
        this.verify(propVerification);
        if (!propVerification.hasErrors()) {
            return null;
        }
        return propVerification.getErrors()[0].errorText;
    }

    public boolean isAutoRendering() {
        return this.getBool("$autoRender", true);
    }

    public boolean setAutoRendering(boolean bl) {
        return bl ? this.removeProp2("$autoRender") : this.setBool("$autoRender", false);
    }

    public String render() {
        String string = this.validate();
        if (string != null) {
            return string;
        }
        this.triggerRemoteEvent(1);
        return null;
    }

    public int zoomin(Axis2D axis2D, int n2, int n3) {
        if (n2 < 0 || n3 <= n2) {
            return -1;
        }
        if (axis2D.getParent() != this) {
            return -1;
        }
        try {
            boolean bl = this.setString("$zoom", axis2D.getPropName());
            bl |= this.setInt("$zoom1", n2);
            if (bl |= this.setInt("$zoom2", n3)) {
                this.triggerRemoteEvent(2);
            }
            return bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    public boolean zoomout() {
        if (this.getInt("$zoom1", -1) < 0) {
            return false;
        }
        try {
            this.removeProp("$zoom");
            this.removeProp("$zoom1");
            this.removeProp("$zoom2");
            this.triggerRemoteEvent(2);
            return true;
        }
        catch (PropException propException) {
            return false;
        }
    }

    public int setWindow(double d2, double d3, double d4, double d5, int n2) {
        if (d2 <= 0.0 || d3 <= 0.0 || n2 < 0) {
            return -1;
        }
        boolean bl = this.setNumber("$sxW", d2);
        bl |= this.setNumber("$syW", d3);
        bl |= this.setNumber("$dxW", d4);
        bl |= this.setNumber("$dyW", d5);
        if (!(bl |= this.setInt("$aW", n2))) {
            return 0;
        }
        this.triggerRemoteEvent(3);
        return 1;
    }

    public int clearWindow(int n2) {
        if (n2 < 0) {
            return -1;
        }
        if (!this.containsProp("$sxW")) {
            return 0;
        }
        this.removeProp2("$sxW");
        this.removeProp2("$syW");
        this.removeProp2("$dxW");
        this.removeProp2("$dyW");
        this.setInt("$aW", n2);
        this.triggerRemoteEvent(3);
        return 1;
    }

    @Override
    public Size getApproximateSize() {
        return new Size(400, 300);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (this.hasSeries(1)) {
            UIChart uIChart = this;
            synchronized (uIChart) {
                if (this.a) {
                    return;
                }
                this.a = true;
            }
            this.post(() -> this.d());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void d() {
        GProp gProp;
        if (this.isDisposed()) {
            return;
        }
        UIPanelBase uIPanelBase = this.getUIPanel();
        if (uIPanelBase == null) {
            return;
        }
        VirtualSpace virtualSpace = uIPanelBase.getVirtualSpace();
        if (virtualSpace == null) {
            return;
        }
        HashSet<VSTable> hashSet = new HashSet<VSTable>();
        GProp<?>[] gPropArray = this.getProps();
        int n2 = gPropArray.length;
        int n3 = 0;
        while (n3 < n2) {
            VSTable vSTable;
            gProp = gPropArray[n3];
            if (gProp instanceof Series && (vSTable = ((Series)gProp).getVSTable()) != null) {
                hashSet.add(vSTable);
            }
            ++n3;
        }
        if (hashSet.isEmpty()) {
            return;
        }
        if (!virtualSpace.areFree(() -> this.d(), false, hashSet.toArray(new VSComponent[hashSet.size()]))) {
            return;
        }
        gProp = this;
        synchronized (gProp) {
            if (!this.a) {
                return;
            }
            this.a = false;
        }
        gPropArray = this.getProps();
        n2 = gPropArray.length;
        n3 = 0;
        while (n3 < n2) {
            gProp = gPropArray[n3];
            if (gProp instanceof Series) {
                ((Series)gProp).updateContents();
            }
            ++n3;
        }
    }
}

