/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.PropValidateException;

public class LongProp
extends GProp<Long> {
    private static final Class<?>[] a = new Class[]{Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class, String.class, Character.class};

    protected LongProp() {
    }

    public LongProp(Atom atom) {
        super(atom);
    }

    public LongProp(Atom atom, long l2) throws PropValidateException {
        super(atom);
        this.setPropValue(l2);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(long l2) throws PropValidateException {
        try {
            return super.setPropValue(l2);
        }
        catch (PropException propException) {
            if (propException instanceof PropValidateException) {
                throw (PropValidateException)propException;
            }
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof Long)) {
            throw new PropTypeException(this, "newValue not Long");
        }
    }

    public long getLong() {
        return this.getLong(-1L);
    }

    public long getLong(long l2) {
        Long l3 = (Long)this.getPropValue();
        return l3 == null ? l2 : l3;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        Long l2 = (Long)this.getPropValue();
        sendTransaction.appendLong64(l2 == null ? -1L : l2);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        return this.setPropValue((Object)readTransaction.readLong64(), propMgr);
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        try {
            return Long.valueOf(string);
        }
        catch (Exception exception) {
            return this.convertPropError(string, exception);
        }
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        long l2 = (Long)object;
        switch (n2) {
            case 1: {
                if (l2 < Integer.MAX_VALUE || l2 > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Range error for Integer value:" + l2);
                }
                return (int)l2;
            }
            case 2: {
                if (l2 < 32767L || l2 > 32767L) {
                    throw new IllegalArgumentException("Range error for Short value:" + l2);
                }
                return (short)l2;
            }
            case 3: {
                if (l2 < 127L || l2 > 127L) {
                    throw new IllegalArgumentException("Range error for Byte value:" + l2);
                }
                return (byte)l2;
            }
            case 4: {
                return (double)l2;
            }
            case 5: {
                return Float.valueOf(l2);
            }
            case 6: {
                return object.toString();
            }
            case 7: {
                if (l2 < 0L || l2 > 65535L) {
                    throw new IllegalArgumentException("Range error for Character value:" + l2);
                }
                return Character.valueOf((char)l2);
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        long l2;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                l2 = ((Number)object).longValue();
                break;
            }
            case 6: {
                return Long.valueOf((String)object);
            }
            case 7: {
                l2 = ((Character)object).charValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return l2;
    }
}

