/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.license;

public enum ValidateReply {
    VALIDATING(0, false, "License validation in progress, please wait..."),
    NOT_INITIALIZED(1, false, "License has not been initialized"),
    LICENSEE_MISSING(2, false, "Licensee information is missing"),
    NOT_REGISTERED(3, false, "License has not been registered"),
    REGISTERED_VALID_OFFLINE(4, true, "Registered valid offline, license server is still offline: please continue"),
    VALID_TRIAL(10, true, "Valid trial license"),
    TRAIL_EXPIRED(11, false, "Invalid trial license, trial period has expired"),
    VALID(20, true, "License is valid"),
    VALID_ACTIVATION_REQUIRED(21, true, "License is valid, on-line activation is required"),
    BEFORE_VALIDITY_PERIOD(30, true, "License validity is subject to a time period, and this period has not yet started"),
    AFTER_VALIDITY_PERIOD(31, false, "License validity is subject to a time period, and this period has reached its end"),
    ACTIVATION_PERIOD_EXHAUSTED(40, true, "The License Activation period of 10 days has been exhausted. The license may be valid, but must be activated with the License Server. Until the license has been activated, it is considered invalid"),
    BROKEN(99, false, "License has been broken and cannot recover, please request a new license");

    public final int value;
    public final boolean isValid;
    public final String description;

    private ValidateReply(int n3, boolean bl, String string2) {
        this.value = n3;
        this.isValid = bl;
        this.description = string2;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public static ValidateReply fromReplyValue(int n2) {
        ValidateReply[] validateReplyArray = ValidateReply.values();
        int n3 = validateReplyArray.length;
        int n4 = 0;
        while (n4 < n3) {
            ValidateReply validateReply = validateReplyArray[n4];
            if (validateReply.value == n2) {
                return validateReply;
            }
            ++n4;
        }
        return null;
    }
}

