/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.text;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.text.IDocumentRange;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.text.PDEMarkerAnnotationModel;
import org.eclipse.pde.internal.ui.editor.text.PDETextHover;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class ManifestTextHover
extends PDETextHover {
    private final PDESourcePage fSourcePage;
    private final IJavaProject fJP;

    public ManifestTextHover(PDESourcePage sourcePage) {
        this.fSourcePage = sourcePage;
        IProject project = ((PDEFormEditor)this.fSourcePage.getEditor()).getCommonProject();
        this.fJP = JavaCore.create((IProject)project);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel annotationModel;
        String hover = this.getHoverInfo2(textViewer, hoverRegion);
        if (hover == null && (annotationModel = this.fSourcePage.getViewer().getAnnotationModel()) instanceof PDEMarkerAnnotationModel) {
            PDEMarkerAnnotationModel pdeAnnotationModel = (PDEMarkerAnnotationModel)annotationModel;
            int offset = hoverRegion.getOffset();
            Iterator annotationIterator = pdeAnnotationModel.getAnnotationIterator(offset, 0, true, true);
            while (annotationIterator.hasNext()) {
                Annotation object = (Annotation)annotationIterator.next();
                if (!(object instanceof MarkerAnnotation)) continue;
                IMarker m = ((MarkerAnnotation)object).getMarker();
                String message = m.getAttribute("message", null);
                return message;
            }
        }
        return hover;
    }

    public String getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        int offset = hoverRegion.getOffset();
        IDocumentRange range = this.fSourcePage.getRangeElement(offset, false);
        if (range instanceof IManifestHeader) {
            IManifestHeader header = (IManifestHeader)range;
            String headerName = header.getName();
            if (offset >= header.getOffset() + headerName.length()) {
                return this.checkForTranslatable(header);
            }
            if (this.fJP != null) {
                return PDEJavaHelperUI.getOSGIConstantJavaDoc(headerName, this.fJP);
            }
        }
        return null;
    }

    private String checkForTranslatable(IManifestHeader header) {
        String name = header.getName();
        String value = header.getValue();
        String[] stringArray = ICoreConstants.TRANSLATABLE_HEADERS;
        int n = ICoreConstants.TRANSLATABLE_HEADERS.length;
        int n2 = 0;
        while (n2 < n) {
            IBaseModel model;
            String transalatableHeader = stringArray[n2];
            if (name.equals(transalatableHeader) && value.startsWith("%") && (model = ((PDEFormEditor)this.fSourcePage.getEditor()).getAggregateModel()) instanceof IModel) {
                return ((IModel)model).getResourceString(value);
            }
            ++n2;
        }
        return null;
    }
}

