/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.vs;

import com.iizigo.ApplicationUI;
import com.iizigo.editor.PropHelper;
import com.iizigo.editor.complex.ComplexOperation;
import com.iizigo.project.ModuleModel;
import com.iizigo.prop.editor.dialog.SelectPropDialog;
import com.iizigo.prop.editor.dialog.SelectPropViewerFilter;
import com.iizigo.vs.NewVirtualSpaceWizard;
import com.iizigo.vs.prop.EditorVirtualSpace;
import com.iizix.ILog;
import com.iizix.prop.GProp;
import com.iizix.prop.IComplexOperation;
import com.iizix.prop.IPropUndoRedo;
import com.iizix.prop.vs.IVSAccessor;
import com.iizix.prop.vs.IVSParticipant;
import com.iizix.prop.vs.VirtualSpace;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class VSHelper {
    public static EditorVirtualSpace getVirtualSpace(Shell shell, ModuleModel moduleModel, IVSAccessor iVSAccessor, IPropUndoRedo iPropUndoRedo) {
        EditorVirtualSpace editorVirtualSpace = (EditorVirtualSpace)iVSAccessor.getVirtualSpace();
        if (editorVirtualSpace != null) {
            return editorVirtualSpace;
        }
        return iVSAccessor instanceof IVSParticipant ? VSHelper.getVirtualSpace(shell, moduleModel, (IVSParticipant)iVSAccessor, iPropUndoRedo) : null;
    }

    public static EditorVirtualSpace getVirtualSpace(Shell shell, ModuleModel moduleModel, IVSParticipant iVSParticipant, IPropUndoRedo iPropUndoRedo) {
        Object object;
        EditorVirtualSpace editorVirtualSpace = (EditorVirtualSpace)iVSParticipant.getVirtualSpace();
        if (editorVirtualSpace != null) {
            return editorVirtualSpace;
        }
        ApplicationUI applicationUI = ApplicationUI.getInstance();
        MessageDialog messageDialog = new MessageDialog(shell, "Create/Connect VirtualSpace", applicationUI.imageVirtualSpace, "The VirtualSpace connection is not set for the " + iVSParticipant.getParticipantType() + ".\n\nDo you wish to Connect to an existing VirtualSpace or to Create and connect to a New VirtualSpace?", 3, new String[]{"Connect", "Create", "Cancel"}, 0);
        switch (messageDialog.open()) {
            case 0: {
                object = new SelectPropDialog(shell, "Select VirtualSpace for Connection", applicationUI.imageVirtualSpace, moduleModel, null, new SelectPropViewerFilter(new Class[]{EditorVirtualSpace.class}), new Class[]{EditorVirtualSpace.class}, "", 4);
                String string = ((SelectPropDialog)((Object)object)).open();
                if (string == null) {
                    return null;
                }
                GProp gProp = iVSParticipant.getPropFromReference(string);
                if (!(gProp instanceof EditorVirtualSpace)) {
                    ILog.WARNING(VSHelper.class, (String)("Selected VirtualSpace " + string + " not found!"));
                    return null;
                }
                editorVirtualSpace = (EditorVirtualSpace)gProp;
                break;
            }
            case 1: {
                NewVirtualSpaceWizard newVirtualSpaceWizard = new NewVirtualSpaceWizard(false);
                WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)newVirtualSpaceWizard);
                if (wizardDialog.open() != 0) {
                    return null;
                }
                editorVirtualSpace = newVirtualSpaceWizard.getVirtualSpace();
                break;
            }
            default: {
                return null;
            }
        }
        object = new ComplexOperation("Assign VirtualSpace to " + iVSParticipant.getParticipantType(), null, iPropUndoRedo);
        iVSParticipant.assignVirtualSpace((VirtualSpace)editorVirtualSpace, (IComplexOperation)object);
        PropHelper.executeOperation(shell, (AbstractOperation)object);
        return editorVirtualSpace;
    }
}

