/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.quickfix.fixer;

import com.iizigo.Activator;
import com.iizigo.quickfix.QuickFixAdapter;
import com.iizix.ILog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DeleteFile
extends QuickFixAdapter {
    public static final String ID = "DeleteFile";

    @Override
    public void run(IMarker iMarker) {
        IResource iResource = iMarker.getResource();
        if (!(iResource instanceof IFile)) {
            ILog.SEVERE(DeleteFile.class, (String)("Resource '" + iResource.getName() + "' is not a file"));
        } else if (iResource.exists()) {
            try {
                iResource.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                Activator.statusMessageBox(null, "Delete file error", "Failed deleting the file.", coreException.getStatus());
            }
        } else {
            ILog.WARNING(DeleteFile.class, (String)("File '" + iResource.getName() + "' no longer exist"));
        }
    }

    @Override
    public String getLabel() {
        return "Delete the file";
    }
}

