/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ErrorRendering
extends AbstractMemoryRendering {
    private TextViewer fTextViewer;
    private final String fRenderingId;
    private final Throwable fException;

    public ErrorRendering(String renderingId, Throwable exception) {
        super("org.eclipse.debug.internal.ui.views.memory.errorrendering");
        this.fRenderingId = renderingId;
        this.fException = exception;
    }

    @Override
    public Control createControl(Composite parent) {
        this.fTextViewer = new TextViewer(parent, 8);
        this.fTextViewer.setDocument((IDocument)new Document());
        StyledText styleText = this.fTextViewer.getTextWidget();
        styleText.setText("\r\n\r\n" + DebugUIMessages.EmptyViewTab_Unable_to_create + "\n" + this.getRenderingName() + "\n\n" + DebugUIMessages.ErrorRendering_0 + this.fException.getMessage());
        return this.fTextViewer.getControl();
    }

    private String getRenderingName() {
        if (DebugUITools.getMemoryRenderingManager().getRenderingType(this.fRenderingId) != null) {
            String name = DebugUITools.getMemoryRenderingManager().getRenderingType(this.fRenderingId).getLabel();
            return name;
        }
        return "Unknown";
    }

    @Override
    public Control getControl() {
        return this.fTextViewer.getControl();
    }

    public void refresh() {
    }
}

