/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.oauth;

import com.github.scribejava.core.builder.ServiceBuilder;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.oauth.OAuth10aService;
import com.github.scribejava.core.oauth.OAuth20Service;
import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.comm.oauth.IOAuthListener;
import com.iizix.comm.oauth.IOAuthService;
import com.iizix.server.oauth.AccessToken;
import com.iizix.server.oauth.OAuthSession;
import com.iizix.user.UserProfileInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AbstractOAuthService
implements IOAuthService {
    protected static final String ACCEPT_LANGUAGE = "en-US";
    protected final OAuthSession session;
    protected final OAuth10aService service1;
    protected final OAuth20Service service2;
    private OAuth1RequestToken a;
    protected AccessToken accessToken;
    String a;

    protected static void validate(String string, String string2, String ... stringArray) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("clientID is empty");
        }
        if (string2.isEmpty()) {
            throw new IllegalArgumentException("clientSecret is empty");
        }
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                if (string3.isEmpty()) {
                    throw new IllegalArgumentException("scope parameter is empty");
                }
                ++n2;
            }
        }
    }

    protected static ServiceBuilder createServiceBuilder(String string, String string2) {
        ServiceBuilder serviceBuilder = new ServiceBuilder(string).apiSecret(string2);
        OutputStream outputStream = AbstractOAuthService.getDebugOutputStream();
        if (outputStream != null) {
            serviceBuilder.debugStream(outputStream);
        }
        return serviceBuilder;
    }

    protected static OutputStream getDebugOutputStream() {
        return System.err;
    }

    protected AbstractOAuthService(OAuthSession oAuthSession, OAuth20Service oAuth20Service) {
        this.session = Objects.requireNonNull(oAuthSession);
        this.service1 = null;
        this.service2 = Objects.requireNonNull(oAuth20Service);
    }

    protected AbstractOAuthService(OAuthSession oAuthSession, OAuth10aService oAuth10aService) {
        this.session = Objects.requireNonNull(oAuthSession);
        this.service1 = Objects.requireNonNull(oAuth10aService);
        this.service2 = null;
    }

    protected long getRequestAdditionalTime() {
        return 20000L;
    }

    public abstract String getLogoutURL();

    public void disposeBlocked() {
        try {
            if (this.service2 != null) {
                this.service2.close();
            } else if (this.service1 != null) {
                this.service1.close();
            }
        }
        catch (IOException iOException) {
            ILog.WARNING(this.getClass(), (String)("Failed closeAsyncClient: " + String.valueOf(iOException)));
        }
        this.session.disposeBlocked();
    }

    public void disposeUserCancel() {
        try {
            if (this.service2 != null) {
                this.service2.close();
            } else if (this.service1 != null) {
                this.service1.close();
            }
        }
        catch (IOException iOException) {
            ILog.WARNING(this.getClass(), (String)("Failed closeAsyncClient: " + String.valueOf(iOException)));
        }
        this.session.disposeUserCancel();
    }

    public final void dispose() {
        try {
            if (this.service2 != null) {
                this.service2.close();
            } else if (this.service1 != null) {
                this.service1.close();
            }
        }
        catch (IOException iOException) {
            ILog.WARNING(this.getClass(), (String)("Failed closeAsyncClient: " + String.valueOf(iOException)));
        }
        this.session.dispose();
    }

    final String a() throws IOException, InterruptedException, ExecutionException {
        if (this.service2 != null) {
            return this.service2.getAuthorizationUrl(this.session.getState());
        }
        AccessToken accessToken = this.accessToken;
        if (accessToken != null) {
            throw new IllegalStateException("getClientAuthorizationUrl() illegal: access token already present");
        }
        OAuth1RequestToken oAuth1RequestToken = this.a;
        if (oAuth1RequestToken == null) {
            oAuth1RequestToken = this.a = this.service1.getRequestToken();
        }
        return this.service1.getAuthorizationUrl(oAuth1RequestToken);
    }

    public void doAuthenticate(IOAuthListener iOAuthListener) throws IOException, InterruptedException, ExecutionException {
        this.session.a(this, iOAuthListener);
    }

    protected final AccessToken getAccessToken() throws IOException, InterruptedException, ExecutionException {
        OAuth2AccessToken oAuth2AccessToken;
        IOAuthListener.Code code = this.session.getCompletionCode();
        if (code != IOAuthListener.Code.SUCCESS) {
            throw new IllegalStateException("Authentication not successful: completion code is " + String.valueOf(code));
        }
        AccessToken accessToken = this.accessToken;
        if (accessToken != null) {
            String string;
            if (accessToken.isValid(this.getRequestAdditionalTime())) {
                ILog.FINE(this.getClass(), (String)("Access Token was still valid: " + String.valueOf(accessToken)));
                return accessToken;
            }
            oAuth2AccessToken = accessToken.a;
            if (this.service2 != null && oAuth2AccessToken != null && (string = oAuth2AccessToken.getRefreshToken()) != null) {
                ILog.FINE(this.getClass(), (String)("Refreshing Access Token: " + String.valueOf(accessToken)));
                try {
                    oAuth2AccessToken = this.service2.refreshAccessToken(string);
                }
                catch (InterruptedException | UnsupportedOperationException | ExecutionException exception) {
                    ILog.WARNING(this.getClass(), (String)("Refreshing Access Token failed for " + this.getServiceName() + ": " + String.valueOf(exception)));
                    this.accessToken = null;
                }
            }
        }
        try {
            if (this.service2 != null) {
                ILog.FINE(this.getClass(), (String)("Trading the Request Token for an Access Token for OAuth 2.0 service \"" + this.getServiceName() + "\""));
                oAuth2AccessToken = this.service2.getAccessToken(this.session.getAuthenticationCode());
                accessToken = new AccessToken(oAuth2AccessToken);
            } else {
                ILog.FINE(this.getClass(), (String)("Trading the Request Token for an Access Token for OAuth 1.0a service \"" + this.getServiceName() + "\""));
                oAuth2AccessToken = this.service1.getAccessToken(this.a, this.session.getAuthenticationCode());
                accessToken = new AccessToken((OAuth1AccessToken)oAuth2AccessToken, this.a);
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            ILog.WARNING(this.getClass(), (String)("Requesting Access Token failed for \"" + this.getServiceName() + "\": " + String.valueOf(exception)));
            throw new IOException("Failed requesting new Access Token for service " + this.getServiceName(), exception);
        }
        ILog.FINE(this.getClass(), (String)("Access token will expire " + Utilities.formatDate((long)accessToken.getExpiresTime()) + " for service \"" + this.getServiceName() + "\""));
        return accessToken;
    }

    public boolean invalidateAccessToken() throws ExecutionException, InterruptedException, IOException {
        AccessToken accessToken = this.accessToken;
        this.accessToken = null;
        if (accessToken != null && this.service2 != null) {
            ILog.FINE(this.getClass(), (String)("Revoking AccessToken for service \"" + this.getServiceName() + ", token: " + String.valueOf(accessToken)));
            this.service2.revokeToken(accessToken.getAccessToken());
            return true;
        }
        return false;
    }

    public final OAuth2AccessToken getAccessToken2() throws IOException, InterruptedException, ExecutionException {
        if (this.service2 == null) {
            throw new IllegalStateException("OAuth 2.0 Service is not initialized");
        }
        return this.getAccessToken().a;
    }

    public final OAuth1AccessToken getAccessToken1() throws IOException, InterruptedException, ExecutionException {
        if (this.service1 == null) {
            throw new IllegalStateException("OAuth 1.0a Service is not initialized");
        }
        OAuth1AccessToken oAuth1AccessToken = this.getAccessToken().a;
        this.a = oAuth1AccessToken.getToken();
        return oAuth1AccessToken;
    }

    public abstract UserProfileInfo getUserProfileInfo() throws IOException, InterruptedException, ExecutionException;
}

