/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.db;

import com.iizix.IFileURLResolver;
import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.jdbc.DerbyImpl;
import com.iizix.jdbc.IDBConnectionPool;
import com.iizix.jdbc.JDBCHelper;
import com.iizix.server.db.IDBPoolProxy;
import com.iizix.server.db.a;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DBUtilities {
    public static final String DEFAULT_DATABASE_DIRECTORY = "db";
    private static boolean a = true;
    private static boolean b = true;
    private static String a = "localhost";
    private static int a = 1527;
    private static String b = "db";
    private static IDBConnectionPool a;
    private static IFileURLResolver a;
    private static IDBConnectionPool.Flavor a;
    private static File a;
    private static int b;

    static {
        a = new a();
        a = IDBConnectionPool.Flavor.FLAVOR_UNKNOWN;
    }

    public static IDBConnectionPool.Flavor getJDBCFlavor() {
        return a;
    }

    public static void setDBConfDir(String string) throws FileNotFoundException {
        File file = Utilities.getCanonicalFile((String)string);
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Database configuration directory \"" + file.getPath() + "\" is not found");
        }
        File file2 = new File(file, "dbconf.properties");
        if (!file2.isFile()) {
            throw new FileNotFoundException("Database configuration file \"" + file2.getPath() + "\" is not found");
        }
        a = file;
    }

    public static void setFileURLResolver(IFileURLResolver iFileURLResolver) {
        a = Objects.requireNonNull(iFileURLResolver);
    }

    public static void setAutoCreate(boolean bl) {
        b = bl;
    }

    public static void setServerAutoStart(boolean bl) {
        a = bl;
    }

    public static void setServerHost(String string) {
        if (string == null) {
            throw new NullPointerException("host is null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Host name is empty for Client Derby driver");
        }
        a = string;
    }

    public static String getServerHost() {
        return a;
    }

    public static void setServerPort(int n) {
        if (n < 1 || n > 65534) {
            throw new IllegalArgumentException("Port must be 1 to 65534 for Client Derby driver");
        }
        a = n;
    }

    public static int getServerPort() {
        return a;
    }

    public static void setDirectory(String string) throws FileNotFoundException, IOException {
        File file = new File(string).getCanonicalFile();
        if (!file.exists()) {
            throw new FileNotFoundException("Database directory \"" + file.getPath() + "\" does not exist");
        }
        if (!file.isDirectory()) {
            throw new FileNotFoundException("Database directory \"" + file.getPath() + "\" is not a directory");
        }
        b = file.getPath();
    }

    public static String getDatabaseDirectory() {
        return b;
    }

    public static void registerPoolProxy(IDBPoolProxy iDBPoolProxy) throws SQLException {
        if (!iDBPoolProxy.getClass().getName().startsWith("com.iizix.")) {
            throw new SecurityException("Access denied");
        }
        iDBPoolProxy.assignConnectionPool(DBUtilities.a());
    }

    private static synchronized IDBConnectionPool a() throws SQLException {
        return DBUtilities.getConnectionPool(a);
    }

    public static synchronized IDBConnectionPool getConnectionPool(IFileURLResolver iFileURLResolver) throws SQLException {
        if (a == null) {
            try {
                Connection connection;
                Object var6_9;
                Object object;
                IDBConnectionPool iDBConnectionPool;
                Object object2;
                long l = System.currentTimeMillis();
                try {
                    object2 = JDBCHelper.initialize((IFileURLResolver)iFileURLResolver);
                    if (a != null) {
                        iDBConnectionPool = JDBCHelper.from((String)"iiziServer Database", (File)a);
                    } else {
                        object = new DerbyImpl((File)object2, new File(b), a, a, a, "iiziServer", b, "iiziServer", "iizi");
                        iDBConnectionPool = JDBCHelper.from((String)"iiziServer Database", (DerbyImpl)object);
                    }
                }
                catch (Throwable throwable) {
                    throw new SQLException("Failed creating iiziServer database pool", throwable);
                }
                a = iDBConnectionPool.getFlavor();
                object2 = "createPool";
                try {
                    object = null;
                    var6_9 = null;
                    try {
                        connection = iDBConnectionPool.getConnection();
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (Exception exception) {
                    throw new SQLException("Failed creating database connection pool (" + (String)object2 + ")", exception);
                }
                if (b) {
                    try {
                        object = null;
                        var6_9 = null;
                        try {
                            connection = iDBConnectionPool.getConnection();
                            try {
                                if (!DBUtilities.a(connection)) {
                                    ILog.INFO(DBUtilities.class, (String)"Creating internal server database tables");
                                    DBUtilities.a(connection);
                                    connection.commit();
                                }
                            }
                            finally {
                                if (connection != null) {
                                    connection.close();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            throw object;
                        }
                    }
                    catch (SQLException sQLException) {
                        throw new SQLException("Failed creating tables", sQLException);
                    }
                }
                a = iDBConnectionPool;
                ILog.FINE(DBUtilities.class, (String)("Database connection pool " + a.getName() + " created @" + (System.currentTimeMillis() - l) + "ms"));
                b = 1;
            }
            finally {
                if (b == 0) {
                    b = -1;
                }
            }
        }
        return a;
    }

    private static boolean a(Connection connection) {
        return DBUtilities.isTableCreated(connection, "IZS", "SUBSCRIPTIONS");
    }

    public static boolean isTableCreated(Connection connection, String string, String string2) {
        block12: {
            Throwable throwable = null;
            Object var4_6 = null;
            Statement statement = connection.createStatement();
            try {
                statement.executeQuery("SELECT * FROM " + string + "." + string2 + " WHERE 1=0").close();
                if (statement == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException sQLException) {
                    return false;
                }
            }
            statement.close();
        }
        return true;
    }

    public static int getServerDatabaseReady() {
        return b;
    }

    public static Connection getPooledConnection() throws SQLException {
        return DBUtilities.a().getConnection();
    }

    private static synchronized void a(Connection connection) throws SQLException {
        Object object = DBUtilities.class.getName().replace('.', '/');
        object = ((String)object).substring(0, ((String)object).lastIndexOf(47) + 1) + "createBaseTables.sql";
        ILog.INFO(DBUtilities.class, (String)("Creating base tables from SQL file " + (String)object));
        InputStream inputStream = DBUtilities.class.getClassLoader().getResourceAsStream((String)object);
        if (inputStream == null) {
            throw new SQLException("Failed opening \"" + (String)object + "\"");
        }
        try {
            DBUtilities.createTables(connection, inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static synchronized void createTables(Connection connection, InputStream inputStream) throws SQLException {
        DBUtilities.createTables(a, connection, inputStream, StandardCharsets.UTF_8, 4096);
    }

    public static synchronized void createTables(IDBConnectionPool.Flavor flavor, Connection connection, InputStream inputStream, Charset charset, int n) throws SQLException {
        int n2;
        Object object;
        Closeable closeable;
        String string;
        Object object2;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        String string4 = "GENERATED BY DEFAULT AS IDENTITY";
        StringBuilder stringBuilder = new StringBuilder();
        try {
            object2 = null;
            string = null;
            try {
                closeable = new BufferedReader(new InputStreamReader(inputStream, charset));
                try {
                    while ((object = ((BufferedReader)closeable).readLine()) != null) {
                        int n3 = ((String)object).indexOf("--");
                        if (n3 >= 0) {
                            object = ((String)object).substring(0, n3);
                        }
                        object = ((String)object).trim();
                        if (flavor == IDBConnectionPool.Flavor.FLAVOR_MYSQL && (n3 = ((String)object).indexOf(string4)) > 0) {
                            object = ((String)object).substring(0, n3) + "AUTO_INCREMENT" + ((String)object).substring(n3 + string4.length());
                        }
                        if (flavor == IDBConnectionPool.Flavor.FLAVOR_DERBY) {
                            n3 = ((String)object).indexOf("TEXT(");
                            if (n3 > 0) {
                                object = ((String)object).substring(0, n3) + "VARCHAR(" + ((String)object).substring(n3 + 5);
                            }
                            n3 = ((String)object).indexOf("TEXT ");
                            n2 = ((String)object).indexOf("TEXT");
                            if (n3 < 0 && n2 > 0) {
                                n3 = n2;
                            }
                            if (n3 > 0) {
                                object = ((String)object).substring(0, n3) + "VARCHAR(" + n + ")" + ((String)object).substring(n3 + 4);
                            }
                            object = ((String)object).replace("MEDIUMBLOB", "BLOB      ").replace("LONGBLOB", "BLOB      ");
                        }
                        while (((String)object).indexOf(" ,") >= 0) {
                            object = ((String)object).replace(" ,", ",");
                        }
                        stringBuilder.append((String)object).append('\n');
                    }
                }
                finally {
                    if (closeable != null) {
                        ((BufferedReader)closeable).close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (object2 == null) {
                    object2 = throwable;
                } else if (object2 != throwable) {
                    ((Throwable)object2).addSuppressed(throwable);
                }
                throw object2;
            }
        }
        catch (IOException iOException) {
            throw new SQLException("Failed loading the SQL statements to create the database tables", iOException);
        }
        object2 = new StringTokenizer(stringBuilder.toString(), ";");
        while (((StringTokenizer)object2).hasMoreTokens()) {
            IDBConnectionPool.Flavor flavor2;
            Object object3;
            Object object4;
            string = ((StringTokenizer)object2).nextToken().trim();
            if (string.isEmpty()) continue;
            closeable = new StringWriter();
            try {
                object = new BufferedReader(new StringReader(string));
                while ((object4 = ((BufferedReader)object).readLine()) != null) {
                    n2 = ((String)object4).indexOf("--");
                    if (n2 >= 0) {
                        object4 = ((String)object4).substring(0, n2);
                    }
                    if (((String)(object4 = ((String)object4).trim())).isEmpty()) continue;
                    ((StringWriter)closeable).write((String)object4);
                    ((StringWriter)closeable).write(10);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (((String)(object = ((StringWriter)closeable).toString().trim())).isEmpty() || ((String)object).replace(';', ' ').isBlank()) continue;
            object4 = "";
            n2 = ((String)object).indexOf(":");
            if (n2 > 0 && ((String)object).startsWith("FLAVOR_")) {
                object3 = ((String)object).substring(0, n2);
                try {
                    flavor2 = IDBConnectionPool.Flavor.valueOf((String)object3);
                    if (flavor2 != flavor) continue;
                    object = ((String)object).substring(n2 + 1).trim();
                    object4 = " flavored statement for " + String.valueOf(flavor2);
                }
                catch (Throwable throwable) {
                    throw new SQLException("Unknown database flavor '" + (String)object3 + "', statement: " + (String)object);
                }
            }
            if (((String)object).startsWith("CREATE TABLE ")) {
                object3 = new StringTokenizer((String)object, " ");
                ((StringTokenizer)object3).nextToken();
                ((StringTokenizer)object3).nextToken();
                string2 = ((StringTokenizer)object3).nextToken(".");
                string3 = ((StringTokenizer)object3).nextToken(". ");
                if (DBUtilities.isTableCreated(connection, string2, string3)) {
                    bl = false;
                    ILog.INFO(DBUtilities.class, (String)("IGNORING CREATION OF TABLE \"" + string2 + "." + string3 + "\" --> IT ALREADY EXISTS"));
                    continue;
                }
                bl = true;
            } else if (!bl) {
                ILog.INFO(DBUtilities.class, (String)("TABLE \"" + string2 + "." + string3 + "\" ALREADY EXISTS --> IGNORING execution of" + (String)object4 + ":\n    " + ((String)object).replace("\n", "\n    ") + ";"));
                continue;
            }
            ILog.INFO(DBUtilities.class, (String)("Executing" + (String)object4 + ":\n    " + ((String)object).replace("\n", "\n    ") + ";"));
            object3 = null;
            flavor2 = null;
            try (Statement statement = connection.createStatement();){
                statement.execute((String)object);
            }
            catch (Throwable throwable) {
                if (object3 == null) {
                    object3 = throwable;
                } else if (object3 != throwable) {
                    ((Throwable)object3).addSuppressed(throwable);
                }
                throw object3;
            }
            connection.commit();
        }
    }
}

