/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.agreement;

import com.iizix.ILog;
import com.iizix.location.LocationUtils;
import com.iizix.prop.GeoLocation;
import com.iizix.server.agreement.LicenseAgreement;
import com.iizix.server.db.DBFunctions;
import com.iizix.server.gyro.ClientSessionGyro;
import com.iizix.server.user.AuthenticatedUser;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.json.JSONException;

public class AcceptedAgreement {
    public final LicenseAgreement agreement;
    public final String languageCode;
    public final AuthenticatedUser user;
    public final InetAddress remoteAddress;

    public AcceptedAgreement(LicenseAgreement licenseAgreement, String string, AuthenticatedUser authenticatedUser, ClientSessionGyro clientSessionGyro) {
        this.agreement = licenseAgreement;
        this.user = authenticatedUser;
        this.languageCode = string;
        SocketAddress socketAddress = clientSessionGyro.getClientEndPoint().getSessionInfo().getRemoteAddress();
        this.remoteAddress = socketAddress instanceof InetSocketAddress ? ((InetSocketAddress)socketAddress).getAddress() : null;
    }

    public String getIPAddress() {
        Object object;
        if (this.remoteAddress == null) {
            object = "n/a";
        } else {
            object = this.remoteAddress.toString();
            if (this.remoteAddress instanceof Inet6Address && ((String)object).length() < 41 && !((String)object).startsWith("[")) {
                object = "[" + (String)object + "]";
            }
        }
        return object;
    }

    private GeoLocation a() {
        try {
            return this.remoteAddress != null ? LocationUtils.getGeoLocation((InetAddress)this.remoteAddress) : null;
        }
        catch (IOException | JSONException throwable) {
            ILog.WARNING(this.getClass(), (String)("Failed retrieving the geolocation of IP address " + String.valueOf(this.remoteAddress) + ": " + throwable.getMessage()));
            return null;
        }
    }

    public void setAccepted() {
        try {
            Double d2 = null;
            Double d3 = null;
            GeoLocation geoLocation = this.a();
            if (geoLocation != null && !Double.isNaN(geoLocation.longitude) && Double.isNaN(geoLocation.latitude)) {
                d2 = geoLocation.longitude;
                d3 = geoLocation.latitude;
            }
            String string = "n/a";
            if (this.remoteAddress != null && (string = this.remoteAddress.getHostAddress()).length() > 41) {
                string = string.substring(0, 41);
            }
            String string2 = string;
            Double d4 = d2;
            Double d5 = d3;
            String string3 = "INSERT INTO IZS.ACC_AGR (id,lang_code,uid,accepted,ip_address,longitude,latitude) VALUES(" + this.agreement.a + ",?," + this.user.getBasicUserInfo().id + "," + System.currentTimeMillis() + ",?,?,?)";
            DBFunctions.execute(connection -> {
                Throwable throwable = null;
                Object var7_8 = null;
                try (PreparedStatement preparedStatement = connection.prepareStatement(string3);){
                    preparedStatement.setString(1, this.languageCode);
                    preparedStatement.setString(2, string2);
                    if (d4 == null || d5 == null) {
                        preparedStatement.setNull(3, 8);
                        preparedStatement.setNull(4, 8);
                    } else {
                        preparedStatement.setDouble(3, d4);
                        preparedStatement.setDouble(4, d5);
                    }
                    int n = preparedStatement.executeUpdate();
                    if (n == 0) {
                        throw new SQLException("Failed adding user: no row affected for " + String.valueOf(this.user));
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                connection.commit();
                return true;
            });
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), (String)"Failed accepting user agreement", (Object[])new Object[]{throwable, this.agreement});
        }
    }
}

