/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.security;

import com.iizix.Utilities;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class GenerateKeystore {
    public static void initialize() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static KeyStore generateSelfSignedX509Certificate(X500Principal x500Principal, String string, char[] cArray) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalStateException, SignatureException, KeyStoreException, CertificateException, IOException {
        ContentSigner contentSigner;
        X500Name x500Name = X500Name.getInstance((Object)x500Principal.getEncoded());
        long l2 = System.currentTimeMillis();
        Date date = new Date(l2 - 86400000L);
        Date date2 = new Date(new Date(l2).getYear() + 20, 0, 1);
        SecureRandom secureRandom = Utilities.getSecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(2048, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PrivateKey privateKey = keyPair.getPrivate();
        JcaX509v3CertificateBuilder jcaX509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x500Name, BigInteger.valueOf(l2 * 47L * secureRandom.nextLong() & 0xFFFFFFFFFFFFL), date, date2, x500Name, keyPair.getPublic());
        try {
            contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(privateKey);
        }
        catch (OperatorCreationException operatorCreationException) {
            throw new SignatureException("Failed creation of JcaContentSignerBuilder for signing algorithm SHA256WithRSAEncryption", operatorCreationException);
        }
        X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(jcaX509v3CertificateBuilder.build(contentSigner));
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        keyStore.setKeyEntry(string, privateKey, cArray, new X509Certificate[]{x509Certificate});
        return keyStore;
    }

    private static X509Certificate a(X509v3CertificateBuilder x509v3CertificateBuilder, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509v3CertificateBuilder.build(contentSigner));
    }

    private static SubjectKeyIdentifier a(Key key) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(key.getEncoded());
        Throwable throwable = null;
        Object var3_4 = null;
        try (ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);){
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            return new BcX509ExtensionUtils().createSubjectKeyIdentifier(SubjectPublicKeyInfo.getInstance((Object)aSN1Sequence));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static KeyStore createCodeSigningCertificateKeystore(X500Principal x500Principal, String string, char[] cArray, KeyStore keyStore, String string2, char[] cArray2) throws NoSuchAlgorithmException, NoSuchProviderException, CertIOException, IOException, OperatorCreationException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        PrivateKey privateKey;
        X500Name x500Name = X500Name.getInstance((Object)x500Principal.getEncoded());
        SecureRandom secureRandom = Utilities.getSecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "BC");
        keyPairGenerator.initialize(4096, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X500Name x500Name2 = x500Name;
        BigInteger bigInteger = new BigInteger(384, secureRandom);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey2 = privateKey = keyPair.getPrivate();
        Certificate[] certificateArray = null;
        if (keyStore != null) {
            certificateArray = keyStore.getCertificateChain(string2);
            privateKey2 = (PrivateKey)keyStore.getKey(string2, cArray2);
            x500Name2 = X500Name.getInstance((Object)((X509Certificate)certificateArray[0]).getSubjectX500Principal().getEncoded());
        }
        long l2 = System.currentTimeMillis();
        Date date = new Date(l2 - 86400000L);
        Date date2 = new Date(new Date(l2).getYear() + 20, 0, 1);
        X509v3CertificateBuilder x509v3CertificateBuilder = new JcaX509v3CertificateBuilder(x500Name2, bigInteger, date, date2, x500Name, publicKey).addExtension(Extension.subjectKeyIdentifier, true, (ASN1Encodable)GenerateKeystore.a(publicKey)).addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(certificateArray == null)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(240));
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add((ASN1Encodable)KeyPurposeId.id_kp_codeSigning);
        aSN1EncodableVector.add((ASN1Encodable)KeyPurposeId.id_kp_timeStamping);
        x509v3CertificateBuilder.addExtension(Extension.extendedKeyUsage, true, (ASN1Encodable)new DERSequence(aSN1EncodableVector));
        X509Certificate x509Certificate = GenerateKeystore.a(x509v3CertificateBuilder, privateKey2);
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        arrayList.add(x509Certificate);
        if (certificateArray != null) {
            arrayList.addAll(List.of(certificateArray));
        }
        KeyStore keyStore2 = KeyStore.getInstance("PKCS12");
        keyStore2.load(null, null);
        keyStore2.setKeyEntry(string, privateKey, cArray, arrayList.toArray(new Certificate[arrayList.size()]));
        return keyStore2;
    }
}

