/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.Utilities;
import com.iizix.XMLUtilities;
import com.iizix.event.EventListener;
import com.iizix.event.GEvent;
import com.iizix.event.PropValueEvent;
import com.iizix.event.RemoteEvent;
import com.iizix.event.ResolveReferencesEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IGProp;
import com.iizix.prop.IKStringPropOwner;
import com.iizix.prop.IPropReference;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.PropValidateException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.TextTable;
import com.iizix.text.IKStringHyperlinkType;
import com.iizix.text.IKStringValuePropHolder;
import com.iizix.text.KString;
import com.iizix.text.KStringException;
import com.iizix.text.KStringHolder;
import com.iizix.text.KStringParseException;
import com.iizix.text.PlainKString;
import org.w3c.dom.Element;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class KStringProp
extends GProp<KString>
implements IKStringValuePropHolder<KString> {
    private static final Class<?>[] a = new Class[]{KString.class, PlainKString.class, String.class, StringBuilder.class, StringBuffer.class, char[].class, byte[].class, Long.class, Integer.class, Short.class, Byte.class, Double.class, Float.class, Character.class};
    private KStringHolder a = new KStringHolder(this);

    protected KStringProp() {
    }

    public KStringProp(Atom atom) {
        super(atom);
    }

    public KStringProp(Atom atom, KString kString) {
        super(atom);
        try {
            super.setPropValue(kString);
        }
        catch (PropException propException) {
            throw new InternalError("Shouldn't be", propException);
        }
    }

    public KStringProp(Atom atom, String string) {
        super(atom);
        try {
            super.setPropValue(KString.newPlainKString(string));
        }
        catch (PropException propException) {
            throw new InternalError("Shouldn't be", propException);
        }
    }

    @Override
    public KStringProp clone() {
        try {
            KStringProp kStringProp = (KStringProp)super.clone();
            kStringProp.a = new KStringHolder(kStringProp);
            KString kString = (KString)kStringProp.getPropValue();
            if (kString != null) {
                boolean bl = kStringProp.isPropNullable();
                if (!bl) {
                    kStringProp.setPropNullable(true);
                }
                kStringProp.setPropValueIncognito(null);
                if (!bl) {
                    kStringProp.setPropNullable(false);
                }
                kStringProp.setPropValue(kString.clone());
            }
            return kStringProp;
        }
        catch (PropException | CloneNotSupportedException exception) {
            throw new InternalError("Shouldn't be", exception);
        }
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPLAINString(String string) throws PropTypeException, PropValidateException {
        try {
            return super.setPropValue(KString.newPlainKString(string));
        }
        catch (PropTypeException | PropValidateException propException) {
            throw propException;
        }
        catch (PropException propException) {
            throw new InternalError("setPLAINString failed: " + String.valueOf(propException));
        }
    }

    public boolean setPLAINString(String string, boolean bl) throws PropTypeException, PropValidateException, KStringException, KStringParseException {
        try {
            return bl ? super.setPropValue(new PlainKString(string, true)) : super.setPropValue(KString.newPlainKString(string));
        }
        catch (PropTypeException | PropValidateException propException) {
            throw propException;
        }
        catch (PropException propException) {
            throw new InternalError("setPLAINString failed: " + String.valueOf(propException));
        }
    }

    public boolean setHTMLString(String string) throws PropTypeException, PropValidateException, KStringException, KStringParseException {
        try {
            return super.setPropValue(new KString(KString.Type.HTML, string, true));
        }
        catch (PropValidateException propValidateException) {
            throw propValidateException;
        }
        catch (PropException propException) {
            throw new InternalError("setPLAINString failed: " + String.valueOf(propException));
        }
    }

    public boolean setPropValue(String string) throws PropTypeException, PropValidateException {
        return this.setPLAINString(string);
    }

    public boolean setPropValue(KString kString) throws PropTypeException, PropValidateException {
        try {
            return super.setPropValue(kString);
        }
        catch (PropTypeException | PropValidateException propException) {
            throw propException;
        }
        catch (PropException propException) {
            throw new InternalError(propException.getMessage(), propException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof KString)) {
            throw new PropTypeException(this, "newValue not a KString");
        }
    }

    public String getString() {
        KString kString = (KString)this.getPropValueObject();
        return kString != null ? kString.getPLAINString(this) : null;
    }

    public String getString(String string) {
        String string2 = this.getString();
        return string2 == null ? string : string2;
    }

    @Override
    public KString getKString() {
        return (KString)this.getPropValue();
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        String string = "";
        if (object != null) {
            IKStringPropOwner iKStringPropOwner;
            KStringHolder kStringHolder = this.a;
            if (kStringHolder != null) {
                kStringHolder.resolveBeforeSend();
            }
            KString kString = (KString)object;
            PropCnr propCnr = this.getParent();
            string = propCnr instanceof IKStringPropOwner && !(iKStringPropOwner = (IKStringPropOwner)((Object)propCnr)).doSendHTML(this) ? kString.getPLAINString(propMgr.getProvider()) : kString.getHTMLString(propMgr.getProvider());
        }
        sendTransaction.appendString(string);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        KString kString;
        IKStringPropOwner iKStringPropOwner;
        PropCnr propCnr = this.getParent();
        boolean bl = propCnr instanceof IKStringPropOwner && !(iKStringPropOwner = (IKStringPropOwner)((Object)propCnr)).doReadHTML(this);
        String string = readTransaction.readString();
        try {
            kString = bl ? KString.newPlainKString(string) : new KString(KString.Type.HTML, string);
        }
        catch (KStringException kStringException) {
            ILog.SEVERE(this.getClass(), "Failed creating KString from Transaction", kStringException);
            kString = KString.EMPTY;
        }
        return this.setPropValue((Object)kString, propMgr);
    }

    @Override
    protected void initializeElement(Element element) {
        KString kString = this.getKString();
        if (kString == null) {
            element.removeAttribute("value");
        } else {
            kString.toElement(element);
            if (this.isUserValidated()) {
                element.setAttribute("validated", "true");
            }
        }
    }

    @Override
    protected void initializeProp(Element element) throws PropException {
        try {
            KString kString = KString.createKString(element);
            if (kString == null) {
                this.setPropNullable(true);
            }
            this.setPropValue(kString);
            if (kString != null && Boolean.parseBoolean(element.getAttribute("value"))) {
                this.setUserValidated(true);
            }
        }
        catch (KStringException kStringException) {
            Object object;
            try {
                object = ": " + XMLUtilities.getNodeString(element);
            }
            catch (Exception exception) {
                object = "";
            }
            throw new PropException(this, "Failed creating KString from Element" + (String)object, kStringException);
        }
    }

    @Override
    public IPropReference.IRefType getReferenceType() {
        return IPropReference.RefType.KString;
    }

    @Override
    public final IGProp<?> getReferencingOwner() {
        PropCnr propCnr = this.getParent();
        return propCnr instanceof TextTable ? this : propCnr;
    }

    @Override
    public void onEventSelf(GEvent gEvent) {
        switch (gEvent.getEventID()) {
            case 1: 
            case 9: 
            case 10: 
            case 11: {
                this.resolveKStrings(false, gEvent);
            }
        }
    }

    @Override
    protected void onReferenceEvent(ResolveReferencesEvent resolveReferencesEvent) {
        KStringHolder kStringHolder;
        if (resolveReferencesEvent.isPostResolving() && (kStringHolder = this.a) != null) {
            kStringHolder.resolve(resolveReferencesEvent.doReCheck(), resolveReferencesEvent);
        }
    }

    @Override
    public void resolveKStrings(boolean bl, GEvent gEvent) {
        KStringHolder kStringHolder = this.a;
        if (kStringHolder != null) {
            kStringHolder.resolve(bl, gEvent);
        }
    }

    @Override
    protected void onPropDispose() {
        KStringHolder kStringHolder;
        KString kString = this.getKString();
        if (kString != null) {
            kString.dispose();
        }
        if ((kStringHolder = this.a) != null) {
            this.a = null;
            kStringHolder.disposeHolder();
        }
        super.onPropDispose();
    }

    @Override
    public void onRemoteEvent(RemoteEvent remoteEvent) {
        if (remoteEvent.getLocalID() == 1) {
            IKStringHyperlinkType.processHyperlink(this, remoteEvent);
        }
    }

    @Override
    public synchronized void onKStringRefactored(KStringHolder kStringHolder, GEvent gEvent) {
        EventListener eventListener = gEvent2 -> {
            KString kString;
            if (!this.isDisposed() && (kString = kStringHolder.getRefactoredKString()) != null) {
                KStringProp kStringProp = gEvent.getTrigger();
                if (kStringProp == null) {
                    kStringProp = this;
                }
                try {
                    this.setPropValue((Object)kString, kStringProp);
                }
                catch (PropException propException) {
                    ILog.WARNING(this.getClass(), "Failed refactoring property \"" + this.getReferencePropName() + "\" KString to: " + String.valueOf(kString), propException);
                }
            }
        };
        if (gEvent != null) {
            gEvent.addPostProcessor(eventListener);
        } else {
            eventListener.onEvent(null);
        }
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        String string = ((KString)object).getPLAINString(this);
        switch (n2) {
            case 1: {
                return string;
            }
            case 2: {
                return string;
            }
            case 3: {
                return new StringBuilder(string);
            }
            case 4: {
                return new StringBuffer(string);
            }
            case 5: {
                return string.toCharArray();
            }
            case 6: {
                return Utilities.getBytes(string);
            }
            case 7: {
                return Long.valueOf(string);
            }
            case 8: {
                return Integer.valueOf(string);
            }
            case 9: {
                return Short.valueOf(string);
            }
            case 10: {
                return Byte.valueOf(string);
            }
            case 11: {
                return Double.valueOf(string);
            }
            case 12: {
                return Float.valueOf(string);
            }
            case 13: {
                int n3 = string.length();
                if (n3 != 1) {
                    throw new IllegalArgumentException("string length != 1: " + n3);
                }
                return Character.valueOf(string.charAt(0));
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        String string;
        switch (n2) {
            case 1: {
                return ((KString)object).toPlainKString();
            }
            case 2: {
                string = (String)object;
                break;
            }
            case 3: {
                string = ((StringBuilder)object).toString();
                break;
            }
            case 4: {
                string = ((StringBuffer)object).toString();
                break;
            }
            case 5: {
                string = new String((char[])object);
                break;
            }
            case 6: {
                string = Utilities.createString((byte[])object);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = object.toString();
                break;
            }
            case 13: {
                string = ((Character)object).toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return new KString(KString.Type.PLAIN, string, false);
    }

    @Override
    protected void onPropValueSet(Object object) {
        KStringHolder kStringHolder = this.a;
        if (kStringHolder != null) {
            kStringHolder.setKString(this.getKString());
        }
        this.removePropUSER(131072L);
    }

    public boolean isUserValidated() {
        return this.isPropUSER(131072L);
    }

    public boolean setUserValidated(boolean bl) {
        if (bl == this.isUserValidated()) {
            return false;
        }
        if (bl) {
            this.setPropUSER(131072L);
        } else {
            this.removePropUSER(131072L);
        }
        Object object = this.getPropValueObject();
        this.onEvent(new PropValueEvent(this, object, object));
        return true;
    }

    @Override
    protected Object equalValues(GProp<?> kStringProp, KString kString, KString kString2, int n2) {
        if ((n2 & 0x16) != 22) {
            if (((KStringProp)kStringProp).isUserValidated() != this.isUserValidated()) {
                return this;
            }
            return super.equalValues(kStringProp, kString, kString2, n2);
        }
        return kString != null ? (kString.equalsOmitReferenceRefreshCheck(kString2) ? null : this) : (kString2 == null ? null : kStringProp);
    }

    @Override
    public KString createNewPropValue(KString kString) {
        return kString;
    }

    public KStringProp lookupLanguageKStringProp(String string) {
        String string2;
        PropCnr propCnr = this.getParent();
        if (propCnr instanceof TextTable && (string2 = this.getPropName()) != null) {
            return ((TextTable)propCnr).getKStringProp(string2, string);
        }
        return null;
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        KStringHolder kStringHolder = this.a;
        if (kStringHolder != null && !this.isDisposed()) {
            kStringHolder.verify(propVerification, "KString");
        }
        return super.verify(propVerification);
    }
}

