/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary.requests;

import com.google.gson.annotations.SerializedName;
import com.tabnine.eclipse.shared.api.binary.requests.CapabilitiesResponse$Capability;
import com.tabnine.eclipse.shared.api.binary.requests.CapabilitiesResponse$ExperimentSource;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class CapabilitiesResponse {
    @SerializedName(value="enabled_features")
    private final List<String> features;
    @SerializedName(value="experiment_source")
    private final CapabilitiesResponse$ExperimentSource experimentSource;

    public CapabilitiesResponse(List<String> list, CapabilitiesResponse$ExperimentSource capabilitiesResponse$ExperimentSource) {
        this.features = list;
        this.experimentSource = capabilitiesResponse$ExperimentSource;
    }

    public Optional<List<CapabilitiesResponse$Capability>> getFeatures() {
        if (this.features == null) {
            return Optional.empty();
        }
        return Optional.of(this.features.stream().map(CapabilitiesResponse$Capability::fromString).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public Optional<List<String>> getRawFeatures() {
        return Optional.ofNullable(this.features);
    }

    public CapabilitiesResponse$ExperimentSource getExperimentSource() {
        return this.experimentSource;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.experimentSource, Arrays.hashCode(this.features.toArray())});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (CapabilitiesResponse)object;
        if (this.experimentSource != ((CapabilitiesResponse)object).experimentSource) {
            return false;
        }
        return Objects.equals(this.features, ((CapabilitiesResponse)object).features);
    }
}

