/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.image.prop;

import com.iizigo.ApplicationUI;
import com.iizigo.image.ImageHelper;
import com.iizigo.image.LastVerified;
import com.iizigo.image.SingleImageControl;
import com.iizigo.image.prop.EditorImageLocation;
import com.iizigo.image.prop.EditorImageStylesResolution;
import com.iizigo.image.prop.IEditorImage;
import com.iizigo.image.prop.IImagesBase;
import com.iizigo.image.prop.ILastVerified;
import com.iizigo.image.prop.ImageDesignerProp;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.IPropUndoContext;
import com.iizigo.prop.editor.IExtendsSelection;
import com.iizigo.prop.editor.dialog.SelectPropViewerFilter;
import com.iizix.Position;
import com.iizix.Size;
import com.iizix.prop.AssetReference;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.IntProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.image.ImagesDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EditorImagesDefinition
extends ImagesDefinition
implements IEditorImage,
IImagesBase,
ILastVerified,
IPropDesigner,
IPropUndoContext,
IExtendsSelection {
    private ImageDesignerProp a;
    private final UndoContext a;
    private final LastVerified a;
    private final Class<?>[] a = new ImageDesignerProp((PropCnr)this);
    private static final Class<?>[] b = new Class[]{EditorImagesDefinition.class};

    public EditorImagesDefinition() {
    }

    public EditorImagesDefinition(Atom atom) {
        super(atom);
    }

    @Override
    public LastVerified getLastVerified() {
        return this.a;
    }

    @Override
    public ImageDesignerProp getDesigner() {
        return this.a;
    }

    @Override
    public IUndoContext getUndoContext() {
        return this.a;
    }

    public EditorImagesDefinition clone() throws CloneNotSupportedException {
        EditorImagesDefinition editorImagesDefinition = (EditorImagesDefinition)super.clone();
        editorImagesDefinition.a = new ImageDesignerProp((PropCnr)editorImagesDefinition);
        return editorImagesDefinition;
    }

    public Class<?>[] getPossibleChildren() {
        return this.a;
    }

    @Override
    public Image getCNImage() {
        return ApplicationUI.getInstance().imageMultipleImages;
    }

    @Override
    public String getCNType() {
        return "Multiple Images Definition";
    }

    @Override
    public String getCNText(int n2) {
        PropCnr propCnr = this.getParent();
        return propCnr == null ? null : (n2 == 0 ? this.getParent().getPropName() : (n2 == 1 ? ImageHelper.getSize(this.a) : this.a.fileName));
    }

    @Override
    public Composite createTooltip(Composite composite) {
        AssetReference assetReference = this.getAssetReference();
        String string = this.getCNText(0);
        Composite composite2 = ImageHelper.createImageTooltipTopPart(composite, this.getCNImage(), this.getCNType(), string);
        SingleImageControl singleImageControl = ImageHelper.addImageTooltipImagePart(composite2, assetReference, null, null);
        ImageHelper.addImageTooltipBottomPart((PropCnr)this, composite2, assetReference, null, string, null, singleImageControl);
        Size size = this.getImageSize();
        FilePropCnr filePropCnr = (FilePropCnr)assetReference.getFileURIPropCnr();
        if (filePropCnr.getIFile() != null && size != null) {
            Object object;
            Label label = new Label(composite2, 0);
            label.setText("Image size:");
            label = new Label(composite2, 0);
            label.setText(size.width + " x " + size.height);
            ArrayList<Position> arrayList = new ArrayList<Position>();
            GProp[] gPropArray = this.getProps();
            int n2 = gPropArray.length;
            int n3 = 0;
            while (n3 < n2) {
                EditorImageLocation editorImageLocation;
                Position position3;
                object = gPropArray[n3];
                if (object instanceof EditorImageLocation && (position3 = (editorImageLocation = (EditorImageLocation)object).getLocation()) != null) {
                    arrayList.add(position3);
                }
                ++n3;
            }
            if (!arrayList.isEmpty()) {
                Collections.sort(arrayList, (position, position2) -> {
                    int n2 = position2.y - position.y;
                    return n2 == 0 ? position2.x - position.x : n2;
                });
                object = new ArrayList();
                n3 = arrayList.size();
                while (--n3 >= 0) {
                    ((ArrayList)object).add(assetReference);
                }
                ImageHelper.addImageTooltipPreviews(composite2, (ArrayList<AssetReference>)object, arrayList, size.width, size.height, singleImageControl);
            }
        }
        return composite2;
    }

    public Class<?>[] getExtendsPossibleClasses() {
        return b;
    }

    @Override
    public String getSelectPropDialogTitle() {
        return "Select Extends Image Definition";
    }

    @Override
    public ViewerFilter getSelectPropViewerFilter() {
        return new SelectPropViewerFilter(b);
    }

    public void onAssetReferenceChanged(AssetReference assetReference) {
        super.onAssetReferenceChanged(assetReference);
        ImageHelper.flagVerification((PropCnr)this);
    }

    public boolean verify(PropVerification propVerification) {
        Object object;
        Object object2;
        IntProp intProp;
        IntProp intProp2;
        if (!super.verify(propVerification)) {
            return false;
        }
        ImageHelper.verify((PropCnr)this, propVerification);
        LastVerified lastVerified = this.getLastVerified();
        if (lastVerified.success) {
            intProp2 = (IntProp)this.getProp("imageWidth", IntProp.class);
            if (intProp2 == null) {
                propVerification.add(new PropVerificationError("imageWidth.undef", PropVerificationError.Severity.ERROR, "Image width", (GProp)this, "Image width must be defined", new String[0]));
            } else {
                int n2 = intProp2.getInt();
                if (n2 <= 0 || n2 > lastVerified.width) {
                    propVerification.add(new PropVerificationError("imageWidth.range", PropVerificationError.Severity.ERROR, "Image width", (GProp)intProp2, "Image width range must be between 1 and " + lastVerified.width, new String[0]));
                }
            }
            intProp = (IntProp)this.getProp("imageHeight", IntProp.class);
            if (intProp == null) {
                propVerification.add(new PropVerificationError("imageHeight.undef", PropVerificationError.Severity.ERROR, "Image height", (GProp)this, "Image height must be defined", new String[0]));
            } else {
                int n3 = intProp.getInt();
                if (n3 <= 0 || n3 > lastVerified.height) {
                    propVerification.add(new PropVerificationError("imageHeight.range", PropVerificationError.Severity.ERROR, "Image height", (GProp)intProp, "Image height range must be between 1 and " + lastVerified.height, new String[0]));
                }
            }
        }
        intProp2 = this.getProps();
        intProp = new HashSet();
        IntProp intProp3 = intProp2;
        int n4 = ((IntProp)intProp3).length;
        int n5 = 0;
        while (n5 < n4) {
            IntProp intProp4 = intProp3[n5];
            if (intProp4 instanceof EditorImageLocation && (object2 = (object = (EditorImageLocation)intProp4).getLocation()) != null && !intProp.add(object2)) {
                propVerification.add(new PropVerificationError("dup.styleLocation", PropVerificationError.Severity.ERROR, "Image style and location", (GProp)object, "Image Style and Location is a duplicate", new String[]{"DeleteProperty", "OpenProp"}));
            }
            ++n5;
        }
        HashSet<Double> hashSet = new HashSet<Double>();
        object = intProp2;
        int n6 = ((IntProp)object).length;
        n4 = 0;
        while (n4 < n6) {
            double d2;
            IntProp intProp5 = object[n4];
            if (intProp5 instanceof EditorImageStylesResolution && (d2 = (object2 = (EditorImageStylesResolution)intProp5).getDevicePixelRatio()) > 0.0 && !hashSet.add(d2)) {
                propVerification.add(new PropVerificationError("dup.resolution", PropVerificationError.Severity.ERROR, "Image resolution", (GProp)object2, "Image Resolution is a duplicate", new String[]{"DeleteProperty", "OpenProp"}));
            }
            ++n4;
        }
        return true;
    }
}

