/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.app;

import com.iizigo.Activator;
import com.iizigo.app.EclipseIFile;
import com.iizigo.app.EclipseIProject;
import com.iizigo.app.prop.AppDistributionProps;
import com.iizigo.project.ModuleModel;
import com.iizigo.project.ProjectManager;
import com.iizix.ILog;
import com.iizix.IPluginDescriptor;
import com.iizix.app.CancelException;
import com.iizix.app.builder.ApplicationDistributor;
import com.iizix.app.builder.IIDirectory;
import com.iizix.app.builder.IIFile;
import com.iizix.prop.PropException;
import com.iizix.prop.PropFactory;
import com.iizix.prop.PropMgr;
import com.iizix.server.PluginLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class EclipseApplicationDistributor
extends ApplicationDistributor {
    private static final long serialVersionUID = 4383988508945564679L;

    public EclipseApplicationDistributor(PropFactory propFactory, PropMgr propMgr, PluginLoader pluginLoader, ExecutorService executorService, boolean bl) {
        super(propFactory, propMgr, pluginLoader, executorService, bl);
    }

    public List<IPluginDescriptor<?>> loadPlugins(String string) throws IOException {
        List list = super.loadPlugins(string);
        if (list == null) {
            list = Activator.designerFactory.getLoadedPlugins(string);
            for (IPluginDescriptor iPluginDescriptor : list) {
                this.propFactory.registerPlugIn(iPluginDescriptor.getID(), iPluginDescriptor.getPropertiesURL(), iPluginDescriptor.getClassLoader(), iPluginDescriptor);
            }
        }
        return list;
    }

    public void loadApplicationDefinition(IFile iFile, AppDistributionProps appDistributionProps, IProgressMonitor iProgressMonitor) throws IOException, PropException, CancelException {
        long l2 = System.nanoTime();
        iProgressMonitor.beginTask("Loading applications", 20);
        try {
            String string;
            int n2;
            int n3;
            String[] stringArray;
            Object object;
            Object object2;
            if (appDistributionProps == null) {
                object2 = new EclipseIFile(iFile);
                ILog.INFO(((Object)((Object)this)).getClass(), (String)("Loading Application definition file '" + String.valueOf(object2) + "'"));
                appDistributionProps = (AppDistributionProps)this.loadFile((IIFile)object2, AppDistributionProps.class, iProgressMonitor);
            }
            this.dist = appDistributionProps;
            object2 = iFile.getProject().getLocation().toFile().getCanonicalFile();
            File file = this.getDestinationJar((File)object2);
            if (file == null) {
                throw new IOException("Destination Jar is undefined");
            }
            File file2 = file.getParentFile();
            if (file2 == null || !file2.isDirectory()) {
                throw new IOException("Destination directory for Jar file name '" + file.getPath() + "' does not exist");
            }
            if (iProgressMonitor.isCanceled()) {
                throw new CancelException();
            }
            String[] stringArray2 = appDistributionProps.getOtherModules();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)19);
            subMonitor.beginTask("Loading Modules projects", stringArray2.length + 1);
            try {
                if (iProgressMonitor.isCanceled()) {
                    throw new CancelException();
                }
                object = new EclipseIProject(iFile.getProject());
                this.loadModule((IIDirectory)object);
                subMonitor.worked(1);
                stringArray = stringArray2;
                n3 = stringArray2.length;
                n2 = 0;
                while (n2 < n3) {
                    string = stringArray[n2];
                    ModuleModel moduleModel = ProjectManager.getInstance().getModuleModel(string);
                    if (moduleModel == null) {
                        throw new FileNotFoundException("Module project '" + string + "' is not found");
                    }
                    object = new EclipseIProject(iFile.getProject());
                    this.loadModule((IIDirectory)object);
                    subMonitor.worked(1);
                    ++n2;
                }
            }
            finally {
                subMonitor.done();
            }
            if (iProgressMonitor.isCanceled()) {
                throw new CancelException();
            }
            this.modules = this.appCnr.getModuleProjects();
            object = "";
            stringArray = this.modules;
            n3 = this.modules.length;
            n2 = 0;
            while (n2 < n3) {
                string = stringArray[n2];
                if (!((String)object).isEmpty()) {
                    object = (String)object + ", ";
                }
                object = (String)object + string.getPropName();
                ++n2;
            }
            ILog.INFO(((Object)((Object)this)).getClass(), (String)("Completed loading required Module project" + (this.modules.length > 1 ? "s" : "") + " " + (String)object + ": @" + (float)(System.nanoTime() - l2) / 1.0E9f + "s"));
        }
        finally {
            iProgressMonitor.done();
        }
    }

    protected void checkCanceled(Object object) throws CancelException {
        if (object != null && ((IProgressMonitor)object).isCanceled()) {
            throw new CancelException();
        }
    }

    protected void worked(Object object, int n2) {
        if (object != null) {
            ((IProgressMonitor)object).worked(n2);
        }
    }
}

