define(["dojo/_base/array","dojo/_base/declare","dojo/_base/lang","dojox/gfx","dojox/gfx/matrix","./_base","./scheduler","./gradient","./vector","./matrix","./lighting"],function(u,t,s,i,a,r,e,c,l,f,n){var h=e.scheduler,o=function(t,e){1<arguments.length&&(t=e);var i={},s;for(s in t);};return t("dojox.gfx3d.Object",null,{constructor:function(){this.object=null,this.matrix=null,this.cache=null,this.renderer=null,this.parent=null,this.strokeStyle=null,this.fillStyle=null,this.shape=null},setObject:function(t){return this.object=i.makeParameters(this.object,t),this},setTransform:function(t){return this.matrix=f.clone(t?f.normalize(t):r.identity,!0),this},applyRightTransform:function(t){return t?this.setTransform([this.matrix,t]):this},applyLeftTransform:function(t){return t?this.setTransform([t,this.matrix]):this},applyTransform:function(t){return t?this.setTransform([this.matrix,t]):this},setFill:function(t){return this.fillStyle=t,this},setStroke:function(t){return this.strokeStyle=t,this},toStdFill:function(t,e){return this.fillStyle&&void 0!==this.fillStyle.type?t[this.fillStyle.type](e,this.fillStyle.finish,this.fillStyle.color):this.fillStyle},invalidate:function(){this.renderer.addTodo(this)},destroy:function(){var t;this.shape&&(t=this.shape.getParent(),t&&t.remove(this.shape),this.shape=null)},render:function(t){throw"Pure virtual function, not implemented"},draw:function(t){throw"Pure virtual function, not implemented"},getZOrder:function(){return 0},getOutline:function(){return null}}),t("dojox.gfx3d.Scene",r.Object,{constructor:function(){this.objects=[],this.todos=[],this.schedule=h.zOrder,this._draw=r.drawer.conservative},setFill:function(e){return this.fillStyle=e,u.forEach(this.objects,function(t){t.setFill(e)}),this},setStroke:function(e){return this.strokeStyle=e,u.forEach(this.objects,function(t){t.setStroke(e)}),this},render:function(t,e){var i=f.multiply(t,this.matrix);e&&(this.todos=this.objects),u.forEach(this.todos,function(t){t.render(i,e)})},draw:function(t){this.objects=this.schedule(this.objects),this._draw(this.todos,this.objects,this.renderer)},addTodo:function(e){u.every(this.todos,function(t){return t!=e})&&(this.todos.push(e),this.invalidate())},invalidate:function(){this.parent.addTodo(this)},getZOrder:function(){var e=0;return u.forEach(this.objects,function(t){e+=t.getZOrder()}),1<this.objects.length?e/this.objects.length:0}}),t("dojox.gfx3d.Edges",r.Object,{constructor:function(){this.object=s.clone(r.defaultEdges)},setObject:function(t,e){return this.object=i.makeParameters(this.object,t instanceof Array?{points:t,style:e}:t),this},getZOrder:function(){var e=0;return u.forEach(this.cache,function(t){e+=t.z}),1<this.cache.length?e/this.cache.length:0},render:function(t){var e=f.multiply(t,this.matrix);this.cache=u.map(this.object.points,function(t){return f.multiplyPoint(e,t)})},draw:function(){var t=this.cache,e=(this.shape?this.shape.setShape(""):this.shape=this.renderer.createPath(),this.shape.setAbsoluteMode("absolute"));if("strip"==this.object.style||"loop"==this.object.style)e.moveTo(t[0].x,t[0].y),u.forEach(t.slice(1),function(t){e.lineTo(t.x,t.y)}),"loop"==this.object.style&&e.closePath();else for(var i=0;i<this.cache.length;)e.moveTo(t[i].x,t[i].y),i++,e.lineTo(t[i].x,t[i].y),i++;e.setStroke(this.strokeStyle)}}),t("dojox.gfx3d.Orbit",r.Object,{constructor:function(){this.object=s.clone(r.defaultOrbit)},render:function(t){var e=f.multiply(t,this.matrix),t=[0,Math.PI/4,Math.PI/3],i=f.multiplyPoint(e,this.object.center),t=u.map(t,function(t){return{x:this.center.x+this.radius*Math.cos(t),y:this.center.y+this.radius*Math.sin(t),z:this.center.z}},this.object),t=u.map(t,function(t){return f.multiplyPoint(e,t)}),s=l.normalize(t),r=(t=u.map(t,function(t){return l.substract(t,i)}),{xx:t[0].x*t[0].y,xy:t[0].y*t[0].y,xz:1,yx:t[1].x*t[1].y,yy:t[1].y*t[1].y,yz:1,zx:t[2].x*t[2].y,zy:t[2].y*t[2].y,zz:1,dx:0,dy:0,dz:0}),n=u.map(t,function(t){return-Math.pow(t.x,2)}),r=f.multiplyPoint(f.invert(r),n[0],n[1],n[2]),h=Math.atan2(r.x,1-r.y)/2,n=u.map(t,function(t){return a.multiplyPoint(a.rotate(-h),t.x,t.y)}),r=Math.pow(n[0].x,2),t=Math.pow(n[0].y,2),o=Math.pow(n[1].x,2),n=Math.pow(n[1].y,2),c=Math.sqrt((r*n-t*o)/(n-t)),n=Math.sqrt((r*n-t*o)/(r-o));this.cache={cx:i.x,cy:i.y,rx:c,ry:n,theta:h,normal:s}},draw:function(t){this.shape?this.shape.setShape(this.cache):this.shape=this.renderer.createEllipse(this.cache),this.shape.applyTransform(a.rotateAt(this.cache.theta,this.cache.cx,this.cache.cy)).setStroke(this.strokeStyle).setFill(this.toStdFill(t,this.cache.normal))}}),t("dojox.gfx3d.Path3d",r.Object,{constructor:function(){this.object=s.clone(r.defaultPath3d),this.segments=[],this.absolute=!0,this.last={},this.path=""},_collectArgs:function(t,e){for(var i=0;i<e.length;++i){var s=e[i];"boolean"==typeof s?t.push(s?1:0):"number"==typeof s?t.push(s):s instanceof Array?this._collectArgs(t,s):"x"in s&&"y"in s&&(t.push(s.x),t.push(s.y))}},_validSegments:{m:3,l:3,z:0},_pushSegment:function(t,e){var i=this._validSegments[t.toLowerCase()],s;"number"==typeof i&&(i?e.length>=i&&(s={action:t,args:e.slice(0,e.length-e.length%i)},this.segments.push(s)):(s={action:t,args:[]},this.segments.push(s)))},moveTo:function(){var t=[];return this._collectArgs(t,arguments),this._pushSegment(this.absolute?"M":"m",t),this},lineTo:function(){var t=[];return this._collectArgs(t,arguments),this._pushSegment(this.absolute?"L":"l",t),this},closePath:function(){return this._pushSegment("Z",[]),this},render:function(t){var s=f.multiply(t,this.matrix),r="",n=this._validSegments;u.forEach(this.segments,function(t){r+=t.action;for(var e=0;e<t.args.length;e+=n[t.action.toLowerCase()]){var i=f.multiplyPoint(s,t.args[e],t.args[e+1],t.args[e+2]);r+=" "+i.x+" "+i.y}}),this.cache=r},_draw:function(){return this.parent.createPath(this.cache)}}),t("dojox.gfx3d.Triangles",r.Object,{constructor:function(){this.object=s.clone(r.defaultTriangles)},setObject:function(t,e){return t instanceof Array?this.object=i.makeParameters(this.object,{points:t,style:e}):this.object=i.makeParameters(this.object,t),this},render:function(t){var e=f.multiply(t,this.matrix),i=u.map(this.object.points,function(t){return f.multiplyPoint(e,t)}),s=(this.cache=[],i.slice(0,2)),r=i[0];if("strip"==this.object.style)u.forEach(i.slice(2),function(t){s.push(t),s.push(s[0]),this.cache.push(s),s=s.slice(1,3)},this);else if("fan"==this.object.style)u.forEach(i.slice(2),function(t){s.push(t),s.push(r),this.cache.push(s),s=[r,t]},this);else for(var n=0;n<i.length;)this.cache.push([i[n],i[n+1],i[n+2],i[n]]),n+=3},draw:function(e){this.cache=h.bsp(this.cache,function(t){return t}),this.shape?this.shape.clear():this.shape=this.renderer.createGroup(),u.forEach(this.cache,function(t){this.shape.createPolyline(t).setStroke(this.strokeStyle).setFill(this.toStdFill(e,l.normalize(t)))},this)},getZOrder:function(){var e=0;return u.forEach(this.cache,function(t){e+=(t[0].z+t[1].z+t[2].z)/3}),1<this.cache.length?e/this.cache.length:0}}),t("dojox.gfx3d.Quads",r.Object,{constructor:function(){this.object=s.clone(r.defaultQuads)},setObject:function(t,e){return this.object=i.makeParameters(this.object,t instanceof Array?{points:t,style:e}:t),this},render:function(t){var e=f.multiply(t,this.matrix),i,s=u.map(this.object.points,function(t){return f.multiplyPoint(e,t)});if(this.cache=[],"strip"==this.object.style)for(var r=s.slice(0,2),i=2;i<s.length;)r=r.concat([s[i],s[i+1],r[0]]),this.cache.push(r),r=r.slice(2,4),i+=2;else for(i=0;i<s.length;)this.cache.push([s[i],s[i+1],s[i+2],s[i+3],s[i]]),i+=4},draw:function(t){this.cache=r.scheduler.bsp(this.cache,function(t){return t}),this.shape?this.shape.clear():this.shape=this.renderer.createGroup();for(var e=0;e<this.cache.length;e++)this.shape.createPolyline(this.cache[e]).setStroke(this.strokeStyle).setFill(this.toStdFill(t,l.normalize(this.cache[e])))},getZOrder:function(){for(var t=0,e=0;e<this.cache.length;e++){var i=this.cache[e];t+=(i[0].z+i[1].z+i[2].z+i[3].z)/4}return 1<this.cache.length?t/this.cache.length:0}}),t("dojox.gfx3d.Polygon",r.Object,{constructor:function(){this.object=s.clone(r.defaultPolygon)},setObject:function(t){return this.object=i.makeParameters(this.object,t instanceof Array?{path:t}:t),this},render:function(t){var e=f.multiply(t,this.matrix);this.cache=u.map(this.object.path,function(t){return f.multiplyPoint(e,t)}),this.cache.push(this.cache[0])},draw:function(t){this.shape?this.shape.setShape({points:this.cache}):this.shape=this.renderer.createPolyline({points:this.cache}),this.shape.setStroke(this.strokeStyle).setFill(this.toStdFill(t,f.normalize(this.cache)))},getZOrder:function(){for(var t=0,e=0;e<this.cache.length;e++)t+=this.cache[e].z;return 1<this.cache.length?t/this.cache.length:0},getOutline:function(){return this.cache.slice(0,3)}}),t("dojox.gfx3d.Cube",r.Object,{constructor:function(){this.object=s.clone(r.defaultCube),this.polygons=[]},setObject:function(t){this.object=i.makeParameters(this.object,t)},render:function(t){var e=this.object.top,i=this.object.bottom,s={x:i.x,y:e.y,z:e.z},r={x:i.x,y:i.y,z:e.z},n={x:e.x,y:i.y,z:e.z},h={x:e.x,y:e.y,z:i.z},o={x:i.x,y:e.y,z:i.z},c={x:e.x,y:i.y,z:i.z},a=[e,s,r,n,h,o,i,c],l=f.multiply(t,this.matrix),t=u.map(a,function(t){return f.multiplyPoint(l,t)}),e=t[0],s=t[1],r=t[2],n=t[3],h=t[4],o=t[5],i=t[6],c=t[7];this.cache=[[e,s,r,n,e],[h,o,i,c,h],[e,n,c,h,e],[n,r,i,c,n],[r,s,o,i,r],[s,e,h,o,s]]},draw:function(t){this.cache=r.scheduler.bsp(this.cache,function(t){return t});var e=this.cache.slice(3);this.shape?this.shape.clear():this.shape=this.renderer.createGroup();for(var i=0;i<e.length;i++)this.shape.createPolyline(e[i]).setStroke(this.strokeStyle).setFill(this.toStdFill(t,l.normalize(e[i])))},getZOrder:function(){var t=this.cache[0][0],e=this.cache[1][2];return(t.z+e.z)/2}}),t("dojox.gfx3d.Cylinder",r.Object,{constructor:function(){this.object=s.clone(r.defaultCylinder)},render:function(t){var e=f.multiply(t,this.matrix),t=[0,Math.PI/4,Math.PI/3],i=f.multiplyPoint(e,this.object.center),t=u.map(t,function(t){return{x:this.center.x+this.radius*Math.cos(t),y:this.center.y+this.radius*Math.sin(t),z:this.center.z}},this.object),t=u.map(t,function(t){return l.substract(f.multiplyPoint(e,t),i)}),s={xx:t[0].x*t[0].y,xy:t[0].y*t[0].y,xz:1,yx:t[1].x*t[1].y,yy:t[1].y*t[1].y,yz:1,zx:t[2].x*t[2].y,zy:t[2].y*t[2].y,zz:1,dx:0,dy:0,dz:0},r=u.map(t,function(t){return-Math.pow(t.x,2)}),s=f.multiplyPoint(f.invert(s),r[0],r[1],r[2]),n=Math.atan2(s.x,1-s.y)/2,r=u.map(t,function(t){return a.multiplyPoint(a.rotate(-n),t.x,t.y)}),s=Math.pow(r[0].x,2),t=Math.pow(r[0].y,2),h=Math.pow(r[1].x,2),r=Math.pow(r[1].y,2),o=Math.sqrt((s*r-t*h)/(r-t)),r=Math.sqrt((s*r-t*h)/(s-h)),t,o,r,s=(o<r&&(t=o,o=r,r=t,n-=Math.PI/2),f.multiplyPoint(e,l.sum(this.object.center,{x:0,y:0,z:this.object.height}))),h="constant"==this.fillStyle.type?this.fillStyle.color:c(this.renderer.lighting,this.fillStyle,this.object.center,this.object.radius,Math.PI,2*Math.PI,e);(isNaN(o)||isNaN(r)||isNaN(n))&&(o=this.object.radius,r=0,n=0),this.cache={center:i,top:s,rx:o,ry:r,theta:n,gradient:h}},draw:function(){var t=this.cache,e=l,i=a,s=[t.center,t.top],r=e.substract(t.top,t.center),e=(0<e.dotProduct(r,this.renderer.lighting.incident)&&(s=[t.top,t.center],r=e.substract(t.center,t.top)),this.renderer.lighting[this.fillStyle.type](r,this.fillStyle.finish,this.fillStyle.color)),r=Math.sqrt(Math.pow(t.center.x-t.top.x,2)+Math.pow(t.center.y-t.top.y,2));this.shape?this.shape.clear():this.shape=this.renderer.createGroup(),this.shape.createPath("").moveTo(0,-t.rx).lineTo(r,-t.rx).lineTo(r,t.rx).lineTo(0,t.rx).arcTo(t.ry,t.rx,0,!0,!0,0,-t.rx).setFill(t.gradient).setStroke(this.strokeStyle).setTransform([i.translate(s[0]),i.rotate(Math.atan2(s[1].y-s[0].y,s[1].x-s[0].x))]),0<t.rx&&0<t.ry&&this.shape.createEllipse({cx:s[1].x,cy:s[1].y,rx:t.rx,ry:t.ry}).setFill(e).setStroke(this.strokeStyle).applyTransform(i.rotateAt(t.theta,s[1]))}}),t("dojox.gfx3d.Viewport",i.Group,{constructor:function(){this.dimension=null,this.objects=[],this.todos=[],this.renderer=this,this.schedule=r.scheduler.zOrder,this.draw=r.drawer.conservative,this.deep=!1,this.lights=[],this.lighting=null},setCameraTransform:function(t){return this.camera=f.clone(t?f.normalize(t):r.identity,!0),this.invalidate(),this},applyCameraRightTransform:function(t){return t?this.setCameraTransform([this.camera,t]):this},applyCameraLeftTransform:function(t){return t?this.setCameraTransform([t,this.camera]):this},applyCameraTransform:function(t){return this.applyCameraRightTransform(t)},setLights:function(t,e,i){this.lights=t instanceof Array?{sources:t,ambient:e,specular:i}:t;var e={x:0,y:0,z:1};return this.lighting=new n.Model(e,this.lights.sources,this.lights.ambient,this.lights.specular),this.invalidate(),this},addLights:function(t){return this.setLights(this.lights.sources.concat(t))},addTodo:function(e){u.every(this.todos,function(t){return t!=e})&&this.todos.push(e)},invalidate:function(){this.deep=!0,this.todos=this.objects},setDimensions:function(t){var e,t,i;t?(e=s.isString(t.width)?parseInt(t.width):t.width,t=s.isString(t.height)?parseInt(t.height):t.height,this.rawNode&&(i=this.rawNode.style,i?(i.height=t,i.width=e):(this.rawNode.width=e,this.rawNode.height=t)),this.dimension={width:e,height:t}):this.dimension=null},render:function(){if(this.todos.length){for(var t=f,e=0;e<this.todos.length;e++)this.todos[e].render(f.normalize([t.cameraRotateXg(180),t.cameraTranslate(0,this.dimension.height,0),this.camera]),this.deep);this.objects=this.schedule(this.objects),this.draw(this.todos,this.objects,this),this.todos=[],this.deep=!1}}}),r.Viewport.nodeType=i.Group.nodeType,r._creators={createEdges:function(t,e){return this.create3DObject(r.Edges,t,e)},createTriangles:function(t,e){return this.create3DObject(r.Triangles,t,e)},createQuads:function(t,e){return this.create3DObject(r.Quads,t,e)},createPolygon:function(t){return this.create3DObject(r.Polygon,t)},createOrbit:function(t){return this.create3DObject(r.Orbit,t)},createCube:function(t){return this.create3DObject(r.Cube,t)},createCylinder:function(t){return this.create3DObject(r.Cylinder,t)},createPath3d:function(t){return this.create3DObject(r.Path3d,t)},createScene:function(){return this.create3DObject(r.Scene)},create3DObject:function(t,e,i){var t=new t;return this.adopt(t),e&&t.setObject(e,i),t},adopt:function(t){return t.renderer=this.renderer,t.parent=this,this.objects.push(t),this.addTodo(t),this},abandon:function(t,e){for(var i=0;i<this.objects.length;++i)this.objects[i]==t&&this.objects.splice(i,1);return t.parent=null,this},setScheduler:function(t){this.schedule=t},setDrawer:function(t){this.draw=t}},s.extend(r.Viewport,r._creators),s.extend(r.Scene,r._creators),delete r._creators,s.extend(i.Surface,{createViewport:function(){var t=this.createObject(r.Viewport,null,!0);return t.setDimensions(this.getDimensions()),t}}),r.Object});