/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.chat;

import com.tabnine.eclipse.shared.a.a.c.a;
import com.tabnine.eclipse.shared.a.l;
import com.tabnine.eclipse.shared.api.chat.DiagnosticView;
import com.tabnine.eclipse.shared.api.chat.EnrichingContextType;
import com.tabnine.eclipse.shared.api.chat.IEnrichingContext;
import com.tabnine.eclipse.shared.b.b;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.texteditor.ITextEditor;

public class DiagnosticsContext
implements IEnrichingContext {
    private static Logger logger = LogManager.getLogger(a.class);
    private final List<DiagnosticView> diagnostics;
    private final EnrichingContextType type = EnrichingContextType.Diagnostics;

    public DiagnosticsContext(List<DiagnosticView> list) {
        this.diagnostics = list;
    }

    public DiagnosticsContext() {
        this.diagnostics = new ArrayList<DiagnosticView>();
    }

    public static DiagnosticsContext from(ITextEditor iTextEditor) {
        IResource iResource = (IResource)iTextEditor.getEditorInput().getAdapter(IResource.class);
        return l.a(iTextEditor).flatMap(iDocument -> l.b(iTextEditor).map(textSelection -> {
            ArrayList<IMarker> arrayList = new ArrayList<IMarker>();
            ArrayList<DiagnosticView> arrayList2 = new ArrayList<DiagnosticView>();
            int n2 = textSelection.getOffset();
            int n3 = n2 + textSelection.getLength();
            if (n2 == -1) {
                return new DiagnosticsContext();
            }
            try {
                iResource = iResource.findMarkers(null, true, 2);
            }
            catch (CoreException coreException) {
                logger.warn("Failed to get markers", (Throwable)coreException);
                return new DiagnosticsContext();
            }
            IMarker iMarker = iResource;
            int n4 = ((IMarker[])iMarker).length;
            int n5 = 0;
            while (n5 < n4) {
                iResource = iMarker[n5];
                int n6 = iResource.getAttribute("severity", -1);
                int n7 = iResource.getAttribute("charStart", -1);
                int n8 = iResource.getAttribute("charEnd", -1);
                if (n8 >= n2 && n7 <= n3) {
                    iResource = DiagnosticsContext.getDiagnosticView(iResource, iDocument);
                    if (n6 == 2) {
                        arrayList.add((IMarker)iResource);
                    } else if (n6 == 1) {
                        arrayList2.add((DiagnosticView)iResource);
                    }
                }
                ++n5;
            }
            return new DiagnosticsContext(arrayList.isEmpty() ? arrayList2 : arrayList);
        })).orElse(new DiagnosticsContext());
    }

    private static DiagnosticView getDiagnosticView(IMarker iMarker, IDocument object) {
        String string;
        int n2 = iMarker.getAttribute("lineNumber", 0) - 1;
        try {
            object = b.a((Integer)n2, object);
        }
        catch (BadLocationException badLocationException) {
            logger.warn("Failed to get line text at cursor", (Throwable)badLocationException);
            object = "";
        }
        try {
            string = (String)iMarker.getAttribute("message");
        }
        catch (CoreException coreException) {
            logger.warn("Failed to get marker message", (Throwable)coreException);
            string = "";
        }
        return new DiagnosticView(string, n2 + 1, (String)object);
    }

    @Override
    public EnrichingContextType getContextType() {
        return this.type;
    }
}

