/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.binary;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.tabnine.eclipse.shared.api.binary.BinaryProcessGateway;
import com.tabnine.eclipse.shared.api.binary.exceptions.TabNineInvalidResponseException;
import java.util.Optional;

public class ParsedBinaryIO {
    private final Gson gson;
    private final BinaryProcessGateway binaryProcessGateway;

    public ParsedBinaryIO(Gson gson, BinaryProcessGateway binaryProcessGateway) {
        this.gson = gson;
        this.binaryProcessGateway = binaryProcessGateway;
    }

    public <R> R readResponse(Class<R> clazz) {
        String string = this.binaryProcessGateway.readRawResponse();
        try {
            return (R)Optional.ofNullable(this.gson.fromJson(string, clazz)).orElseThrow(() -> new TabNineInvalidResponseException("Binary returned null as a response"));
        }
        catch (JsonSyntaxException | TabNineInvalidResponseException throwable) {
            throw new TabNineInvalidResponseException("Binary returned illegal response");
        }
    }

    public void writeRequest(Object object) {
        this.binaryProcessGateway.writeRequest(String.valueOf(this.gson.toJson(object)) + "\n");
    }

    public Long pid() {
        return this.binaryProcessGateway.pid();
    }

    public boolean isDead() {
        return this.binaryProcessGateway.isDead();
    }

    public void destroy() {
        this.binaryProcessGateway.destroy();
    }
}

