/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.user;

import com.iizix.ILog;
import com.iizix.NotFoundException;
import com.iizix.comm.oauth.AuthenticationProvider;
import com.iizix.geo.DeviceLocation;
import com.iizix.server.IServer;
import com.iizix.server.ServerShell;
import com.iizix.server.app.AppFactory;
import com.iizix.server.db.BasicUserInfo;
import com.iizix.server.db.DBUtilities;
import com.iizix.server.geo.UserLocationHistory;
import com.iizix.server.user.AuthenticatedUser;
import com.iizix.server.user.UserAuthenticationInfo;
import com.iizix.server.user.b;
import com.iizix.user.AuthenticatedUserProvider;
import com.iizix.user.IAuthenticatedUser;
import com.iizix.user.IAuthenticatedUserProvider;
import com.iizix.user.SigninResult;
import com.iizix.user.UserException;
import com.iizix.user.UserIdentifier;
import com.iizix.user.UserLocaleString;
import com.iizix.user.geo.UserLocation;
import com.iizix.virtual.VirtualThreads;
import java.lang.ref.WeakReference;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class UserAuthentication
implements IAuthenticatedUserProvider {
    private static int[] a = new int[]{15, -900000, 12, 600000, 10, 300000, 6, 60000, 4, 30000, 3, 10000};
    private static final UserAuthentication a = new UserAuthentication();
    private final b a;
    private final HashMap<String, WeakReference<AuthenticatedUser>> a;
    private final HashMap<String, WeakReference<AuthenticatedUser>> b;
    private final HashMap<Long, WeakReference<AuthenticatedUser>> c;
    private final Object a;
    private final Set<AuthenticatedUser> a;
    private final Runnable a = (int[])new HashMap();
    private static volatile /* synthetic */ int[] b;

    static {
        AuthenticatedUserProvider.setInstance((IAuthenticatedUserProvider)a);
    }

    public static UserAuthentication getInstance() {
        return a;
    }

    public static void validateHashPW(String string) {
        block7: {
            if (string == null) {
                throw new NullPointerException("hashPW is null");
            }
            if (string.isEmpty()) {
                throw new IllegalArgumentException("hashPW is empty");
            }
            if (string.startsWith("EXT:")) {
                if (string.length() < 10) {
                    throw new IllegalArgumentException("hashPW length too short");
                }
                int n = string.indexOf(58, 4);
                if (n + 1 == string.length()) {
                    throw new IllegalArgumentException("hashPW external Sign In Provider ID not specified");
                }
                String string2 = string.substring(4, n);
                AuthenticationProvider[] authenticationProviderArray = AuthenticationProvider.values();
                int n2 = authenticationProviderArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    AuthenticationProvider authenticationProvider = authenticationProviderArray[n3];
                    if (!authenticationProvider.providerName.equalsIgnoreCase(string2)) {
                        ++n3;
                        continue;
                    }
                    break block7;
                }
                throw new IllegalArgumentException("Provider \"" + string2 + "\" is not supported");
            }
        }
        com.iizix.server.user.b.a(string);
    }

    private UserAuthentication() {
        this.b = new HashMap();
        this.c = new HashMap();
        this.a = this.a;
        this.a = (int[])ConcurrentHashMap.newKeySet();
        this.a = () -> {
            block4: while (true) {
                try {
                    Thread.sleep(360000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                while (true) {
                    long l = System.currentTimeMillis() - 604800000L;
                    try {
                        Iterator iterator = this.a.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block4;
                            AuthenticatedUser authenticatedUser = (AuthenticatedUser)iterator.next();
                            if (l <= authenticatedUser.getLastAccessedTime()) continue;
                            iterator.remove();
                        }
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {
                        continue;
                    }
                    break;
                }
                break;
            }
        };
        this.a = new b();
        VirtualThreads.getVirtualThreads().startThread(this.a, "CleanupInactiveUsers", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserLocation> getUserLocations() {
        ArrayList<UserLocation> arrayList = new ArrayList<UserLocation>();
        HashMap<Long, WeakReference<AuthenticatedUser>> hashMap = this.c;
        synchronized (hashMap) {
            for (WeakReference<AuthenticatedUser> weakReference : this.c.values()) {
                DeviceLocation deviceLocation;
                UserLocationHistory userLocationHistory;
                AuthenticatedUser authenticatedUser = (AuthenticatedUser)weakReference.get();
                if (authenticatedUser == null || (userLocationHistory = authenticatedUser.getLocationHistory()) == null || (deviceLocation = userLocationHistory.getLatestLocation()) == null) continue;
                arrayList.add(new UserLocation((IAuthenticatedUser)authenticatedUser, deviceLocation));
            }
        }
        return arrayList;
    }

    public boolean isUserNameFree(String string) throws UserException {
        try {
            this.getUser(string);
            return false;
        }
        catch (NotFoundException notFoundException) {
            Throwable throwable = notFoundException.getCause();
            if (throwable != null) {
                String string2 = "Retrieval of user name \"" + string + "\" in database failed";
                ILog.SEVERE(this.getClass(), (String)string2, (Throwable)throwable);
                UserIdentifier userIdentifier = new UserIdentifier(string, "-");
                throw new UserException(userIdentifier, string2, throwable);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedUser getUser(String string) throws NotFoundException {
        WeakReference<Object> weakReference;
        string = string.trim();
        String string2 = string.toLowerCase(Locale.ENGLISH);
        Object object = this.a;
        synchronized (object) {
            weakReference = this.b.get(string2);
            if (weakReference == null) {
                weakReference = (WeakReference<Object>)this.a.get(string);
            }
        }
        Object object2 = object = weakReference != null ? (AuthenticatedUser)weakReference.get() : null;
        if (object == null) {
            BasicUserInfo basicUserInfo = null;
            Connection connection = null;
            try {
                try {
                    connection = DBUtilities.getPooledConnection();
                    basicUserInfo = BasicUserInfo.newBasicUserInfo(connection, string, true);
                    try {
                        connection.commit();
                    }
                    catch (SQLException sQLException) {}
                }
                catch (SQLException sQLException) {
                    if (connection != null) {
                        try {
                            connection.rollback();
                        }
                        catch (SQLException sQLException2) {
                            ILog.SEVERE(this.getClass(), (String)"Failed rollback", (Throwable)sQLException2);
                        }
                    }
                    String string3 = "Retrieval of user name \"" + string + "\" in database failed";
                    ILog.SEVERE(this.getClass(), (String)string3, (Throwable)sQLException);
                    throw new NotFoundException(string3, (Throwable)sQLException);
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        ILog.SEVERE(this.getClass(), (String)"Failed closing connection", (Throwable)sQLException);
                    }
                }
            }
            object = new AuthenticatedUser(basicUserInfo);
            weakReference = new WeakReference<Object>(object);
            Object object3 = this.a;
            synchronized (object3) {
                this.a.put(string, weakReference);
                this.b.put(basicUserInfo.userNameLower, weakReference);
                this.c.put(basicUserInfo.id, weakReference);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedUser getUserFromEmail(String string) throws NotFoundException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Connection connection = DBUtilities.getPooledConnection();){
                BasicUserInfo basicUserInfo = BasicUserInfo.newBasicUserInfoFromEmail(connection, string);
                try {
                    connection.commit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                AuthenticatedUser authenticatedUser = new AuthenticatedUser(basicUserInfo);
                WeakReference<AuthenticatedUser> weakReference = new WeakReference<AuthenticatedUser>(authenticatedUser);
                Object object = this.a;
                synchronized (object) {
                    this.a.put(basicUserInfo.userName, weakReference);
                    this.b.put(basicUserInfo.userNameLower, weakReference);
                    this.c.put(basicUserInfo.id, weakReference);
                }
                return authenticatedUser;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            String string2 = "Retrieval of user from email address \"" + string + "\" in database failed";
            ILog.SEVERE(this.getClass(), (String)string2, (Throwable)sQLException);
            throw new NotFoundException(string2, (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedUser getUser(Connection connection, String string) throws NotFoundException, SQLException {
        string = string.trim();
        BasicUserInfo basicUserInfo = BasicUserInfo.newBasicUserInfo(connection, string, true);
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        AuthenticatedUser authenticatedUser = new AuthenticatedUser(basicUserInfo);
        WeakReference<AuthenticatedUser> weakReference = new WeakReference<AuthenticatedUser>(authenticatedUser);
        Object object = this.a;
        synchronized (object) {
            this.a.put(string, weakReference);
            this.b.put(basicUserInfo.userNameLower, weakReference);
            this.c.put(basicUserInfo.id, weakReference);
        }
        return authenticatedUser;
    }

    public AuthenticatedUser getUser(Connection connection, String string, String string2) throws NotFoundException, SQLException {
        String string3;
        string2 = Objects.requireNonNull(string2);
        AuthenticatedUser authenticatedUser = this.getUser(connection, string);
        if (authenticatedUser != null && (string2.equals(string3 = authenticatedUser.getBasicUserInfo().getPasswordHash()) || UserAuthentication.getInstance().a.a(string, string2, string3))) {
            return authenticatedUser;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedUser getUser(long l) throws NotFoundException {
        WeakReference<AuthenticatedUser> weakReference;
        Long l2 = l;
        Object object = this.a;
        synchronized (object) {
            weakReference = this.c.get(l2);
        }
        Object object2 = object = weakReference != null ? (AuthenticatedUser)weakReference.get() : null;
        if (object == null) {
            try {
                Throwable throwable = null;
                Object var7_8 = null;
                try (Connection connection = DBUtilities.getPooledConnection();){
                    return this.getUser(connection, l);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException sQLException) {
                String string = "Retrieval of user ID \"" + l + "\" in database failed";
                ILog.SEVERE(this.getClass(), (String)string, (Throwable)sQLException);
                throw new NotFoundException(string, (Throwable)sQLException);
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticatedUser getUser(Connection connection, long l) throws NotFoundException, SQLException {
        BasicUserInfo basicUserInfo = BasicUserInfo.newBasicUserInfo(connection, l);
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        AuthenticatedUser authenticatedUser = new AuthenticatedUser(basicUserInfo);
        WeakReference<AuthenticatedUser> weakReference = new WeakReference<AuthenticatedUser>(authenticatedUser);
        Object object = this.a;
        synchronized (object) {
            this.a.put(basicUserInfo.userName, weakReference);
            this.b.put(basicUserInfo.userNameLower, weakReference);
            this.c.put(l, weakReference);
        }
        return authenticatedUser;
    }

    public final UserAuthenticationInfo validateUser(UserIdentifier userIdentifier, String string, String string2) {
        AppFactory appFactory = null;
        if (string != null && !string.equals("*DeveloperRegistration*")) {
            ServerShell serverShell = ServerShell.getInstance();
            if (serverShell == null) {
                return new UserAuthenticationInfo(SigninResult.SERVER_NOT_STARTED);
            }
            appFactory = serverShell.getApplication(string);
            if (appFactory == null) {
                return new UserAuthenticationInfo(SigninResult.APP_ID_NOT_FOUND);
            }
        }
        return this.validateUser(userIdentifier, appFactory, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UserAuthenticationInfo validateUser(UserIdentifier userIdentifier, AppFactory appFactory, String string) {
        String string2;
        ServerShell serverShell = ServerShell.getInstance();
        if (serverShell == null) {
            return new UserAuthenticationInfo(SigninResult.SERVER_NOT_STARTED);
        }
        switch (UserAuthentication.a()[serverShell.getState().ordinal()]) {
            case 3: {
                break;
            }
            case 2: {
                return new UserAuthenticationInfo(SigninResult.SERVER_STARTING);
            }
            case 4: {
                return new UserAuthenticationInfo(SigninResult.SERVER_STOPPING);
            }
            case 5: {
                return new UserAuthenticationInfo(SigninResult.SERVER_STOPPED);
            }
            default: {
                return new UserAuthenticationInfo(SigninResult.SERVER_NOT_STARTED);
            }
        }
        if (!serverShell.isUserLoginEnabled() || !serverShell.isUserLoginPermittedNow()) {
            return new UserAuthenticationInfo(SigninResult.SERVER_LOGIN_DISABLED);
        }
        String string3 = userIdentifier.getUserID().trim();
        String string4 = string2 = string != null ? string : userIdentifier.getPassword();
        if (string2 == null) {
            return new UserAuthenticationInfo(SigninResult.SUCCESS_NOT_SIGNED_IN);
        }
        string2 = string2.trim();
        Connection connection = null;
        BasicUserInfo basicUserInfo = null;
        try {
            SigninResult signinResult;
            connection = DBUtilities.getPooledConnection();
            basicUserInfo = BasicUserInfo.newBasicUserInfo(connection, string3, true);
            string3 = basicUserInfo.userName;
            boolean bl = false;
            boolean bl2 = false;
            AuthenticatedUser authenticatedUser = null;
            Object object = this.a;
            synchronized (object) {
                WeakReference<AuthenticatedUser> weakReference = this.b.get(basicUserInfo.userNameLower);
                if (weakReference == null) {
                    weakReference = (WeakReference<AuthenticatedUser>)this.a.get(string3);
                }
                if (weakReference != null) {
                    authenticatedUser = (AuthenticatedUser)weakReference.get();
                }
                if (authenticatedUser == null) {
                    authenticatedUser = new AuthenticatedUser(basicUserInfo);
                    weakReference = new WeakReference<AuthenticatedUser>(authenticatedUser);
                    this.a.put(string3, weakReference);
                    this.b.put(basicUserInfo.userNameLower, weakReference);
                    this.c.put(basicUserInfo.id, weakReference);
                }
            }
            authenticatedUser.a(basicUserInfo);
            this.a.add(authenticatedUser);
            object = basicUserInfo.getDisabledReason();
            if (object != null) {
                ILog.WARNING(this.getClass(), (String)("Rejected disabled user access, reason: " + ((UserLocaleString)object).english), (Object)("User = " + String.valueOf(userIdentifier)));
                basicUserInfo.updateFailedLogin(connection, null);
                connection.commit();
                connection.close();
                connection = null;
                UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(SigninResult.USER_DISABLED, authenticatedUser);
                return userAuthenticationInfo;
            }
            long l = basicUserInfo.getFailCount();
            long l2 = basicUserInfo.getLastFail();
            if (l2 != 0L && appFactory != null) {
                long l3;
                int n = 0;
                int n2 = 0;
                int n3 = a.length;
                while (n2 < n3) {
                    int n4 = a[n2];
                    if (l >= (long)n4) {
                        n = a[n2 + 1];
                        if (n >= 0) break;
                        if (l + 1L > (long)n4) {
                            basicUserInfo.updateFailedLogin(connection, "Too many invalid logins");
                            connection.commit();
                            connection.close();
                            connection = null;
                            UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(SigninResult.USER_DISABLED, authenticatedUser);
                            return userAuthenticationInfo;
                        }
                        bl = true;
                        bl2 = l > (long)n4;
                        break;
                    }
                    n2 += 2;
                }
                if (n != 0 && (l3 = l2 + (long)Math.abs(n) - System.currentTimeMillis()) >= 0L) {
                    connection.commit();
                    connection.close();
                    connection = null;
                    String string5 = "Rejected user due to too many failed logins. User must wait an additional " + l3 + " milliseconds";
                    if (bl) {
                        ILog.WARNING(this.getClass(), (String)(string5 + ". Upon next failed login, the user will be disabled"), (Object)("User = " + String.valueOf(userIdentifier)));
                        UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(SigninResult.TOO_MANY_INVALID_LOGINS_RETRY_LATER_NEXT_TIME_DISABLE, authenticatedUser);
                        return userAuthenticationInfo;
                    }
                    ILog.WARNING(this.getClass(), (String)string5, (Object)("User = " + String.valueOf(userIdentifier)));
                    UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(SigninResult.TOO_MANY_INVALID_LOGINS_RETRY_LATER, authenticatedUser);
                    return userAuthenticationInfo;
                }
            }
            if (string != null && string.isEmpty()) {
                connection.commit();
                connection.close();
                connection = null;
                UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(basicUserInfo.mustChangePassword() ? SigninResult.SUCCESS_CHANGE_PASSWORD : SigninResult.SUCCESS, authenticatedUser);
                return userAuthenticationInfo;
            }
            if (string2.isEmpty()) {
                connection.commit();
                connection.close();
                connection = null;
                SigninResult signinResult2 = bl2 ? SigninResult.INVALID_PASSWORD_NEXT_ATTEMPT_WILL_DISABLE : SigninResult.INVALID_PASSWORD;
                ILog.WARNING(this.getClass(), (String)signinResult2.englishMessage, (Object)("User = " + String.valueOf(userIdentifier)));
                UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(signinResult2, authenticatedUser);
                return userAuthenticationInfo;
            }
            String string6 = basicUserInfo.getPasswordHash();
            if (string6.startsWith("EXT:") || this.a.a(string3, string2, string6)) {
                String string7 = null;
                if (basicUserInfo.needsNewHashedPassword()) {
                    try {
                        string7 = this.a.a(string3, string2);
                    }
                    catch (InvalidKeySpecException invalidKeySpecException) {
                        ILog.SEVERE(this.getClass(), (String)("Failed new hashed password: user = " + String.valueOf(userIdentifier)), (Throwable)invalidKeySpecException);
                    }
                }
                basicUserInfo.updateSuccessfulLogin(connection, string7);
                connection.commit();
                connection.close();
                connection = null;
                if (appFactory != null) {
                    ILog.INFO(this.getClass(), (String)("Accepted user credentials for application ID \"" + appFactory.getAppID() + "\": user = " + String.valueOf(userIdentifier)));
                }
                UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(basicUserInfo.mustChangePassword() ? SigninResult.SUCCESS_CHANGE_PASSWORD : SigninResult.SUCCESS, authenticatedUser);
                return userAuthenticationInfo;
            }
            if (appFactory != null) {
                basicUserInfo.updateFailedLogin(connection, null);
            }
            connection.commit();
            connection.close();
            connection = null;
            SigninResult signinResult3 = signinResult = bl2 ? SigninResult.INVALID_PASSWORD_NEXT_ATTEMPT_WILL_DISABLE : SigninResult.INVALID_PASSWORD;
            if (appFactory != null) {
                ILog.WARNING(this.getClass(), (String)signinResult.englishMessage, (Object[])new Object[]{"User = " + String.valueOf(userIdentifier), "Total number of failed attempts = " + (basicUserInfo.getFailCount() + 1)});
            }
            UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(signinResult, authenticatedUser);
            return userAuthenticationInfo;
        }
        catch (NotFoundException notFoundException) {
            Object object = this.a;
            synchronized (object) {
                this.a.remove(string3);
                this.b.remove(string3.toLowerCase(Locale.ENGLISH));
                if (basicUserInfo != null) {
                    this.b.remove(basicUserInfo.userNameLower);
                    this.c.remove(basicUserInfo.id);
                }
            }
            UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(SigninResult.INVALID_USER);
            return userAuthenticationInfo;
        }
        catch (SQLException sQLException) {
            ILog.SEVERE(this.getClass(), (String)("Retrieval of user name \"" + string3 + "\" in database failed"), (Throwable)sQLException);
            UserAuthenticationInfo userAuthenticationInfo = new UserAuthenticationInfo(SigninResult.SYSTEM_FAILURE);
            return userAuthenticationInfo;
        }
        finally {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException) {
                    ILog.SEVERE(this.getClass(), (String)"Failed database rollback", (Throwable)sQLException);
                }
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    ILog.SEVERE(this.getClass(), (String)"Failed cloosing connection", (Throwable)sQLException);
                }
            }
        }
    }

    public final String createNewPasswordHash(String string, String string2) {
        try {
            return this.a.a(string, string2);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InternalError("Invalid key to create new user '" + string + "' password", invalidKeySpecException);
        }
    }

    public final boolean isOldPasswordMatching(BasicUserInfo basicUserInfo, String string) {
        Class<?> clazz = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        if (!clazz.equals(BasicUserInfo.class) && !clazz.equals(AuthenticatedUser.class)) {
            throw new RuntimeException("iiziServer is not the caller");
        }
        return this.a.a(basicUserInfo.userName, string, basicUserInfo.getPasswordHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(Connection connection, BasicUserInfo basicUserInfo) throws SQLException {
        Object object = this.a;
        synchronized (object) {
            this.a.remove(basicUserInfo.userName);
            this.b.remove(basicUserInfo.userNameLower);
            this.c.remove(basicUserInfo.id);
        }
    }

    static /* synthetic */ int[] a() {
        if (b != null) {
            return b;
        }
        int[] nArray = new int[IServer.State.values().length];
        try {
            nArray[IServer.State.NOT_STARTED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IServer.State.STARTED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IServer.State.STARTING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IServer.State.STOPPED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IServer.State.STOPPING.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        b = nArray;
        return nArray;
    }
}

