/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server;

import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.IPluginDescriptor;
import com.iizix.IWebServerCompression;
import com.iizix.IWebServiceEngine;
import com.iizix.NotFoundException;
import com.iizix.RunMode;
import com.iizix.SessionInfo;
import com.iizix.SystemConfig;
import com.iizix.TimeInterval;
import com.iizix.Utilities;
import com.iizix.Worker;
import com.iizix.XMLUtilities;
import com.iizix.barcode.BarcodeURNFactory;
import com.iizix.comm.IServerWebSocketCommListener;
import com.iizix.comm.session.SessionMgr;
import com.iizix.geo.RegionLocationService;
import com.iizix.jetty.IWSFileProviderServer;
import com.iizix.jetty.IWSUploaderAcceptor;
import com.iizix.jetty.IWSUploaderService;
import com.iizix.jetty.IWebServerDirectoryMapper;
import com.iizix.jetty.WSHelper;
import com.iizix.js.JSFiles;
import com.iizix.js.build.HTMLSourcesManager;
import com.iizix.js.build.ISourceResolver;
import com.iizix.license.ILicenseCallback;
import com.iizix.license.IServerLicenseSystem;
import com.iizix.license.LicenseSystem;
import com.iizix.mail.MailSender;
import com.iizix.nio.IWebSocketComm;
import com.iizix.nio.WebSocketAcceptor;
import com.iizix.os.IAdditonalInformation;
import com.iizix.os.OSSystemInfo;
import com.iizix.os.ThreadDeadlockDetector;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropFactory;
import com.iizix.prop.PropMgr;
import com.iizix.prop.StringMapProp;
import com.iizix.server.AbstractEndPoint;
import com.iizix.server.IEndPoint;
import com.iizix.server.IEndPointConstructor;
import com.iizix.server.IEndPointListener;
import com.iizix.server.IServer;
import com.iizix.server.IServerDisposeListener;
import com.iizix.server.PluginLoader;
import com.iizix.server.ServerLogger;
import com.iizix.server.ServerShellHolder;
import com.iizix.server.UserInfoHistoryEntry;
import com.iizix.server.acme.LetsEncryptDomain;
import com.iizix.server.api.IWebServerRequestPrinter;
import com.iizix.server.app.AppDefinition;
import com.iizix.server.app.AppFactory;
import com.iizix.server.db.BasicUserInfo;
import com.iizix.server.devel.ExternalBrowserPagesImpl;
import com.iizix.server.g;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.h;
import com.iizix.server.i;
import com.iizix.server.modules.IServerModule;
import com.iizix.server.prop.ServerApplicationSetupException;
import com.iizix.server.prop.ServerConfigEnvProps;
import com.iizix.server.prop.ServerProps;
import com.iizix.server.prop.ServerSettings;
import com.iizix.server.region.GeoPlugin;
import com.iizix.server.region.IPStack;
import com.iizix.server.region.IPWhoIs;
import com.iizix.server.user.ActiveUserSessions;
import com.iizix.server.user.UserProfileImageURNProvider;
import com.iizix.server.user.UserProfileStringURNProvider;
import com.iizix.server.weblogos.WebLogos;
import com.iizix.server.webthumbs.WebThumbs;
import com.iizix.server.wsfile.FileURNProvider;
import com.iizix.server.wsfile.ImageURNProvider;
import com.iizix.server.wsfile.WSFileProviderEngine;
import com.iizix.text.DefaultInfoHolder;
import com.iizix.text.IKStringInfoProvider;
import com.iizix.text.IKStringInfoProviderHolder;
import com.iizix.timeout.ITimerEngine;
import com.iizix.timeout.engine.TimerEngine;
import com.iizix.txp.ITXPCoordinator;
import com.iizix.txp.impl.TXPCoordinatorImpl;
import com.iizix.urn.URNFactory;
import com.iizix.urn.file.FileURNFactory;
import com.iizix.urn.file.IFileURNProvider;
import com.iizix.urn.image.IImageURNProvider;
import com.iizix.urn.image.ImageURNFactory;
import com.iizix.urn.user.IUserProfileImageURNProvider;
import com.iizix.urn.user.IUserProfileStringURNProvider;
import com.iizix.urn.user.UserProfileImageURNFactory;
import com.iizix.urn.user.UserProfileStringURNFactory;
import com.iizix.util.memjar.MemoryJarURLStreamHandlerFactory;
import com.iizix.util.xjar.XJarURLStreamHandlerFactory;
import com.iizix.virtual.VirtualThreadGroup;
import jakarta.mail.NoSuchProviderException;
import jakarta.mail.internet.AddressException;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class ServerShell
implements IWebServiceEngine,
WebSocketAcceptor,
IAdditonalInformation<UserInfoHistoryEntry>,
IServer,
IKStringInfoProviderHolder {
    private static boolean a;
    private static volatile ServerShell a;
    private static final File a;
    private static Worker a;
    private static PropFactory a;
    private static PropMgr a;
    private static ServerProps a;
    private static PluginLoader a;
    private static CopyOnWriteArrayList<IEndPointConstructor<?>> a;
    protected static MemoryJarURLStreamHandlerFactory memoryJarFactory;
    protected static XJarURLStreamHandlerFactory xjarFactory;
    private static WSFileProviderEngine a;
    private static boolean b;
    private static final AtomicLong a;
    private final Object a;
    private IServer.State a;
    private VirtualThreadGroup a;
    private final LinkedHashMap<Long, IEndPoint> a;
    private final LinkedHashSet<IEndPointListener> a;
    private final long a;
    private long b;
    private Throwable a;
    private ActiveUserSessions a;
    private final ExecutorService a;
    private final HashMap<String, AppDefinition> a;
    private Map<String, String> a;
    private final File b;
    private final OSSystemInfo<UserInfoHistoryEntry> a;
    private IServerLicenseSystem a;
    protected ExternalBrowserPagesImpl externalBrowserPages;
    private String[] a;
    private final ILicenseCallback a;
    private final ServerLogger a;
    private final IWebServerRequestPrinter a;
    private boolean c;
    private ServerSettings a;
    private GenericListener<IServerDisposeListener> a;
    private final ArrayList<IServerModule<?>> a;
    private final ArrayList<IEndPointConstructor<?>> b;
    private IEndPointListener[] a;
    private final ITXPCoordinator a;
    private boolean d;
    private final ArrayList<TimeInterval> c;
    private final ISourceResolver a;
    IWSFileProviderServer a;
    private WebThumbs a;
    private WebLogos a;
    private ArrayList<IWSUploaderAcceptor> d = true;
    final IWSUploaderService a = new ArrayList();

    static {
        a = Utilities.getCanonicalFile((File)new File("."));
        a = new CopyOnWriteArrayList();
        memoryJarFactory = MemoryJarURLStreamHandlerFactory.getInstance();
        xjarFactory = XJarURLStreamHandlerFactory.getInstance();
        a = new AtomicLong();
    }

    public static void updateWebServerRoot(File file) {
        JSFiles.getRoot((File)file);
    }

    public static void setWSFileProviderEngine(WSFileProviderEngine wSFileProviderEngine) {
        if (a != null) {
            throw new IllegalStateException("Engine is already set");
        }
        a = wSFileProviderEngine;
    }

    public static ServerShell getInstance() {
        return ServerShell.getInstance(null);
    }

    protected static ServerShell getInstance(Class<ServerShell> clazz) {
        if (a == null && !a) {
            a = true;
            if (clazz == null) {
                throw new InternalError("Server is not started");
            }
            try {
                a = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        return a;
    }

    public static IServer.State _getState() {
        ServerShell serverShell = a;
        return serverShell != null ? serverShell.getState() : IServer.State.STOPPED;
    }

    public static void _unregisterApplication(String string, Object object) {
        a.unregisterApplication(string, object);
    }

    public static void _registerApplication(String string, Object object) {
        a.registerApplication(string, object);
    }

    private static long a() {
        return a.incrementAndGet();
    }

    public static void registerRegionLocationServiceProviders(ServerSettings serverSettings, boolean bl) {
        if (bl) {
            RunMode.setRunMode((RunMode)RunMode.SERVER_DEVELOPMENT);
            RunMode.setWebServiceConfigurator((IWebServiceEngine)new i());
        } else if (!RunMode.isAnyServerRunMode()) {
            throw new IllegalStateException();
        }
        IWebServiceEngine iWebServiceEngine = RunMode.getWebServiceConfigurator();
        RegionLocationService.setGlobalCacheSize((int)serverSettings.getRegionLocationGlobalCacheSize());
        int n = 20000;
        boolean bl2 = false;
        boolean bl3 = true;
        RegionLocationService regionLocationService = new IPWhoIs(iWebServiceEngine, serverSettings);
        regionLocationService.configure(n, bl2, bl3);
        RegionLocationService.initialize((RegionLocationService)regionLocationService);
        regionLocationService = new GeoPlugin(iWebServiceEngine, serverSettings);
        regionLocationService.configure(n, bl2, bl3);
        RegionLocationService.initialize((RegionLocationService)regionLocationService);
        regionLocationService = new IPStack(iWebServiceEngine, serverSettings);
        regionLocationService.configure(n, bl2, bl3);
        RegionLocationService.initialize((RegionLocationService)regionLocationService);
    }

    public static void shutdownRegionLocationServiceProviders() {
        if (!StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass().getName().startsWith("com.iizix.test.server.")) {
            throw new IllegalStateException();
        }
        RegionLocationService.shutdown();
    }

    public static void initializeURNFactory() {
        URNFactory uRNFactory = URNFactory.getInstance();
        BarcodeURNFactory.initialize((URNFactory)uRNFactory);
        FileURNFactory.initialize((URNFactory)uRNFactory, (IFileURNProvider)FileURNProvider.getInstance());
        ImageURNFactory.initialize((URNFactory)uRNFactory, (IImageURNProvider)ImageURNProvider.getInstance());
        UserProfileStringURNFactory.initialize((URNFactory)uRNFactory, (IUserProfileStringURNProvider)UserProfileStringURNProvider.getInstance());
        UserProfileImageURNFactory.initialize((URNFactory)uRNFactory, (IUserProfileImageURNProvider)UserProfileImageURNProvider.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() throws Throwable {
        IServerModule[] iServerModuleArray;
        IServerLicenseSystem iServerLicenseSystem = this.a;
        if (iServerLicenseSystem != null) {
            iServerLicenseSystem.preOpen();
        }
        this.onStartServer();
        this.c();
        this.b = System.currentTimeMillis();
        this.loadApplications();
        Object object = this.a;
        synchronized (object) {
            iServerModuleArray = this.a.toArray(new IServerModule[this.a.size()]);
        }
        IServerModule[] iServerModuleArray2 = iServerModuleArray;
        int n = iServerModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iServerModuleArray2[n2];
            try {
                object.onServerReady(this);
            }
            catch (Throwable throwable) {
                ILog.SEVERE(this.getClass(), (String)("Server module " + object.getModuleName() + " failed"), (Throwable)throwable);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IServerLicenseSystem a() {
        boolean bl = true;
        if (this.a == null) {
            ServerShell serverShell = this;
            synchronized (serverShell) {
                if (this.a == null) {
                    String string = this.getRootDirectory();
                    ServerShell.updateWebServerRoot(string != null ? new File(string) : null);
                    Class<?> clazz = this.getClass();
                    String string2 = clazz.getName();
                    string2 = string2.substring(string2.lastIndexOf(46) + 1);
                    ILog.INFO(clazz, (String)("Initializing license system for the iiziServer product \"" + string2 + "\""));
                    LicenseSystem licenseSystem = LicenseSystem.getInstance();
                    try {
                        File file = new File(a, ".license");
                        if (!file.isDirectory()) {
                            Files.createDirectories(file.toPath(), new FileAttribute[0]);
                        }
                        licenseSystem.prepare((Object)this, ServerShell.class);
                        this.a = (IServerLicenseSystem)licenseSystem.getInstanceImplementation((Object)licenseSystem, IServerLicenseSystem.class);
                        this.a.assignCallback(this.a);
                        this.a.initialize(a, (Object)this, (Object)730961593280475361L, RunMode.class, file);
                    }
                    catch (Throwable throwable) {
                        bl = false;
                        ILog.SEVERE(clazz, (String)("Failed loading license system, the iiziServer product \"" + string2 + "\" cannot start"), (Throwable)throwable);
                    }
                }
            }
        }
        if (this.a == null && bl) {
            ILog.SEVERE(this.getClass(), (String)"Failed loading license system, the iiziServer product cannot start");
        }
        return this.a;
    }

    public ServerShell(File file) throws IOException, PropException {
        this.b = new ArrayList();
        this.a = new IEndPointListener[0];
        this.a = new TXPCoordinatorImpl();
        this.c = new ArrayList();
        this.a = new g(this);
        this.a = string -> {
            WSFileProviderEngine wSFileProviderEngine = a;
            return wSFileProviderEngine != null ? wSFileProviderEngine.getFileResourceFromExternalURL(string) : null;
        };
        this.a = new h(this);
        if (ServerShell._getState() != IServer.State.STOPPED || a != null) {
            throw new InternalError("Singleton already instantiated: server is started, starting or stopping state");
        }
        RunMode.setWebServiceConfigurator((IWebServiceEngine)this);
        this.a = new OSSystemInfo((IAdditonalInformation)this);
        this.a.startHistory(5000L);
        this.b = file != null ? file : new File("config.iiziServer");
        this.e();
        a.set(0L);
        ServerShellHolder.setInstance(this);
        DefaultInfoHolder.setKStringInfoProviderHolder((IKStringInfoProviderHolder)this);
        TimerEngine.getSystemInstance();
        ThreadDeadlockDetector.startDeadlockCheck();
        this.a = Executors.newVirtualThreadPerTaskExecutor();
    }

    void a(Map<String, String> map) {
        if (this.a != null) {
            throw new IllegalStateException("setAppAliases is already called");
        }
        this.a = Collections.unmodifiableMap(new HashMap<String, String>(map));
    }

    public Map<String, String> getAppAliases() {
        return this.a;
    }

    public File getCurrentDirectory() {
        return a;
    }

    public final long getStartTime() {
        return this.b;
    }

    @Override
    public final ExecutorService getExecutorService() {
        return this.a;
    }

    public final VirtualThreadGroup getServerThreadGroup() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IServer.State getState() {
        Object object = this.a;
        synchronized (object) {
            return this.a;
        }
    }

    public final ActiveUserSessions getActiveUserSessions() {
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadPluginsAndConfig() throws Throwable {
        Object object = this.a;
        synchronized (object) {
            if (this.a != IServer.State.STOPPED) {
                throw new IOException("Singleton already startup'ed: iiziServer is started, starting or stopping state");
            }
            if (a != null) {
                throw new IOException("Singleton already has a iiziServer Worker created!");
            }
            if (a != null) {
                throw new IOException("Singleton already has a iiziServer 'theOne' created!");
            }
            this.a = IServer.State.STARTING;
            a = this;
        }
        this.loadPlugins("");
        this.loadServerConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startServer() throws Throwable {
        Object object;
        String string = null;
        Object object2 = this.a;
        synchronized (object2) {
            if (this.a != IServer.State.STARTING) {
                throw new IOException("Singleton already startup'ed: iiziServer is not in starting state: " + String.valueOf((Object)this.a));
            }
            if (a != null) {
                throw new IOException("Singleton already has a iiziServer Worker created!");
            }
            if (a != this) {
                throw new IOException("Wrong singleton of iiziServer 'theOne' created!");
            }
            this.b();
            ILog.INFO(ServerShell.class, (String)("Starting iiziServer-" + SystemConfig.VERSION_BUILD));
            string = "Failed creation of Server Worker";
            a = new Worker(null);
            this.a = new ActiveUserSessions();
            this.a = VirtualThreadGroup.getSystemVirtualThreadGroup();
            Thread thread = new Thread(() -> {
                Worker worker;
                Object object;
                block13: {
                    object = this.a;
                    synchronized (object) {
                        worker = a;
                        b = true;
                    }
                    try {
                        this.a();
                    }
                    catch (Throwable throwable) {
                        this.a = throwable;
                        break block13;
                    }
                    ILog.FINE(this.getClass(), (String)"Worker started");
                    object = this.a;
                    synchronized (object) {
                        this.a.notifyAll();
                    }
                    try {
                        worker.process();
                    }
                    catch (Throwable throwable) {
                        ILog.SEVERE(this.getClass(), (String)"SERVER WORKER ERROR", (Throwable)throwable);
                    }
                    ILog.FINE(this.getClass(), (String)"Worker stopped");
                }
                worker.dispose();
                object = this.a;
                synchronized (object) {
                    b = false;
                    this.a = IServer.State.STOPPED;
                    this.a.notifyAll();
                }
            }, "iiziServer");
            thread.setPriority(10);
            object = this.a;
            synchronized (object) {
                thread.start();
                try {
                    this.a.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.a != null) {
            ILog.SEVERE(ServerShell.class, (String)string, (Throwable)this.a);
            this.dispose();
            throw this.a;
        }
        long l = System.currentTimeMillis();
        ILog.INFO(ServerShell.class, (String)("iiziServer started successfully, iiziServer @" + (l - this.b) + "ms, complete @" + (l - this.a) + "ms"));
        object = this.a;
        synchronized (object) {
            this.a = IServer.State.STARTED;
            this.a.notifyAll();
        }
        this.f();
    }

    public ServerLogger getServerLogger() {
        return this.a;
    }

    private void b() throws IOException {
        this.a.initializeLog();
    }

    protected void flushStartupLog() {
        this.a.a();
    }

    @Override
    public boolean registerRequestPrinter(String string, IWebServerRequestPrinter iWebServerRequestPrinter) {
        ExternalBrowserPagesImpl externalBrowserPagesImpl = this.externalBrowserPages;
        return externalBrowserPagesImpl != null ? externalBrowserPagesImpl.registerRequestPrinter(string, iWebServerRequestPrinter) : false;
    }

    @Override
    public boolean unregisterRequestPrinter(String string, IWebServerRequestPrinter iWebServerRequestPrinter) {
        ExternalBrowserPagesImpl externalBrowserPagesImpl = this.externalBrowserPages;
        return externalBrowserPagesImpl != null ? externalBrowserPagesImpl.unregisterRequestPrinter(string, iWebServerRequestPrinter) : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void c() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception exception) {
            ILog.SEVERE(this.getClass(), (String)("Failed registering Email verificator becasue creating SHA-256 MessageDigest failed: Unlimited cryptography strength is not enabled for the JRE/JDK: " + exception.getMessage()));
            return;
        }
        ServerShell serverShell = this;
        synchronized (serverShell) {
            if (this.c) {
                return;
            }
            this.c = true;
        }
        this.registerRequestPrinter("/iizi-email-verification", this.a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        Object object = this;
        synchronized (object) {
            if (!this.c) {
                return;
            }
            this.c = false;
        }
        try {
            object = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception exception) {
            ILog.SEVERE(this.getClass(), (String)("Failed registering Email verificator becasue creating SHA-256 MessageDigest failed: Unlimited cryptography strength is not enabled for the JRE/JDK: " + exception.getMessage()));
            return;
        }
        this.registerRequestPrinter("/iizi-email-verification", this.a);
        this.c = true;
    }

    @Deprecated(since="Java17")
    public String getExternalWebServerBaseURL() {
        String string;
        Object object = null;
        SessionInfo sessionInfo = SessionInfo.getSessionInfo();
        if (sessionInfo != null && (string = sessionInfo.getDomain()) != null && !string.isEmpty()) {
            object = (sessionInfo.isSecure() ? "https://" : "http://") + string;
        }
        if (object == null) {
            object = this.getServerSettings().getExternalHostName();
        }
        if (object != null && ((String)object).endsWith("/")) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    public String getEmailVerificationURL(BasicUserInfo basicUserInfo, String string, String string2) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (Exception exception) {
            ILog.SEVERE(this.getClass(), (String)("Failed getEmailVerificationURL(" + string + ") becasue creating SHA-256 MessageDigest failed: Unlimited cryptography strength is not enabled for the JRE/JDK: " + exception.getMessage()));
            return null;
        }
        Object object = string2;
        if (object == null) {
            object = this.getExternalWebServerBaseURL();
        }
        if (object != null) {
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            SecureRandom secureRandom = Utilities.getSecureRandom();
            byte[] byArray = new byte[7 + secureRandom.nextInt(11)];
            secureRandom.nextBytes(byArray);
            long l = secureRandom.nextLong();
            long l2 = basicUserInfo.id;
            messageDigest.update(byArray);
            messageDigest.update((string + "\t" + l + "\t" + l2).getBytes(Utilities.UTF8));
            byte[] byArray2 = messageDigest.digest();
            object = (String)object + "iizi-email-verification?e=" + Utilities.encodeURIComponent((String)string) + "&q=" + l + "&s=" + Utilities.toHex((byte[])byArray) + "&v=" + Utilities.encodeURIComponent((String)Utilities.encodeBase64((byte[])byArray2)) + "&w=" + l2;
        }
        return object;
    }

    private void e() throws IOException {
        ServerShell.initializeURNFactory();
        a = new PropFactory(1);
        a.loadPropDefinitions();
        a = a.createPropertyManager(1, null);
        a = new PluginLoader(a, this.getClass().getClassLoader());
        a = ServerProps.createServerProps(a);
        this.a.a(a);
        StringMapProp stringMapProp = a.getServerEnv();
        try {
            stringMapProp.addSystemProperties();
        }
        catch (PropException propException) {
            ILog.SEVERE(this.getClass(), (String)"Failed to update environment", (Throwable)propException);
        }
        ILog.INFO(this.getClass(), (String)("Server version " + SystemConfig.VERSION_BUILD + " environment"), (Object)stringMapProp);
    }

    public final File getServerConfigFile() {
        return this.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void loadServerConfig() throws IOException, PropException {
        ServerSettings serverSettings = a.loadServerSettings(this, this.b);
        this.a = a.getServerSettings().clone();
        Object object = this;
        synchronized (object) {
            if (a == null) {
                a = new WSFileProviderEngine(serverSettings);
            }
        }
        object = new StringBuilder("Server configuration loaded, found configuration:");
        ServerConfigEnvProps[] serverConfigEnvPropsArray = a.getServerSettings().getServerConfigEnvironments();
        int n = serverConfigEnvPropsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerConfigEnvProps serverConfigEnvProps = serverConfigEnvPropsArray[n2];
            ((StringBuilder)object).append("\n - Environment \"").append(serverConfigEnvProps.getPropName()).append("\" - ");
            Set<String> set = serverConfigEnvProps.getAllowedDomainSet();
            String string = String.join((CharSequence)", ", set);
            ((StringBuilder)object).append((String)(string.isEmpty() ? "(no restrictions)" : (set.size() == 1 ? "restricted to domain: " + string : "restricted to domains: " + string)));
            ++n2;
        }
        ILog.INFO(this.getClass(), (String)((StringBuilder)object).toString());
    }

    @Override
    public final ServerProps getServerProperties() {
        return a;
    }

    public ServerSettings getServerSettings() {
        return a.getServerSettings();
    }

    public void configureSessionMgr() {
        ServerSettings serverSettings = a.getServerSettings();
        SessionMgr.getInstance().setup(serverSettings.getClientDormantTimeout(), serverSettings.getClientIdleTimeout(), serverSettings.getClientHeartBeatInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveServerConfig() throws IOException {
        if (!this.b.canWrite()) {
            throw new IOException("Configuration file \"" + this.b.getAbsolutePath() + "\" is not writable");
        }
        ServerSettings serverSettings = a.getServerSettings();
        if (this.a.equals((Object)serverSettings)) {
            return false;
        }
        Object object = "";
        ServerSettings serverSettings2 = serverSettings;
        synchronized (serverSettings2) {
            Object object2;
            Object object3;
            serverSettings = serverSettings.clone();
            if (this.b.exists()) {
                object3 = this.b.getPath();
                object2 = new Timestamp(System.currentTimeMillis()).toString().replace(':', '.').replace(' ', '_');
                int n = ((String)object3).lastIndexOf(".iiziServer");
                File file = new File(n < 0 ? (String)object3 + "-" + (String)object2 : ((String)object3).substring(0, n) + "-" + (String)object2 + ".iiziServer");
                File file2 = this.b;
                try {
                    Path path = this.b.toPath();
                    file2 = file;
                    Files.copy(path, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (InvalidPathException invalidPathException) {
                    throw new IOException("Invalid path for backup file " + String.valueOf(file2) + ": " + invalidPathException.getMessage());
                }
                object = ", backup created in \"" + file.getAbsolutePath() + "\"";
            }
            object3 = File.createTempFile("config", ".iiziServer", this.b.getParentFile());
            try {
                XMLUtilities.saveXMLDocument((Document)a.createDocument((PropCnr)serverSettings), (File)object3);
            }
            catch (TransformerException transformerException) {
                throw new IOException("Failed XML transformation", transformerException);
            }
            object2 = this.b;
            try {
                Path path = ((File)object3).toPath();
                object2 = this.b;
                Files.copy(path, this.b.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (InvalidPathException invalidPathException) {
                throw new IOException("Invalid path for server configuration file " + String.valueOf(object2) + ": " + invalidPathException.getMessage());
            }
            ((File)object3).delete();
            this.a = serverSettings;
        }
        ILog.INFO(this.getClass(), (String)("Saved new server configuration file \"" + this.b.getAbsolutePath() + "\"" + (String)object));
        return true;
    }

    @Override
    public MailSender getDefaultMailSender() throws NotFoundException, AddressException, NoSuchProviderException, IOException {
        return this.getMailSender(null);
    }

    @Override
    public MailSender getMailSender(String string) throws NotFoundException, AddressException, NoSuchProviderException, IOException {
        ServerSettings serverSettings = this.a;
        if (serverSettings == null) {
            throw new NotFoundException("ServerSettings not loaded");
        }
        return serverSettings.getMailSender(string, this.a, a);
    }

    private void f() {
        LetsEncryptDomain letsEncryptDomain;
        LetsEncryptDomain[] letsEncryptDomainArray = (LetsEncryptDomain[])a.getServerSettings().getAllProps(LetsEncryptDomain.class);
        if (letsEncryptDomainArray.length == 0) {
            return;
        }
        String string = ": ";
        StringBuilder stringBuilder = new StringBuilder("Starting Let's Encrypt renewal processing for the domain");
        if (letsEncryptDomainArray.length > 1) {
            stringBuilder.append('s');
        }
        int n = 0;
        LetsEncryptDomain[] letsEncryptDomainArray2 = letsEncryptDomainArray;
        int n2 = letsEncryptDomainArray.length;
        int n3 = 0;
        while (n3 < n2) {
            letsEncryptDomain = letsEncryptDomainArray2[n3];
            stringBuilder.append(string).append(letsEncryptDomain.getDomain());
            string = ++n == letsEncryptDomainArray.length - 1 ? " and " : ", ";
            ++n3;
        }
        ILog.INFO(this.getClass(), (String)stringBuilder.toString());
        letsEncryptDomainArray2 = letsEncryptDomainArray;
        n2 = letsEncryptDomainArray.length;
        n3 = 0;
        while (n3 < n2) {
            letsEncryptDomain = letsEncryptDomainArray2[n3];
            letsEncryptDomain.startRenewal(this);
            ++n3;
        }
    }

    @Override
    public abstract void loadApplications() throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final AppDefinition registerApplication(String string, AppDefinition appDefinition) throws ServerApplicationSetupException {
        long l = System.currentTimeMillis();
        String string2 = appDefinition.getServerEnvironmentName();
        ILog.INFO(ServerShell.class, (String)("Registering application '" + string + "' with server environment '" + string2 + "'"));
        a.getServerSettings().onApplicationLoad(appDefinition.getFactory());
        long l2 = System.currentTimeMillis() - l;
        if (l2 > 10L) {
            ILog.INFO(ServerShell.class, (String)("Registered application '" + string + "' with server environment '" + string2 + "' @" + l2 + "ms"));
        }
        boolean bl = this.a;
        synchronized (bl) {
            return this.a.put(string, appDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void g() {
        AppDefinition[] appDefinitionArray;
        boolean bl = this.a;
        synchronized (bl) {
            appDefinitionArray = this.a.values().toArray(new AppDefinition[this.a.size()]);
            this.a.clear();
        }
        if (appDefinitionArray.length > 0) {
            long l = System.currentTimeMillis();
            ServerSettings serverSettings = a.getServerSettings();
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            AppDefinition[] appDefinitionArray2 = appDefinitionArray;
            int n = appDefinitionArray.length;
            int n2 = 0;
            while (n2 < n) {
                AppDefinition appDefinition = appDefinitionArray2[n2];
                AppFactory appFactory = appDefinition.getFactory();
                appFactory.dispose();
                appDefinition.dispose();
                serverSettings.onApplicationUnload(appFactory);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                    string = "s";
                }
                stringBuilder.append(appDefinition.id);
                ++n2;
            }
            ILog.INFO(ServerShell.class, (String)("Unregistered " + appDefinitionArray.length + " application" + string + " from plug-ins @" + (System.currentTimeMillis() - l) + "ms: app ID" + string + " = " + String.valueOf(stringBuilder)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppFactory getApplication(String string) {
        AppDefinition appDefinition;
        String string2 = (String)this.a.get(string);
        if (string2 != null) {
            string = string2;
        }
        boolean bl = this.a;
        synchronized (bl) {
            appDefinition = (AppDefinition)this.a.get(string);
        }
        if (appDefinition == null) {
            return null;
        }
        if (appDefinition.isHotDeployEnabled()) {
            try {
                appDefinition.reload(this, false);
            }
            catch (PropException | ServerApplicationSetupException | IOException throwable) {
                ILog.SEVERE(this.getClass(), (String)("Failed hot deploy reload of application " + string), (Throwable)throwable);
            }
        }
        return appDefinition.getFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AppFactory[] getApplications() {
        ArrayList<AppFactory> arrayList = new ArrayList<AppFactory>();
        boolean bl = this.a;
        synchronized (bl) {
            for (AppDefinition appDefinition : this.a.values()) {
                AppFactory appFactory = appDefinition.getFactory();
                if (appFactory == null) continue;
                arrayList.add(appFactory);
            }
        }
        return arrayList.toArray(new AppFactory[arrayList.size()]);
    }

    public void onApplicationSessionStarted(AppSessionGyro appSessionGyro) {
        appSessionGyro.getAppFactory().onApplicationSessionStarted(appSessionGyro);
        a.getServerSettings().onApplicationSessionStarted(appSessionGyro);
    }

    public void onApplicationSessionStopped(AppSessionGyro appSessionGyro) {
        a.getServerSettings().onApplicationSessionStopped(appSessionGyro);
        appSessionGyro.getAppFactory().onApplicationSessionStopped(appSessionGyro);
    }

    @Override
    public synchronized boolean addDisposeListener(IServerDisposeListener iServerDisposeListener) {
        if (this.a == null) {
            this.a = new GenericListener(IServerDisposeListener.class);
        }
        return this.a.addListener((Object)iServerDisposeListener);
    }

    @Override
    public synchronized boolean removeDisposeListener(IServerDisposeListener iServerDisposeListener) {
        return this.a != null ? this.a.removeListener((Object)iServerDisposeListener) : false;
    }

    @Override
    public void onStartServer() throws Throwable {
    }

    protected final Worker getWorker() {
        return a;
    }

    @Override
    public final boolean dispose() {
        return this.a(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(boolean bl) {
        IServerModule[] iServerModuleArray;
        if (a != this) {
            return false;
        }
        Object object = this.a;
        synchronized (object) {
            block25: {
                if (this.a != IServer.State.NOT_STARTED && this.a != IServer.State.STOPPED && this.a != IServer.State.STOPPING) break block25;
                return false;
            }
            this.a = IServer.State.STOPPING;
        }
        long l = System.currentTimeMillis();
        ILog.INFO(ServerShell.class, (String)"Server is initiating shutting down");
        boolean bl2 = this.a;
        if (bl2 != null) {
            bl2.forEach(iServerDisposeListener -> iServerDisposeListener.onDispose(this));
        }
        this.d();
        this.onDispose();
        ITimerEngine iTimerEngine = TimerEngine.getSystemInstance();
        iTimerEngine.dispose();
        this.g();
        Object object2 = this.a;
        synchronized (object2) {
            iServerModuleArray = this.a.toArray(new IServerModule[this.a.size()]);
        }
        Object object3 = iServerModuleArray;
        int n = iServerModuleArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = object3[n2];
            this.removeModule((IServerModule<?>)object2);
            ++n2;
        }
        object2 = a;
        a = null;
        if (object2 != null) {
            object2.dispose();
        }
        Object object4 = this.a;
        synchronized (object4) {
            if (b) {
                try {
                    this.a.wait(60000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.a.notifyAll();
            this.a = IServer.State.STOPPED;
            a = null;
        }
        object4 = a;
        if (object4 != null) {
            a = null;
            ((WSFileProviderEngine)object4).dispose();
        }
        if (bl2 != null) {
            bl2.forEach(iServerDisposeListener -> iServerDisposeListener.onDisposed(this));
        }
        this.onDisposed();
        ExecutorService executorService = this.a;
        if (executorService != null) {
            ILog.INFO(ServerShell.class, (String)"Server is shutting down executor service");
            executorService.shutdown();
            if (executorService instanceof AutoCloseable) {
                object3 = executorService;
                try {
                    object3.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ThreadDeadlockDetector.stopDeadlockCheck();
        ILog.INFO(ServerShell.class, (String)("Server has successfully shut-down " + (System.currentTimeMillis() - l) + "ms"));
        this.a.b();
        if (bl) {
            System.out.println("\nExiting server...");
            System.exit(0);
        } else {
            System.out.println("\nServer service stopped");
        }
        return true;
    }

    protected void onDispose() {
    }

    protected void onDisposed() {
    }

    public final PropFactory getPropertyFactory() {
        return a;
    }

    @Override
    public final PropMgr getPropertyManager() {
        return a;
    }

    @Override
    public final PropCnr loadFile(File file) throws IOException, PropException {
        return a.loadPropTree(a, file, true);
    }

    @Override
    public final PropCnr loadFile(String string, InputStream inputStream) throws IOException, PropException {
        return a.loadPropTree(a, string, inputStream, true);
    }

    public final void saveFile(File file, PropCnr propCnr) throws IOException, PropException {
        try {
            XMLUtilities.saveXMLDocument((Document)a.createDocument(propCnr), (File)file);
        }
        catch (TransformerException transformerException) {
            throw new IOException("Failed transforming the XML document for file " + file.getAbsolutePath(), transformerException);
        }
    }

    public boolean getAccessibleEnvironments(HttpServletRequest httpServletRequest, List<ServerConfigEnvProps> list) {
        String string = WSHelper.getDomainFromURL((HttpServletRequest)httpServletRequest);
        String string2 = WSHelper.getDomainFromHostHeader((HttpServletRequest)httpServletRequest);
        boolean bl = httpServletRequest.isSecure();
        if (!string.equalsIgnoreCase(string2)) {
            ILog.INFO(this.getClass(), (String)"Request from \"{}\" without matching \"host\" rejected: \"host\" header field = {}, URL = {}", (Object[])new Object[]{string, string2, httpServletRequest.getRequestURL()});
            return false;
        }
        ServerConfigEnvProps[] serverConfigEnvPropsArray = a.getServerSettings().getServerConfigEnvironments();
        int n = serverConfigEnvPropsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerConfigEnvProps serverConfigEnvProps = serverConfigEnvPropsArray[n2];
            if (serverConfigEnvProps.isDomainAccessAllowed(string, bl)) {
                list.add(serverConfigEnvProps);
            }
            ++n2;
        }
        return true;
    }

    @Override
    public final List<IPluginDescriptor<?>> loadPlugins(String string) throws IOException {
        return a.loadPlugins(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addModule(IServerModule<?> iServerModule) {
        IServer.State state = this.getState();
        if (state == IServer.State.STOPPING) throw new IllegalStateException();
        if (state == IServer.State.STOPPED) {
            throw new IllegalStateException();
        }
        boolean bl = this.a;
        synchronized (bl) {
            if (this.a.contains(iServerModule)) {
                return false;
            }
        }
        String string = iServerModule.getClass().getName();
        String string2 = "(unknown)";
        IEndPointConstructor<?> iEndPointConstructor = null;
        try {
            String string3 = iServerModule.getModuleName();
            string2 = iServerModule.getModuleDescripion();
            ILog.INFO(this.getClass(), (String)("Loading server module " + string3 + ": " + string2));
            iEndPointConstructor = iServerModule.initialize(this);
            this.registerEndPointConstructor(iEndPointConstructor);
            boolean bl2 = this.a;
            synchronized (bl2) {
                this.a.add(iServerModule);
                this.b.add(iEndPointConstructor);
                return true;
            }
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), (String)("Failed loading and initializing server module " + string + ": " + string2), (Throwable)throwable);
            try {
                ILog.WARNING(this.getClass(), (String)("Disposing of server module " + string + ": " + string2));
                iServerModule.dispose();
                if (iEndPointConstructor == null) return true;
                this.unregisterEndPointConstructor(iEndPointConstructor);
                return true;
            }
            catch (Throwable throwable2) {
                ILog.SEVERE(this.getClass(), (String)("Failed disposing server module " + string + ": " + string2));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeModule(IServerModule<?> iServerModule) {
        IEndPointConstructor iEndPointConstructor;
        Object object = this.a;
        synchronized (object) {
            int n;
            block7: {
                n = this.a.indexOf(iServerModule);
                if (n >= 0) break block7;
                return false;
            }
            iEndPointConstructor = (IEndPointConstructor)this.b.remove(n);
            this.a.remove(iServerModule);
        }
        object = iServerModule.getClass().getName();
        String string = "(unknown)";
        if (iEndPointConstructor != null) {
            this.unregisterEndPointConstructor(iEndPointConstructor);
        }
        try {
            object = iServerModule.getModuleName();
            string = iServerModule.getModuleDescripion();
            ILog.INFO(this.getClass(), (String)("Disposing of server module " + (String)object + ": " + string));
            iServerModule.dispose();
        }
        catch (Throwable throwable) {
            ILog.SEVERE(this.getClass(), (String)("Failed disposing server module " + (String)object + ": " + string), (Throwable)throwable);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean registerEndPointConstructor(IEndPointConstructor<?> iEndPointConstructor) {
        if (iEndPointConstructor == null) {
            return false;
        }
        boolean bl = a;
        synchronized (bl) {
            block5: {
                if (!a.contains(iEndPointConstructor)) break block5;
                return false;
            }
            a.add(iEndPointConstructor);
            this.a = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean unregisterEndPointConstructor(IEndPointConstructor<?> iEndPointConstructor) {
        boolean bl = a;
        synchronized (bl) {
            block4: {
                if (!a.remove(iEndPointConstructor)) break block4;
                this.a = null;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object isRequestURIAccepted(IWebSocketComm iWebSocketComm, String string, Map<String, List<String>> map) {
        Object object = this.a(iWebSocketComm, string, map);
        IEndPoint iEndPoint = null;
        if (object instanceof IEndPoint) {
            IEndPoint iEndPoint2;
            iEndPoint = iEndPoint2 = (IEndPoint)object;
        } else if (object instanceof IServerWebSocketCommListener) {
            IServerWebSocketCommListener iServerWebSocketCommListener = (IServerWebSocketCommListener)object;
            iEndPoint = (IEndPoint)iServerWebSocketCommListener.getEndPoint();
        }
        if (iEndPoint != null) {
            Object object2 = this.a;
            synchronized (object2) {
                IEndPoint iEndPoint3 = this.a.put(iEndPoint.getServerSessionID(), iEndPoint);
                if (iEndPoint3 != null) {
                    ILog.SEVERE(this.getClass(), (String)"Previous session exists", (Object[])new Object[]{"New session = " + String.valueOf(iEndPoint), "Old session = " + String.valueOf(iEndPoint3)});
                }
            }
            IEndPointListener[] iEndPointListenerArray = this.a();
            int n = iEndPointListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                object2 = iEndPointListenerArray[n2];
                object2.onEndPointCreated(iEndPoint);
                ++n2;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHandledContextPaths() {
        String[] stringArray = this.a;
        if (stringArray == null) {
            boolean bl = a;
            synchronized (bl) {
                stringArray = this.a;
                if (stringArray == null) {
                    LinkedHashMap<String, IEndPointConstructor> linkedHashMap = new LinkedHashMap<String, IEndPointConstructor>();
                    for (IEndPointConstructor iEndPointConstructor : a) {
                        String[] stringArray2 = iEndPointConstructor.getHandledContextPaths();
                        if (stringArray2 == null) continue;
                        String[] stringArray3 = stringArray2;
                        int n = stringArray2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string = stringArray3[n2];
                            IEndPointConstructor iEndPointConstructor2 = linkedHashMap.putIfAbsent(string, iEndPointConstructor);
                            if (iEndPointConstructor2 != null) {
                                throw new InternalError("EndPoint " + iEndPointConstructor.getClass().getName() + ": duplicate context path " + string + " already registered by " + iEndPointConstructor2.getClass().getName());
                            }
                            ++n2;
                        }
                    }
                    this.a = linkedHashMap.keySet().toArray(new String[linkedHashMap.size()]);
                    stringArray = this.a;
                }
            }
        }
        return stringArray;
    }

    private Object a(IWebSocketComm iWebSocketComm, String string, Map<String, List<String>> map) {
        String string2 = string;
        String string3 = null;
        int n = string.indexOf(63);
        if (n == 0) {
            this.a(iWebSocketComm, "Only Query URI", string);
            return null;
        }
        if (n > 0) {
            string = string.substring(0, n);
            string3 = string2.substring(n + 1);
        }
        try {
            for (IEndPointConstructor iEndPointConstructor : a) {
                Object OBJECT = iEndPointConstructor.isHandled(this, iWebSocketComm, string, string3, map);
                if (OBJECT == null) continue;
                if (map == null) {
                    return Boolean.TRUE;
                }
                IEndPoint iEndPoint = iEndPointConstructor.createInstance(this, ServerShell.a(), iWebSocketComm, string, string3, map, OBJECT);
                IServerWebSocketCommListener iServerWebSocketCommListener = iEndPoint.getWebSocketCommListener(iWebSocketComm);
                if (iServerWebSocketCommListener != null && !(iServerWebSocketCommListener.getEndPoint() instanceof IEndPoint)) {
                    throw new InternalError("Invalid end point return for getWebSocketCommListener");
                }
                return iServerWebSocketCommListener;
            }
        }
        catch (Throwable throwable) {
            String string4 = iWebSocketComm == null ? "" : " from " + iWebSocketComm.getRemoteAddr() + " / " + iWebSocketComm.getRemoteHost();
            ILog.SEVERE(ServerShell.class, (String)("Could not create Worker for a new end point" + string4 + ". URI = \"" + string + "\", Query = \"" + string3 + "\""), (Throwable)throwable);
        }
        return null;
    }

    private void a(IWebSocketComm iWebSocketComm, String string, String string2) {
        String string3 = iWebSocketComm == null ? "" : " from " + iWebSocketComm.getRemoteAddr() + " / " + iWebSocketComm.getRemoteHost();
        ILog.WARNING(ServerShell.class, (String)("Rejected invalid WebSocket request" + string3 + ": " + string + ". URI = \"" + string2 + "\""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IEndPoint[] getEndPointsInstances() {
        boolean bl = this.a;
        synchronized (bl) {
            return this.a.values().toArray(new AbstractEndPoint[this.a.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onEndPointDisposed(IEndPoint iEndPoint) {
        long l = iEndPoint.getServerSessionID();
        Object object = this.a;
        synchronized (object) {
            if (this.a.get(l) != iEndPoint || this.a.remove(l) != iEndPoint) {
                ILog.SEVERE(ServerShell.class, (String)"onEndPointDisposed called with unmatching connectionID and endPoint instance, or the instance is already disposed of");
                return;
            }
        }
        ILog.FINE(this.getClass(), (String)("EndPoint disposed: " + String.valueOf(iEndPoint)));
        if (iEndPoint instanceof IWSUploaderAcceptor) {
            object = (IWSUploaderAcceptor)iEndPoint;
            this.removeFileUploader((IWSUploaderAcceptor)object);
        }
        IEndPointListener[] iEndPointListenerArray = this.a();
        int n = iEndPointListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEndPointListener iEndPointListener = iEndPointListenerArray[n2];
            iEndPointListener.onEndPointDisposed(iEndPoint);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final IEndPoint[] addEndPointListener(IEndPointListener iEndPointListener) {
        boolean bl = this.a;
        synchronized (bl) {
            if (this.a.add(iEndPointListener)) {
                this.a = this.a.toArray(new IEndPointListener[this.a.size()]);
            }
            return this.a.values().toArray(new IEndPoint[this.a.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeEndPointListener(IEndPointListener iEndPointListener) {
        boolean bl = this.a;
        synchronized (bl) {
            boolean bl2 = this.a.remove(iEndPointListener);
            if (bl2) {
                this.a = this.a.toArray(new IEndPointListener[this.a.size()]);
            }
            return bl2;
        }
    }

    private final IEndPointListener[] a() {
        return this.a;
    }

    @Override
    public final ITXPCoordinator getTXPCoordinator() {
        return this.a;
    }

    public final IKStringInfoProvider getKStringInfoProvider() {
        return IKStringInfoProvider.getKStringInfoProviderInstance();
    }

    public void registerApplication(String string, Object object) {
        ILog.INFO(ServerShell.class, (String)("Registering application '" + string + "'"));
    }

    public void unregisterApplication(String string, Object object) {
        ILog.INFO(ServerShell.class, (String)("Unregistering application '" + string + "'"));
    }

    public final OSSystemInfo.HistoryEntry<UserInfoHistoryEntry>[] getHistory(long l) {
        return this.a.getHistory(l);
    }

    public final Class<UserInfoHistoryEntry> getInfoClass() {
        return UserInfoHistoryEntry.class;
    }

    public final UserInfoHistoryEntry getAdditionalInformation() {
        ActiveUserSessions activeUserSessions = this.a;
        return activeUserSessions != null ? new UserInfoHistoryEntry(activeUserSessions.getCurrentAppSessionCount(), activeUserSessions.getCurrentSessionCount()) : new UserInfoHistoryEntry(0, 0);
    }

    public final boolean isUserLoginEnabled() {
        return this.d;
    }

    public final void setUserLoginEnabled(boolean bl) throws SecurityException {
        this.d = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isUserLoginPermittedNow() {
        TimeInterval[] timeIntervalArray;
        boolean bl = this.c;
        synchronized (bl) {
            int n;
            block6: {
                n = this.c.size();
                if (n != 0) break block6;
                return true;
            }
            timeIntervalArray = this.c.toArray(new TimeInterval[n]);
        }
        long l = System.currentTimeMillis();
        TimeInterval[] timeIntervalArray2 = timeIntervalArray;
        int n = timeIntervalArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeInterval timeInterval = timeIntervalArray2[n2];
            if (timeInterval.isIncluded(l)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TimeInterval[] getUserLoginProhibitedIntervals() {
        boolean bl = this.c;
        synchronized (bl) {
            int n = this.c.size();
            return n == 0 ? TimeInterval.NO_INTERVALS : this.c.toArray(new TimeInterval[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addUserLoginProhibitedInterval(TimeInterval timeInterval) throws SecurityException {
        boolean bl = this.c;
        synchronized (bl) {
            block4: {
                if (!this.c.contains(timeInterval)) break block4;
                return false;
            }
            return this.c.add(timeInterval);
        }
    }

    protected void initializeCompressedFiles() throws IOException {
        long l = System.currentTimeMillis();
        IWebServerCompression iWebServerCompression = this.getWebServerCompression();
        HTMLSourcesManager.getInstance((IWebServerCompression)iWebServerCompression, (ISourceResolver)this.a).compressHTMLFiles(new File(this.getRootDirectory()), iWebServerCompression, this.doCompressNormalHTML());
        ILog.INFO(this.getClass(), (String)("Initialized CSS and JS @" + (System.currentTimeMillis() - l) + "ms"));
    }

    public ISourceResolver getSourceResolver() {
        return this.a;
    }

    public abstract IWebServerDirectoryMapper getWebServerDirectoryMapper();

    public WSFileProviderEngine getFileProviderEngine() {
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebThumbs getWebThumbs() throws IOException {
        if (this.a == null) {
            ServerShell serverShell = this;
            synchronized (serverShell) {
                if (this.a == null) {
                    this.a = new WebThumbs(this);
                }
            }
        }
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebLogos getWebLogos() throws IOException {
        if (this.a == null) {
            ServerShell serverShell = this;
            synchronized (serverShell) {
                if (this.a == null) {
                    this.a = new WebLogos(this);
                }
            }
        }
        return this.a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileUploader(IWSUploaderAcceptor iWSUploaderAcceptor) {
        Object object;
        if (!(iWSUploaderAcceptor instanceof AbstractEndPoint)) {
            throw new ClassCastException("Not a valid end point");
        }
        boolean bl = this.d;
        if (bl == null) {
            object = this;
            synchronized (object) {
                if (this.d == null) {
                    this.d = new ArrayList();
                }
                bl = this.d;
            }
        }
        boolean bl2 = bl;
        object = bl2;
        synchronized (bl2) {
            if (bl.contains(iWSUploaderAcceptor)) {
                throw new IllegalStateException("End point already added: " + String.valueOf(iWSUploaderAcceptor));
            }
            bl.add(iWSUploaderAcceptor);
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileUploader(IWSUploaderAcceptor iWSUploaderAcceptor) {
        if (this.d != null) {
            boolean bl = this.d;
            synchronized (bl) {
                this.d.remove(iWSUploaderAcceptor);
            }
        }
    }

    public IWSUploaderService getWSUploaderService() {
        return this.a;
    }

    public abstract boolean doCompressNormalHTML();

    public abstract IWebServerCompression getWebServerCompression();

    public File getWebServerMapping(String string) {
        return null;
    }

    public File getWebServerDirectoryAlias(String string) {
        return null;
    }

    public String getETag(File file) {
        return null;
    }
}

