/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.plugin.statusbar;

import com.tabnine.eclipse.shared.api.ConcurrentNonNullState;
import com.tabnine.eclipse.shared.api.binary.requests.CapabilitiesResponse;
import com.tabnine.eclipse.shared.api.binary.requests.config.StateResponse;
import com.tabnine.eclipse.shared.api.services.BinaryStateService;
import com.tabnine.eclipse.shared.api.services.CapabilitiesService;
import com.tabnine.eclipse.shared.api.services.SnoozeService;
import java.util.Objects;
import org.eclipse.ui.services.IDisposable;

public class TabnineStatusBarState
extends ConcurrentNonNullState<StatusBarStateData>
implements SnoozeService.SnoozeToggledListener,
IDisposable {
    private static final String STATUS_BAR_DEFAULT_TEXT = "Tabnine";
    private StateResponse stateResponse;

    public TabnineStatusBarState() {
        super((Object)new StatusBarStateData(STATUS_BAR_DEFAULT_TEXT, false));
        CapabilitiesService.getInstance().subscribe(this::onCapabilitiesChanged);
        BinaryStateService.getInstance().subscribe(this::onStateChanged);
        SnoozeService.getInstance().subscribe((SnoozeService.SnoozeToggledListener)this);
    }

    private void updateState() {
        if (this.stateResponse == null || !CapabilitiesService.getInstance().isReady()) {
            return;
        }
        StatusBarStateData newState = new StatusBarStateData();
        newState.text = "Tabnine " + this.stateResponse.serviceLevel;
        newState.isSnoozed = SnoozeService.getInstance().isSnoozed();
        this.set(newState);
    }

    private void onCapabilitiesChanged(CapabilitiesResponse _r) {
        this.updateState();
    }

    private void onStateChanged(StateResponse stateResponse) {
        this.stateResponse = stateResponse;
        this.updateState();
    }

    public void onSnoozeToggle(boolean isSnoozed) {
        this.updateState();
    }

    public void dispose() {
        CapabilitiesService.getInstance().unsubscribe(this::onCapabilitiesChanged);
        BinaryStateService.getInstance().unsubscribe(this::onStateChanged);
        SnoozeService.getInstance().unsubscribe((SnoozeService.SnoozeToggledListener)this);
    }

    public static class StatusBarStateData {
        public String text;
        public boolean isSnoozed;

        public StatusBarStateData() {
        }

        public StatusBarStateData(String text, boolean isSnoozed) {
            this.text = text;
            this.isSnoozed = isSnoozed;
        }

        public int hashCode() {
            return Objects.hash(this.text);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatusBarStateData other = (StatusBarStateData)obj;
            return Objects.equals(this.text, other.text) && this.isSnoozed == other.isSnoozed;
        }
    }
}

