/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.value;

import com.iizix.LocaleInfo;
import com.iizix.Value;
import com.iizix.text.DefaultInfoHolder;
import com.iizix.text.KString;
import com.iizix.text.KStringException;
import com.iizix.text.KStringParseException;
import com.iizix.value.IValueObject;
import com.iizix.value.b;
import java.text.Format;
import java.text.ParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KStringValue
implements IValueObject<KString> {
    @Override
    public final Value.Type getValueType() {
        return Value.Type.KString;
    }

    @Override
    public Class<KString> getValueClass() {
        return KString.class;
    }

    @Override
    public String getDescription() {
        return "String in HTML with tag capabilities to reference text tables and VirtualSpace texts strings";
    }

    @Override
    public KString createDefault() {
        return KString.DEFAULT;
    }

    @Override
    public KString parse(String string) throws ParseException {
        try {
            return new KString(KString.Type.HTML, string);
        }
        catch (KStringParseException kStringParseException) {
            ParseException parseException = new ParseException(kStringParseException.getMessage(), kStringParseException.getParsePosition());
            parseException.initCause(kStringParseException);
            throw parseException;
        }
        catch (KStringException kStringException) {
            ParseException parseException = new ParseException(kStringException.getMessage(), 0);
            parseException.initCause(kStringException);
            throw parseException;
        }
    }

    @Override
    public KString parse(String string, String string2, LocaleInfo localeInfo) throws ParseException, IllegalArgumentException {
        Format format;
        if (string2 != null && (format = this.getFormatter(string2, localeInfo)) != null) {
            return (KString)format.parseObject(string);
        }
        return this.parse(string);
    }

    @Override
    public Format getFormatter(String string, LocaleInfo localeInfo) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        return new b(this, switch (string.toLowerCase()) {
            case "html" -> 0;
            case "rawhtml" -> 1;
            case "plain" -> 2;
            case "rawplain" -> 3;
            default -> throw new IllegalArgumentException("Unsupported pattern '" + string + "': only plain, html, rawhtml or rawplain are supported");
        });
    }

    @Override
    public String toString(KString kString) {
        return kString != null ? kString.getPLAINString(null) : "null";
    }

    @Override
    public String toString(KString kString, String string, LocaleInfo localeInfo) throws IllegalArgumentException {
        block16: {
            if (string == null) break block16;
            switch (string.toLowerCase()) {
                case "html": {
                    return kString.getHTMLString(DefaultInfoHolder.getKStringInfoProvider());
                }
                case "rawhtml": {
                    return kString.getRawHTMLString();
                }
                case "plain": {
                    return kString.getPLAINString(DefaultInfoHolder.getKStringInfoProvider());
                }
                case "rawplain": {
                    return kString.getRawPLAINString();
                }
            }
            throw new IllegalArgumentException("Unsupported pattern '" + string + "': only plain, html, rawhtml or rawplain are supported");
        }
        return kString.getHTMLString(DefaultInfoHolder.getKStringInfoProvider());
    }

    @Override
    public KString load(String string, Element element) throws Exception {
        Node node = element.getFirstChild();
        while (node != null) {
            if ("KString".equals(node.getNodeName()) && node instanceof Element) {
                return KString.createKString((Element)node);
            }
            node = node.getNextSibling();
        }
        throw new Exception("KString Element not found");
    }

    @Override
    public String save(KString kString, Element element) throws Exception {
        Element element2 = element.getOwnerDocument().createElement("KString");
        kString.toElement(element2);
        element.appendChild(element2);
        return null;
    }

    @Override
    public KString convert(Object object, Value.Type type, LocaleInfo localeInfo) throws KStringException {
        if (object instanceof KString) {
            return (KString)object;
        }
        String string = type != null ? type.valueObject.toStringForced(object) : String.valueOf(object);
        return KString.newPlainKString(string);
    }

    @Override
    public long asLong(KString kString, LocaleInfo localeInfo) {
        return Long.MIN_VALUE;
    }
}

