/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.util;

import com.iizix.Utilities;
import com.iizix.util.FileChangedChecker;
import com.iizix.util.XFile;
import com.iizix.util.XOutputFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class IniFile {
    private String a;
    private Vector<String> a;
    private boolean a;
    private FileChangedChecker a;
    private boolean b;
    private boolean c;
    private final Hashtable<String, Hashtable<String, String>> a = new Hashtable();

    public static IniFile createNewIniFile(String string) {
        IniFile iniFile = new IniFile(false);
        iniFile.a = string;
        return iniFile;
    }

    public static IniFile createNewIniFile(boolean bl, String string) {
        IniFile iniFile = new IniFile(bl);
        iniFile.a = string;
        return iniFile;
    }

    private IniFile(boolean bl) {
        this.b = bl;
        this.a = new Vector();
    }

    public IniFile(String string) throws IOException, FileNotFoundException {
        this(false, string, false);
    }

    public IniFile(boolean bl, String string) throws IOException, FileNotFoundException {
        this(bl, string, false);
    }

    public IniFile(String string, boolean bl) throws IOException, FileNotFoundException {
        this(false, string, bl);
    }

    public IniFile(boolean bl, String string, boolean bl2) throws IOException, FileNotFoundException {
        this.b = bl;
        this.a = string;
        if (bl2) {
            this.a = new Vector();
        }
        try (XFile xFile = null;){
            xFile = new XFile(string);
            this.a(xFile);
        }
    }

    public IniFile(XFile xFile) throws IOException {
        this(false, xFile, false);
    }

    public IniFile(boolean bl, XFile xFile) throws IOException {
        this(bl, xFile, false);
    }

    public IniFile(XFile xFile, boolean bl) throws IOException {
        this(false, xFile, bl);
    }

    public IniFile(boolean bl, XFile xFile, boolean bl2) throws IOException {
        this.b = bl;
        this.a = xFile.getFileName();
        if (this.a == null) {
            this.a = "PhantomFile";
        }
        if (bl2) {
            this.a = new Vector();
        }
        this.a(xFile);
    }

    public void setCreateUntitledSectionHeadings(boolean bl) {
        this.c = bl;
    }

    public boolean doCreateUntitledSectionHeadings() {
        return this.c;
    }

    public synchronized boolean needsReload() {
        if (this.a == null) {
            return false;
        }
        return this.a.hasChanged();
    }

    public synchronized boolean reload(boolean bl) throws IOException {
        try (XFile xFile = null;){
            if (bl || this.a.hasChanged()) {
                xFile = new XFile(this.a);
                if (this.a != null) {
                    ((Vector)((Object)this.a)).clear();
                }
                ((Hashtable)((Object)this.a)).clear();
                this.a(xFile);
                return true;
            }
            return false;
        }
    }

    private void a(XFile xFile) throws IOException {
        String string;
        Hashtable<String, String> hashtable = null;
        while ((string = IniFile.a(xFile)) != null) {
            String string2;
            String string3;
            int n2;
            string = string.trim();
            if (this.a != null) {
                ((Vector)((Object)this.a)).addElement(string);
            }
            if ((n2 = string.length()) == 0 || string.charAt(0) == ';') continue;
            if (string.charAt(0) == '[' && string.charAt(n2 - 1) == ']') {
                hashtable = new Hashtable<String, String>();
                String string4 = string.substring(1, n2 - 1);
                if (!this.b) {
                    string4 = string4.toUpperCase();
                }
                if (((Hashtable)((Object)this.a)).get(string4) != null) continue;
                ((Hashtable)((Object)this.a)).put(string4, hashtable);
                continue;
            }
            if (hashtable == null) continue;
            int n3 = string.indexOf(61);
            if (n3 == -1) {
                string3 = string;
                string2 = "";
            } else {
                string3 = string.substring(0, n3).trim().toUpperCase();
                string2 = string.substring(n3 + 1).replace('\t', ' ').trim();
            }
            if (hashtable.get(string3) != null) continue;
            hashtable.put(string3, string2);
        }
        this.a = new FileChangedChecker(this.a);
    }

    public synchronized String getFileName() {
        return this.a;
    }

    public synchronized Enumeration<String> getSections() {
        return ((Hashtable)((Object)this.a)).keys();
    }

    public synchronized Enumeration<String> getItems(String string) {
        Hashtable hashtable = (Hashtable)((Hashtable)((Object)this.a)).get(string.toUpperCase());
        if (hashtable == null) {
            return null;
        }
        return hashtable.keys();
    }

    public synchronized HashMap<String, String> getSectionItems(String string) {
        Hashtable hashtable;
        if (!this.b) {
            string = string.toUpperCase();
        }
        if ((hashtable = (Hashtable)((Hashtable)((Object)this.a)).get(string)) == null) {
            return null;
        }
        return new HashMap<String, String>(hashtable);
    }

    public synchronized int getSize(String string) {
        Hashtable hashtable;
        if (!this.b) {
            string = string.toUpperCase();
        }
        if ((hashtable = (Hashtable)((Hashtable)((Object)this.a)).get(string)) == null) {
            return 0;
        }
        return hashtable.size();
    }

    public synchronized String getData(String string, String string2) {
        Hashtable hashtable;
        if (!this.b) {
            string = string.toUpperCase();
        }
        if ((hashtable = (Hashtable)((Hashtable)((Object)this.a)).get(string)) == null) {
            return null;
        }
        return (String)hashtable.get(string2.toUpperCase());
    }

    public String getData(String string, String string2, String string3) {
        String string4 = this.getData(string, string2);
        if (string4 == null) {
            string4 = string3;
        }
        return string4;
    }

    public int getData(String string, String string2, int n2) {
        String string3 = this.getData(string, string2);
        if (string3 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public boolean getData(String string, String string2, boolean bl) {
        String string3 = this.getData(string, string2, "");
        if (string3.equals("1")) {
            return true;
        }
        if (string3.equals("0")) {
            return false;
        }
        return bl;
    }

    public void setItem(String string, String string2, int n2) {
        this.setItem(string, string2, Integer.toString(n2), null);
    }

    public void setItem(String string, String string2, boolean bl) {
        this.setItem(string, string2, bl ? "1" : "0", null);
    }

    public void setItem(String string, String string2, String string3) {
        this.setItem(string, string2, string3, null);
    }

    public synchronized void setItem(String string, String string2, String string3, String string4) {
        String string5 = string3 == null ? "" : string3;
        String string6 = this.getData(string, string2);
        if (string6 != null && string6.equals(string5)) {
            return;
        }
        String string7 = string;
        if (!this.b) {
            string7 = string7.toUpperCase();
        }
        String string8 = string2.toUpperCase();
        Hashtable<String, String> hashtable = (Hashtable<String, String>)((Hashtable)((Object)this.a)).get(string7);
        if (hashtable == null) {
            if (string4 != null || this.c) {
                String string9 = "; ************************************************************************";
                String string10 = "; *";
                if (((Vector)((Object)this.a)).size() > 0) {
                    ((Vector)((Object)this.a)).addElement("");
                }
                ((Vector)((Object)this.a)).addElement(string9);
                ((Vector)((Object)this.a)).addElement(string10);
                ((Vector)((Object)this.a)).addElement("; *  " + (string4 != null ? string4 : "<UNTITLED SECTION>"));
                ((Vector)((Object)this.a)).addElement(string10);
                ((Vector)((Object)this.a)).addElement(string9);
            }
            if (((Vector)((Object)this.a)).size() > 0 && !((String)((Vector)((Object)this.a)).lastElement()).isEmpty()) {
                ((Vector)((Object)this.a)).addElement("");
            }
            ((Vector)((Object)this.a)).addElement("[" + string + "]");
            ((Vector)((Object)this.a)).addElement(string3 == null ? string2 : string2 + "=" + string3);
            hashtable = new Hashtable<String, String>();
            ((Hashtable)((Object)this.a)).put(string7, hashtable);
            hashtable.put(string3 == null ? string2 : string8, string5);
            this.a = true;
            return;
        }
        try {
            String string11;
            int n2;
            int n3 = 0;
            while (true) {
                String string12;
                if ((n2 = (string12 = (String)((Vector)((Object)this.a)).elementAt(n3)).length()) > 2 && string12.charAt(0) == '[' && string12.charAt(n2 - 1) == ']') {
                    string11 = string12.substring(1, n2 - 1);
                    if (!this.b) {
                        string11 = string11.toUpperCase();
                    }
                    if (string11.equals(string7)) break;
                }
                ++n3;
            }
            int n4 = ((Vector)((Object)this.a)).size();
            if (hashtable.get(string8) == null) {
                String string13;
                n2 = n3 + 1;
                int n5 = n3 + 1;
                while (n5 < n4) {
                    String string14 = (String)((Vector)((Object)this.a)).elementAt(n5);
                    int n6 = string14.length();
                    if (n6 > 2 && string14.charAt(0) == '[' && string14.charAt(n6 - 1) == ']') break;
                    if (string14.trim().length() > 0 && string14.charAt(0) != ';') {
                        n2 = n5 + 1;
                    }
                    ++n5;
                }
                String string15 = string13 = string3 == null ? string2 : string2 + "=" + string3;
                if (n2 >= n4) {
                    ((Vector)((Object)this.a)).addElement(string13);
                } else {
                    ((Vector)((Object)this.a)).insertElementAt(string13, n2);
                }
                hashtable.put(string8, string5);
                this.a = true;
                return;
            }
            n2 = n3 + 1;
            while (true) {
                String string16;
                int n7;
                if ((n7 = (string11 = (String)((Vector)((Object)this.a)).elementAt(n2)).length()) > 2 && string11.charAt(0) == '[' && string11.charAt(n7 - 1) == ']') {
                    throw new InternalError("IniFile: Cannot find section " + string + " and item " + string2 + " in file " + this.a);
                }
                int n8 = string11.indexOf(61);
                String string17 = string16 = n8 == -1 ? string11 : string11.substring(0, n8).trim();
                if (string16.toUpperCase().equals(string8)) {
                    ((Vector)((Object)this.a)).setElementAt(string16 + "=" + string5, n2);
                    hashtable.put(string8, string5);
                    this.a = true;
                    return;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InternalError("Can't find section \"" + string + "\" or item \"" + string2 + "\" in the INI file");
        }
    }

    public void setItems(String string, String[] stringArray) {
        this.setItems(string, stringArray, null);
    }

    public synchronized void setItems(String string, String[] stringArray, String string2) {
        Hashtable<String, String> hashtable;
        String string3 = "; ************************************************************************";
        String string4 = "; *";
        String string5 = string;
        if (!this.b) {
            string5 = string5.toUpperCase();
        }
        if ((hashtable = (Hashtable<String, String>)((Hashtable)((Object)this.a)).get(string5)) == null) {
            ((Vector)((Object)this.a)).addElement("");
            ((Vector)((Object)this.a)).addElement(string3);
            ((Vector)((Object)this.a)).addElement(string4);
            ((Vector)((Object)this.a)).addElement("; *  " + (string2 != null ? string2 : "<UNTITLED SECTION>"));
            ((Vector)((Object)this.a)).addElement(string4);
            ((Vector)((Object)this.a)).addElement(string3);
            ((Vector)((Object)this.a)).addElement("");
            ((Vector)((Object)this.a)).addElement("[" + string + "]");
            hashtable = new Hashtable<String, String>();
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string6 = stringArray[n2];
                hashtable.put(string6.toUpperCase(), "");
                ((Vector)((Object)this.a)).addElement(string6);
                ++n2;
            }
            ((Hashtable)((Object)this.a)).put(string5, hashtable);
            this.a = true;
            return;
        }
        try {
            String string7;
            int n3;
            int n4 = 0;
            while (true) {
                String string8;
                if ((n3 = (string8 = (String)((Vector)((Object)this.a)).elementAt(n4)).length()) > 2 && string8.charAt(0) == '[' && string8.charAt(n3 - 1) == ']') {
                    String string9 = string8.substring(1, n3 - 1);
                    if (!this.b) {
                        string9 = string9.toUpperCase();
                    }
                    if (string9.equals(string5)) break;
                }
                ++n4;
            }
            int n5 = ((Vector)((Object)this.a)).size();
            n3 = n4 + 1;
            int n6 = n4 + 1;
            while (n6 < n5) {
                string7 = (String)((Vector)((Object)this.a)).elementAt(n6);
                int n7 = string7.length();
                if (n7 > 2 && string7.charAt(0) == '[' && string7.charAt(n7 - 1) == ']') break;
                if (string7.trim().length() > 0 && string7.charAt(0) != ';') {
                    n3 = n6 + 1;
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < stringArray.length) {
                string7 = stringArray[n6];
                if (n3 >= n5) {
                    ((Vector)((Object)this.a)).addElement(string7);
                } else {
                    ((Vector)((Object)this.a)).insertElementAt(string7, n3);
                }
                hashtable.put(string7.toUpperCase(), "");
                this.a = true;
                ++n6;
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InternalError("Can't find section \"" + string + "\" in the INI file");
        }
    }

    public void setItems(String string, Hashtable<String, String> hashtable) {
        this.setItems(string, hashtable, null);
    }

    public void setItems(String string, Hashtable<String, String> hashtable, String string2) {
        this.setItems(string, hashtable.entrySet(), string2);
    }

    public void setItems(String string, HashMap<String, String> hashMap) {
        this.setItems(string, hashMap.entrySet(), null);
    }

    public void setItems(String string, HashMap<String, String> hashMap, String string2) {
        this.setItems(string, hashMap.entrySet(), string2);
    }

    public void setItems(String string, Set<Map.Entry<String, String>> set) {
        this.setItems(string, set, null);
    }

    public synchronized void setItems(String string, Set<Map.Entry<String, String>> set, String string2) {
        for (Map.Entry<String, String> entry : set) {
            this.setItem(string, entry.getKey(), entry.getValue(), string2);
        }
    }

    public synchronized void removeAllItems(String string) {
        Hashtable hashtable;
        String string2 = string;
        if (!this.b) {
            string2 = string2.toUpperCase();
        }
        if ((hashtable = (Hashtable)((Hashtable)((Object)this.a)).get(string2)) == null) {
            return;
        }
        if (hashtable.size() == 0) {
            return;
        }
        try {
            String string3;
            int n2;
            int n3 = 0;
            while (true) {
                String string4;
                if ((n2 = (string4 = (String)((Vector)((Object)this.a)).elementAt(n3)).length()) > 2 && string4.charAt(0) == '[' && string4.charAt(n2 - 1) == ']') {
                    string3 = string4.substring(1, n2 - 1);
                    if (!this.b) {
                        string3 = string3.toUpperCase();
                    }
                    if (string3.equals(string2)) break;
                }
                ++n3;
            }
            hashtable = new Hashtable();
            ((Hashtable)((Object)this.a)).put(string2, hashtable);
            int n4 = ((Vector)((Object)this.a)).size();
            n2 = n3 + 1;
            while (n2 < n4) {
                string3 = (String)((Vector)((Object)this.a)).elementAt(n2);
                int n5 = string3.length();
                if (n5 <= 2 || string3.charAt(0) != '[' || string3.charAt(n5 - 1) != ']') {
                    if (n5 > 0 && string3.charAt(0) != ';') {
                        ((Vector)((Object)this.a)).removeElementAt(n2);
                        this.a = true;
                        continue;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public boolean deleteSection(String string) {
        return this.renameSection(string, null);
    }

    public synchronized boolean renameSection(String string, String string2) {
        int n2;
        Hashtable hashtable;
        String string3;
        block9: {
            string3 = string;
            if (!this.b) {
                string3 = string3.toUpperCase();
            }
            if ((hashtable = (Hashtable)((Hashtable)((Object)this.a)).get(string3)) == null) {
                return false;
            }
            try {
                n2 = 0;
                String string4 = null;
                while (true) {
                    int n3;
                    if ((n3 = (string4 = (String)((Vector)((Object)this.a)).elementAt(n2)).length()) > 2 && string4.charAt(0) == '[' && string4.charAt(n3 - 1) == ']') {
                        String string5 = string4.substring(1, n3 - 1);
                        if (!this.b) {
                            string5 = string5.toUpperCase();
                        }
                        if (string5.equals(string3)) break;
                    }
                    ++n2;
                }
                if (string2 != null) break block9;
                this.removeAllItems(string3);
                ((Hashtable)((Object)this.a)).remove(string3);
                ((Vector)((Object)this.a)).remove(n2);
                this.a = true;
                return true;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new InternalError("Can't find section \"" + String.valueOf(hashtable) + "\" in the INI file");
            }
        }
        ((Vector)((Object)this.a)).setElementAt("[" + string2 + "]", n2);
        ((Hashtable)((Object)this.a)).remove(string3);
        if (!this.b) {
            string2 = string2.toUpperCase();
        }
        ((Hashtable)((Object)this.a)).put(string2, hashtable);
        return true;
    }

    public synchronized boolean hasChanged() {
        return this.a;
    }

    public void saveFile() throws IOException {
        if (!this.a) {
            return;
        }
        XOutputFile xOutputFile = null;
        try {
            xOutputFile = new XOutputFile(this.a);
            this.save2(xOutputFile);
            xOutputFile.close();
            xOutputFile = null;
        }
        finally {
            if (xOutputFile != null) {
                try {
                    xOutputFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void save2(XOutputFile xOutputFile) throws IOException {
        Iterator iterator = ((Vector)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            xOutputFile.writeISOLine(string);
        }
        this.a = false;
    }

    public synchronized void save(OutputStream outputStream) throws IOException {
        Iterator iterator = ((Vector)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            outputStream.write(Utilities.getBytes(string));
            outputStream.write(XOutputFile.isoNewLine);
        }
        this.a = false;
    }

    private static String a(XFile xFile) throws IOException {
        Object object = xFile.readISOLine();
        if (object != null) {
            while (((String)(object = ((String)object).trim())).endsWith("\\")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
                String string = xFile.readISOLine();
                if (string == null) break;
                object = (String)object + string;
            }
        }
        return object;
    }
}

