/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.user;

import com.iizix.Utilities;
import com.iizix.gyro.IAppSessionGyro;
import com.iizix.text.IEnumLocaleString;
import com.iizix.text.KString;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public enum SigninResult implements IEnumLocaleString
{
    SUCCESS(true, false, "Success.", "userauth.success"),
    SUCCESS_NOT_SIGNED_IN(true, false, "Success, but you need to Sign In to proceed.", "userauth.success_not_signed_in"),
    SUCCESS_CHANGE_PASSWORD(true, true, "Success, change of password needed.", "userauth.success.change_password"),
    INVALID_PASSWORD(false, false, "Invalid password.", "userauth.invalid_password"),
    TOO_MANY_INVALID_LOGINS_RETRY_LATER(false, false, "Too many invalid logins. Please retry later.", "userauth.too_many_invalid_logins_retry_later"),
    TOO_MANY_INVALID_LOGINS_RETRY_LATER_NEXT_TIME_DISABLE(false, false, "Too many invalid logins. Please retry later. Upon next failure, your user will be disabled.", "userauth.too_many_invalid_logins_retry_later_next_time_disable"),
    INVALID_PASSWORD_NEXT_ATTEMPT_WILL_DISABLE(false, false, "Invalid password. Upon next failure, your user will be disabled.", "userauth.invalid_password_next_attempt_will_disable"),
    USER_DISABLED(false, false, "Your user has been disabled, please contact your app supplier.", "userauth.disabled"),
    INVALID_USER(false, false, "Invalid user name.", "userauth.invalid_user"),
    INVALID_USER_OR_PASSWORD(false, false, "Invalid user name or password.", "userauth.invalid_user_or_password"),
    USER_NAME_TAKEN(false, false, "User name taken, cannot sign up.", "userauth.user_name_taken"),
    APP_ID_NOT_FOUND(false, false, "Application ID is not found.", "userauth.app_id_not_found"),
    APP_DISABLED(false, false, "The application is disabled.", "userauth.app_disabled"),
    SERVER_NOT_STARTED(false, false, "Server not started.", "userauth.server_not_started"),
    SERVER_STARTING(false, false, "Server is starting up.", "userauth.server_starting"),
    SERVER_STOPPING(false, false, "Server is stopping.", "userauth.server_stopping"),
    SERVER_STOPPED(false, false, "Server is stopping.", "userauth.server_stopped"),
    SERVER_LOGIN_DISABLED(false, false, "Login to server is currently disabled.", "userauth.server_login_disabled"),
    SYSTEM_FAILURE(false, false, "A system failure occurred when authentication your user.", "userauth.system_failure");

    private final boolean a;
    private final boolean b;
    public final String englishMessage;
    public final String textID;

    private SigninResult(boolean bl, boolean bl2, String string2, String string3) {
        this.a = bl;
        this.b = bl2;
        this.englishMessage = string2;
        this.textID = string3;
    }

    public boolean isSuccessful() {
        return this.a;
    }

    public boolean mustChangePassword() {
        return this.b;
    }

    @Override
    public String getID() {
        return this.textID;
    }

    @Override
    public String getFallback() {
        return this.englishMessage;
    }

    public String getText(IAppSessionGyro iAppSessionGyro) {
        KString kString = iAppSessionGyro.getLocaleKString(this.textID);
        return kString != null ? kString.getPLAINString(iAppSessionGyro.getAppKStringInfoProvider()) : this.englishMessage;
    }

    public String formatText(IAppSessionGyro iAppSessionGyro, Object ... objectArray) {
        KString kString = iAppSessionGyro.getLocaleKString(this.textID);
        String string = kString != null ? kString.getPLAINString(iAppSessionGyro.getAppKStringInfoProvider()) : this.englishMessage;
        return Utilities.format(iAppSessionGyro.getLocale(), string, objectArray);
    }
}

