/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.font;

import com.iizix.SendTransaction;
import com.iizix.event.GEvent;
import com.iizix.gyro.IClientSessionGyro;
import com.iizix.prop.Atom;
import com.iizix.prop.EnvProps;
import com.iizix.prop.IClientCachePreload;
import com.iizix.prop.IClientCacheResource;
import com.iizix.prop.PreloadClientCacheResource;
import com.iizix.prop.PropCnr;
import com.iizix.prop.font.BrowserFontFormat;
import com.iizix.prop.font.FontFile;
import com.iizix.prop.font.FontFormat;
import java.util.HashSet;
import ua_parser.Client;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FontFiles
extends PropCnr
implements IClientCachePreload,
IClientCacheResource {
    public static final String UNDEFINED = "undefined";
    public static final String LOCAL = "local";
    public static final String ADDITIONAL = "add";
    public static final String FONT_FACE_CSS = "$fontFace";
    public static final String[] STYLES = new String[]{"normal", "italic", "oblique"};
    public static final int STYLE_DEFAULT = 0;
    public static final String[] WEIGHTS = new String[]{"100", "200", "300", "400", "500", "600", "700", "800", "900", "950"};
    public static final String[] WEIGHTS_DESCR = new String[]{"100 - Thin (Hairline)", "200 - Extralight (Ultralight)", "300 - Light", "400 - Normal", "500 - Medium", "600 - Semibold (Demibold)", "700 - Bold", "800 - Extrabold (Ultrabold)", "900 - Black (Heavy)", "950 - Extrablack (Ultrablack)"};
    public static final int WEIGHT_DEFAULT = 3;
    public static final int WEIGHT_BOLD = 6;
    public static final String[] STANDARD_FONTS = new String[]{"Courier", "Courier New", "monospace", "serif", "times", "times-roman", "Times New Roman", "roman", "sans", "sans-serif", "Arial", "Helvetica", "HelveticaNeue", "-apple-system", "Open Sans", "FontAwesome"};
    private static final HashSet<String> a = new HashSet(STANDARD_FONTS.length);
    private FontFile[] a;
    private FontFile[] b;

    static {
        String[] stringArray = STANDARD_FONTS;
        int n2 = STANDARD_FONTS.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray[n3];
            string = string.toLowerCase();
            a.add(string);
            if (string.indexOf(32) > 0) {
                a.add("\"" + string + "\"");
                a.add("'" + string + "'");
            }
            ++n3;
        }
    }

    public static boolean isStandardFontFamily(String string) {
        return a.contains(string.toLowerCase());
    }

    public FontFiles() {
    }

    public FontFiles(Atom atom) {
        super(atom);
    }

    @Override
    protected boolean isPropPrivateAtCreation() {
        return true;
    }

    @Override
    public boolean usesPropIndex() {
        return true;
    }

    @Override
    public void onEventSelf(GEvent gEvent) {
        if (gEvent.isClearCacheEvent()) {
            this.a = null;
            this.b = null;
        }
        super.onEventSelf(gEvent);
    }

    @Override
    public FontFiles clone() {
        try {
            FontFiles fontFiles = (FontFiles)super.clone();
            fontFiles.a = null;
            fontFiles.b = null;
            return fontFiles;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public FontFile[] getFontFiles() {
        FontFile[] fontFileArray = this.a;
        if (fontFileArray == null) {
            this.a = this.getProps(FontFile.class);
            fontFileArray = this.a;
        }
        return fontFileArray;
    }

    public FontFile getFontFile(EnvProps envProps) {
        BrowserFontFormat browserFontFormat;
        try {
            Client client = envProps.getParsedUserAgent();
            browserFontFormat = BrowserFontFormat.fromParsedUserAgent(client);
        }
        catch (Exception exception) {
            System.err.println("Failed getting parsed user agent: " + exception.getMessage());
            browserFontFormat = BrowserFontFormat.OTHER;
        }
        return this.getFontFile(browserFontFormat);
    }

    public FontFile getFontFile(BrowserFontFormat browserFontFormat) {
        FontFile[] fontFileArray = this.b;
        if (fontFileArray == null) {
            fontFileArray = new FontFile[FontFormat.FORMATS.length];
            FontFile[] fontFileArray2 = this.getFontFiles();
            int n2 = fontFileArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object;
                fontFileArray[((FontFile)object).getFormat().ordinal()] = object = fontFileArray2[n3];
                ++n3;
            }
            this.b = fontFileArray;
        }
        for (Object object : browserFontFormat.formats) {
            FontFile fontFile = fontFileArray[object.ordinal()];
            if (fontFile == null) continue;
            return fontFile;
        }
        return null;
    }

    public int getCacheOperation() {
        return this.getInt(Atom.CACHE, 1);
    }

    @Override
    public boolean isCachedOnClient() {
        return this.getCacheOperation() > 0;
    }

    @Override
    public boolean isCachePreloaded() {
        return this.getCacheOperation() == 2;
    }

    @Override
    public PreloadClientCacheResource[] getPreloadClientCacheResources(IClientSessionGyro iClientSessionGyro) {
        FontFile fontFile;
        if (this.isCachePreloaded() && (fontFile = this.getFontFile(iClientSessionGyro.getEnvironment())) != null) {
            return fontFile.getPreloadClientCacheResources();
        }
        return PreloadClientCacheResource.EMPTY;
    }

    public String getFontFamily() {
        String string = this.getString(Atom.NAME);
        return string != null && !string.isEmpty() ? string : UNDEFINED;
    }

    public String getFontIdentification() {
        return this.getFontFamily() + ':' + this.getFontWeight() + ':' + this.getFontStyle();
    }

    public String getLocalNames() {
        return this.getString(LOCAL);
    }

    public String getFontFaceBaseDeclaration() {
        StringBuilder stringBuilder = new StringBuilder().append("font-style:").append(this.getFontStyle()).append(";font-weight:").append(this.getFontWeight()).append(';');
        String string = this.getString(Atom.RANGE);
        if (string != null && !string.isEmpty() && !string.equalsIgnoreCase("U+0-10FFFF")) {
            stringBuilder.append("unicode-range:").append(string).append(';');
        }
        if ((string = this.getString(ADDITIONAL)) != null && !string.isEmpty()) {
            string = string.trim();
            stringBuilder.append(string);
            if (!string.endsWith(";")) {
                stringBuilder.append(';');
            }
        }
        return stringBuilder.toString();
    }

    public String getFontStyle() {
        return STYLES[this.getFontStyleIndex()];
    }

    public int getFontStyleIndex() {
        int n2 = this.getInt(Atom.STYLE, 0);
        return n2 >= 0 && n2 < STYLES.length ? n2 : 0;
    }

    public String getFontWeight() {
        return WEIGHTS[this.getFontWeightIndex()];
    }

    public String getDescriptiveFontWeight() {
        return WEIGHTS_DESCR[this.getFontWeightIndex()];
    }

    public int getFontWeightIndex() {
        int n2 = this.getInt(Atom.WEIGHT, 3);
        return n2 >= 0 && n2 < WEIGHTS.length ? n2 : 3;
    }

    boolean a(SendTransaction sendTransaction) {
        int n2 = this.getCacheOperation();
        sendTransaction.appendByte(0);
        sendTransaction.appendByte(n2);
        sendTransaction.appendString(this.getFontFamily());
        String string = this.getString(LOCAL);
        sendTransaction.appendString(string != null ? string : "");
        sendTransaction.appendString(this.getFontFaceBaseDeclaration().toString());
        return n2 != 0;
    }
}

