/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.Utilities;
import com.iizix.event.PropValueEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class StringMapProp
extends GProp<Map<String, String>> {
    private static final Class<?>[] a = new Class[]{LinkedHashMap.class, Map.class, Hashtable.class};
    private LinkedHashMap<String, String> a;
    private Map<String, String> a = Collections.synchronizedMap(this.a);

    protected StringMapProp() {
        this.setPropValueIncognito(this.a);
    }

    public StringMapProp(Atom atom) {
        super(atom);
        this.setPropValueIncognito(this.a);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    @Override
    public StringMapProp clone() {
        try {
            StringMapProp stringMapProp = (StringMapProp)super.clone();
            stringMapProp.a = (LinkedHashMap)stringMapProp.a.clone();
            stringMapProp.a = Collections.synchronizedMap(stringMapProp.a);
            stringMapProp.setPropValueIncognito(stringMapProp.a);
            return stringMapProp;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof Map)) {
            throw new PropTypeException(this, "Not a Map<?,?>");
        }
        for (Map.Entry entry : ((Map)object).entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            throw new PropTypeException(this, "Not a Map<String,String>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int modifyPropValue(Object object, Object object2, PropMgr propMgr) throws PropException {
        try {
            Map map = (Map)object2;
            Class<?>[] classArray = this.a;
            synchronized (this.a) {
                if (this.equalValues((GProp<?>)this, (Map<String, String>)this.a, map, 0) == null) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return 0;
                }
                this.a.clear();
                this.a.putAll(map);
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return 2;
            }
        }
        catch (Throwable throwable) {
            throw new PropException(this, "modifyPropertyValue error: " + String.valueOf(throwable), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object equalValues(GProp<?> gProp, Map<String, String> map, Map<String, String> map2, int n2) {
        if (map == null && map2 == null) {
            return null;
        }
        if (map == null || map2 == null) return this;
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            int n3 = this.a.size();
            if (n3 != map2.size()) return this;
            try {
                Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
                Iterator iterator2 = this.a.entrySet().iterator();
                while (--n3 >= 0) {
                    if (iterator.next().equals(iterator2.next())) continue;
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return this;
                }
                if (!iterator.hasNext() && !iterator2.hasNext()) return null;
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return this;
            }
            catch (Exception exception) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return this;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            sendTransaction.appendUnsigned(this.a.size());
            for (Map.Entry entry : this.a.entrySet()) {
                sendTransaction.appendString((String)entry.getKey());
                sendTransaction.appendString((String)entry.getValue());
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) {
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            int n2 = readTransaction.readUnsigned();
            boolean bl = this.a.size() != n2 || n2 > 0;
            this.a.clear();
            while (n2-- > 0) {
                this.a.put(readTransaction.readString(), readTransaction.readString());
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bl;
        }
    }

    @Override
    public void initializeProp(Element element) throws PropException {
        this.throwIfReadOnly();
        boolean bl = this.a.size() > 0;
        this.a.clear();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element && node.getNodeName().equals("entry")) {
                Attr attr;
                Element element2 = (Element)node;
                String string = null;
                String string2 = null;
                Attr attr2 = element2.getAttributeNode("key");
                if (attr2 != null) {
                    string = attr2.getNodeValue();
                }
                if ((attr = element2.getAttributeNode("value")) != null) {
                    string2 = attr.getNodeValue();
                }
                if (string == null || string2 == null) {
                    throw new PropException(this, "<entry> doesn't specify 'key' and 'value' attributes");
                }
                this.a.put(string, string2);
                bl = true;
            }
            node = node.getNextSibling();
        }
        if (bl) {
            this.setChanged();
            this.d();
        }
    }

    @Override
    protected void initializeElement(Element element) {
        while (element.hasChildNodes()) {
            element.removeChild(element.getLastChild());
        }
        Document document = element.getOwnerDocument();
        for (Map.Entry entry : this.a.entrySet()) {
            Element element2 = document.createElement("entry");
            element2.setAttribute("key", (String)entry.getKey());
            element2.setAttribute("value", (String)entry.getValue());
            element.appendChild(element2);
        }
    }

    private void d() {
        this.onEvent(new PropValueEvent(this, this.a, this.a));
    }

    public String put(String string, String string2) throws PropTypeException {
        if (string == null || string2 == null) {
            throw new NullPointerException("String=null");
        }
        this.throwIfReadOnly();
        String string3 = this.a.put(string, string2);
        this.setChanged();
        this.d();
        return string3;
    }

    public int size() {
        return this.a.size();
    }

    public boolean clear() throws PropTypeException {
        if (this.a.isEmpty()) {
            return false;
        }
        this.throwIfReadOnly();
        this.a.clear();
        this.setChanged();
        this.d();
        return true;
    }

    public String removeKey(String string) throws PropTypeException {
        this.throwIfReadOnly();
        String string2 = (String)this.a.remove(string);
        if (string2 != null) {
            this.setChanged();
            this.d();
        }
        return string2;
    }

    public String getValue(String string) {
        return (String)this.a.get(string);
    }

    public Map<String, String> getHashMap() {
        return this.isPropReadOnly() ? Collections.unmodifiableMap(this.a) : this.a;
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return object;
            }
            case 2: {
                LinkedHashMap linkedHashMap = (LinkedHashMap)object;
                Hashtable<String, String> hashtable = new Hashtable<String, String>(linkedHashMap.size());
                for (Map.Entry entry : linkedHashMap.entrySet()) {
                    hashtable.put((String)entry.getKey(), (String)entry.getValue());
                }
                return hashtable;
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        switch (n2) {
            case 1: {
                return object;
            }
            case 2: {
                return object;
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSystemProperties() throws PropException {
        this.throwIfReadOnly();
        boolean bl = false;
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            String string;
            String string2;
            try {
                for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
                    if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                    string2 = (String)entry.getValue();
                    string = this.a.put((String)entry.getKey(), string2);
                    if (bl) continue;
                    boolean bl2 = bl = !string2.equals(string);
                }
            }
            catch (SecurityException securityException) {
                ILog.WARNING(this.getClass(), "System properties cannot be retrived due to security restrictions", securityException);
            }
            try {
                for (Map.Entry<Object, Object> entry : System.getenv().entrySet()) {
                    string2 = (String)entry.getValue();
                    string = this.a.put((String)entry.getKey(), string2);
                    if (bl) continue;
                    boolean bl3 = bl = !string2.equals(string);
                }
            }
            catch (SecurityException securityException) {
                ILog.WARNING(this.getClass(), "System environment cannot be retrived due to security restrictions", securityException);
            }
            if (bl) {
                this.setChanged();
                this.d();
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStringMapAsStringArray(String string) {
        Class<?>[] classArray = this.a;
        synchronized (this.a) {
            int n2 = this.a.size();
            String[] stringArray = new String[n2];
            for (Map.Entry entry : this.a.entrySet()) {
                stringArray[--n2] = (String)entry.getKey() + string + (String)entry.getValue();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            Arrays.sort(stringArray, Utilities.COLLATOR);
            return stringArray;
        }
    }
}

