/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.event.GEvent;
import com.iizix.prop.Atom;
import com.iizix.prop.PlainKStringProp;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.text.IKStringInfoProvider;
import com.iizix.text.KString;
import com.iizix.text.PlainKString;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class PWAProps
extends PropCnr {
    public static final String FILE_NAME = ".iiziPWA";
    public static final Atom ATOM = Atom.get("$pwa");
    public static final String LOCALIZED_LANGUAGES_PROPNAME = "localized";
    public static final String APP_NAME_PROPNAME = "name";
    public static final Atom APP_DESCR_ATOM = Atom.DESCR;
    public static final String SCRIPT_TAG = "scriptTag";
    public static final String UNKNOWN = "UNKNOWN";
    private static final Pattern a = Pattern.compile("import\\s+\\{\\s*([^}]+)\\s*\\}\\s+from\\s+\"([^\"]+)\";");
    private static final Pattern b = Pattern.compile("https://www\\.gstatic\\.com/firebasejs/([0-9]+\\.[0-9]+\\.[0-9]+)/.*\\.js");
    private static final Pattern c = Pattern.compile("(?:(?:const|var|let)\\s+)?firebaseConfig\\s*=\\s*(\\{[\\s\\S]*?\\});");
    private FirebaseScriptTag a;

    public PWAProps() {
    }

    public PWAProps(Atom atom) {
        super(atom);
    }

    @Override
    public void onEventSelf(GEvent gEvent) {
        if (gEvent.isClearCacheEvent()) {
            this.a = null;
        }
        super.onEventSelf(gEvent);
    }

    @Override
    public PWAProps clone() {
        try {
            PWAProps pWAProps = (PWAProps)super.clone();
            pWAProps.a = null;
            return pWAProps;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    public String getLocalizedLanguages() {
        return this.getString(LOCALIZED_LANGUAGES_PROPNAME);
    }

    public PlainKString getName() {
        PlainKStringProp plainKStringProp = this.getProp(APP_NAME_PROPNAME, PlainKStringProp.class);
        return plainKStringProp != null ? plainKStringProp.getPlainKString() : null;
    }

    public PlainKString getDescription() {
        PlainKStringProp plainKStringProp = this.getProp(APP_DESCR_ATOM, PlainKStringProp.class);
        return plainKStringProp != null ? plainKStringProp.getPlainKString() : null;
    }

    public String getScriptTag() {
        KString kString;
        PlainKStringProp plainKStringProp = this.getProp(SCRIPT_TAG, PlainKStringProp.class);
        if (plainKStringProp != null && (kString = plainKStringProp.getKString()) != null) {
            return kString.getRawString();
        }
        return null;
    }

    private static FirebaseScriptTag a(String string) throws IllegalArgumentException {
        String string2;
        Object object;
        String string3;
        Object object2;
        ArrayList<JavaScriptImport> arrayList = new ArrayList<JavaScriptImport>();
        Matcher matcher = a.matcher(string);
        while (matcher.find()) {
            object2 = matcher.group(1);
            string3 = matcher.group(2);
            object = b.matcher(string3);
            if (!((Matcher)object).find()) {
                throw new IllegalArgumentException("Version number not found for imported URL \"" + string3 + "\" for functions \"" + (String)object2 + "\"");
            }
            string2 = ((Matcher)object).group();
            arrayList.add(new JavaScriptImport((String)object2, string3, string2));
        }
        object2 = c.matcher(string);
        if (!((Matcher)object2).find()) {
            throw new IllegalArgumentException("The \"firebaseConfig\" Objects is not found");
        }
        string3 = ((Matcher)object2).group(1);
        object = "Failed parsing the \"firebaseConfig\" configuration Object in JSON";
        string2 = null;
        try {
            JSONObject jSONObject = new JSONObject(string3);
            string2 = "apiKey";
            String string4 = jSONObject.getString("apiKey");
            string2 = "authDomain";
            String string5 = jSONObject.getString("authDomain");
            string2 = "projectId";
            String string6 = jSONObject.getString("projectId");
            string2 = "storageBucket";
            String string7 = jSONObject.getString("storageBucket");
            string2 = "messagingSenderId";
            String string8 = jSONObject.getString("messagingSenderId");
            string2 = "appId";
            String string9 = jSONObject.getString("appId");
            string2 = "measurementId";
            String string10 = jSONObject.optString("measurementId", null);
            FirebaseConfig firebaseConfig = new FirebaseConfig(string4, string5, string6, string7, string8, string9, string10);
            int n2 = arrayList.size();
            if (n2 < 2) {
                throw new IllegalArgumentException("Less than 2 imports found: " + n2);
            }
            return new FirebaseScriptTag(Collections.unmodifiableList(arrayList), firebaseConfig);
        }
        catch (JSONException jSONException) {
            if (string2 != null) {
                object = (String)object + ", parameter error \"" + string2 + "\"";
            }
            throw new IllegalArgumentException((String)object + ": " + jSONException.getMessage(), jSONException);
        }
    }

    public FirebaseScriptTag getFirebaseConfigScriptTag() {
        FirebaseScriptTag firebaseScriptTag = this.a;
        if (firebaseScriptTag != null) {
            return firebaseScriptTag;
        }
        String string = this.getScriptTag();
        if (string == null) {
            throw new IllegalArgumentException("Missing Firebase Configuration <script> tag");
        }
        this.a = PWAProps.a(string);
        return this.a;
    }

    @Override
    public boolean verify(PropVerification propVerification) {
        KString kString;
        if (!super.verify(propVerification)) {
            return false;
        }
        IKStringInfoProvider iKStringInfoProvider = propVerification.getKStringInfoProvider();
        PlainKStringProp plainKStringProp = this.getProp(APP_NAME_PROPNAME, PlainKStringProp.class);
        if (plainKStringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, APP_NAME_PROPNAME, PropVerificationError.Severity.WARNING, "Application name", "Application name must be specified", new String[0]));
        } else {
            kString = plainKStringProp.getKString();
            if (kString == null || kString.isEmpty() || kString.isEmptyBlankResolved(true, iKStringInfoProvider)) {
                propVerification.add(new PropVerificationError("empty", PropVerificationError.Severity.WARNING, "Application name", plainKStringProp, "Application name cannot be a HTML or blank string", new String[0]));
            }
        }
        plainKStringProp = this.getProp(APP_DESCR_ATOM, PlainKStringProp.class);
        if (plainKStringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, APP_DESCR_ATOM, PropVerificationError.Severity.WARNING, "Description", "Description must be specified", new String[0]));
        } else {
            kString = plainKStringProp.getKString();
            if (kString == null || kString.isEmpty() || kString.isEmptyBlankResolved(true, iKStringInfoProvider)) {
                propVerification.add(new PropVerificationError("empty", PropVerificationError.Severity.WARNING, "Description", plainKStringProp, "Description cannot be a HTML or blank string", new String[0]));
            }
        }
        plainKStringProp = this.getProp(SCRIPT_TAG, PlainKStringProp.class);
        if (plainKStringProp == null) {
            propVerification.add(new PropVerificationError((PropCnr)this, SCRIPT_TAG, PropVerificationError.Severity.WARNING, "Firebase <script> tag", "Firebase <script> tag must be specified", new String[0]));
        } else {
            kString = plainKStringProp.getKString();
            if (kString == null || kString.getRawString().isBlank()) {
                propVerification.add(new PropVerificationError("empty", PropVerificationError.Severity.WARNING, "Firebase <script> tag", plainKStringProp, "Firebase <script> tag cannot be a blank string", new String[0]));
            } else {
                try {
                    this.getFirebaseConfigScriptTag();
                }
                catch (Throwable throwable) {
                    propVerification.add(new PropVerificationError("empty", PropVerificationError.Severity.WARNING, "Firebase <script> tag", plainKStringProp, "Firebase <script> tag error: " + throwable.getMessage(), new String[0]));
                }
            }
        }
        return true;
    }

    public static final class FirebaseConfig
    extends Record {
        private final String a;
        private final String b;
        private final String c;
        private final String d;
        private final String e;
        private final String f;
        private final String g;

        public String apiKey() {
            return this.a;
        }

        public String authDomain() {
            return this.b;
        }

        public String projectId() {
            return this.c;
        }

        public String storageBucket() {
            return this.d;
        }

        public String messagingSenderId() {
            return this.e;
        }

        public String appId() {
            return this.f;
        }

        public String measurementId() {
            return this.g;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FirebaseConfig.class, "apiKey;authDomain;projectId;storageBucket;messagingSenderId;appId;measurementId", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FirebaseConfig.class, "apiKey;authDomain;projectId;storageBucket;messagingSenderId;appId;measurementId", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FirebaseConfig.class, "apiKey;authDomain;projectId;storageBucket;messagingSenderId;appId;measurementId", "a", "b", "c", "d", "e", "f", "g"}, this, object);
        }

        public FirebaseConfig(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.a = string;
            this.b = string2;
            this.c = string3;
            this.d = string4;
            this.e = string5;
            this.f = string6;
            this.g = string7;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class FirebaseScriptTag
    extends Record {
        private final List<JavaScriptImport> a;
        private final FirebaseConfig a;

        public List<JavaScriptImport> imports() {
            return this.a;
        }

        public FirebaseConfig config() {
            return this.a;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FirebaseScriptTag.class, "imports;config", "a", "a"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FirebaseScriptTag.class, "imports;config", "a", "a"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FirebaseScriptTag.class, "imports;config", "a", "a"}, this, object);
        }

        public FirebaseScriptTag(List<JavaScriptImport> list, FirebaseConfig firebaseConfig) {
            this.a = list;
            this.a = firebaseConfig;
        }
    }

    public static final class JavaScriptImport
    extends Record {
        private final String a;
        private final String b;
        private final String c;

        public String name() {
            return this.a;
        }

        public String url() {
            return this.b;
        }

        public String version() {
            return this.c;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{JavaScriptImport.class, "name;url;version", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{JavaScriptImport.class, "name;url;version", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{JavaScriptImport.class, "name;url;version", "a", "b", "c"}, this, object);
        }

        public JavaScriptImport(String string, String string2, String string3) {
            this.a = string;
            this.b = string2;
            this.c = string3;
        }
    }
}

