/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import com.iizix.prop.Atom;
import com.iizix.prop.GProp;
import com.iizix.prop.PropException;
import com.iizix.prop.PropMgr;
import com.iizix.prop.PropTypeException;
import com.iizix.prop.PropValidateException;

public class Int32Prop
extends GProp<Integer> {
    private static final Class<?>[] a = new Class[]{Integer.class, Long.class, Short.class, Byte.class, Double.class, Float.class, String.class, Character.class};

    public Int32Prop() {
    }

    public Int32Prop(Atom atom) {
        super(atom);
    }

    public Int32Prop(Atom atom, int n2) throws PropValidateException {
        super(atom);
        this.setPropValue(n2);
    }

    @Override
    public Class<?>[] getValueClasses() {
        return a;
    }

    public boolean setPropValue(int n2) throws PropValidateException {
        try {
            return super.setPropValue(n2);
        }
        catch (PropException propException) {
            if (propException instanceof PropValidateException) {
                throw (PropValidateException)propException;
            }
            throw new InternalError(propException.getMessage());
        }
    }

    @Override
    public void validatePropType(Object object) throws PropTypeException {
        if (!(object instanceof Integer)) {
            throw new PropTypeException(this, "newValue not Integer");
        }
    }

    public int getInt() {
        return this.getInt(-1);
    }

    public int getInt(int n2) {
        Integer n3 = (Integer)this.getPropValue();
        return n3 == null ? n2 : n3;
    }

    @Override
    protected void appendPropValue(PropMgr propMgr, SendTransaction sendTransaction, Object object) {
        Integer n2 = (Integer)this.getPropValue();
        sendTransaction.appendLong(n2 == null ? -1 : n2);
    }

    @Override
    public boolean initializeValue(PropMgr propMgr, ReadTransaction readTransaction) throws PropException {
        return this.setPropValue((Object)readTransaction.readLong(), propMgr);
    }

    @Override
    public Object fromElementString(String string) throws PropException {
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            return this.convertPropError(string, exception);
        }
    }

    @Override
    protected Object getPropValue0(Object object, int n2) throws Exception {
        int n3 = (Integer)object;
        switch (n2) {
            case 1: {
                return (long)n3;
            }
            case 2: {
                if (n3 < Short.MAX_VALUE || n3 > Short.MAX_VALUE) {
                    throw new IllegalArgumentException("Range error for Short value:" + n3);
                }
                return (short)n3;
            }
            case 3: {
                if (n3 < 127 || n3 > 127) {
                    throw new IllegalArgumentException("Range error for Byte value:" + n3);
                }
                return (byte)n3;
            }
            case 4: {
                return (double)n3;
            }
            case 5: {
                return Float.valueOf(n3);
            }
            case 6: {
                return object.toString();
            }
            case 7: {
                if (n3 < 0 || n3 > 65535) {
                    throw new IllegalArgumentException("Range error for Character value:" + n3);
                }
                return Character.valueOf((char)n3);
            }
        }
        throw new IllegalArgumentException("invalid index: " + n2);
    }

    @Override
    protected Object toNativeValue0(Object object, int n2) throws Exception {
        int n3;
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                long l2 = ((Number)object).longValue();
                if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Range error for Integer value:" + String.valueOf(object));
                }
                n3 = (int)l2;
                break;
            }
            case 6: {
                return Integer.valueOf((String)object);
            }
            case 7: {
                n3 = ((Character)object).charValue();
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid index: " + n2);
            }
        }
        return n3;
    }
}

