/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.image;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ImageType
extends Enum<ImageType> {
    public static final /* enum */ ImageType UNKNOWN;
    public static final /* enum */ ImageType ALL_IMAGES;
    public static final /* enum */ ImageType PNG;
    public static final /* enum */ ImageType JPEG;
    public static final /* enum */ ImageType GIF;
    public static final /* enum */ ImageType WEBP;
    public static final /* enum */ ImageType TIFF;
    public static final /* enum */ ImageType BMP;
    public static final /* enum */ ImageType WBMP;
    public static final /* enum */ ImageType SVG;
    public final boolean isValidExtension;
    public final String mediaType;
    public final String extensions;
    public final String firstExtension;
    public final Set<String> extensionsNoDot;
    public final boolean isBitmap;
    private static final Map<String, ImageType> a;
    private static final Map<String, ImageType> b;
    private static final /* synthetic */ ImageType[] a;

    static {
        ImageType imageType;
        UNKNOWN = new ImageType(false, null, null, false);
        ALL_IMAGES = new ImageType(false, "image/*", "*", false);
        PNG = new ImageType(true, "image/png", "png", true);
        JPEG = new ImageType(true, "image/jpeg", "jpg.jpeg.jpe.jif.jfif.jfi", true);
        GIF = new ImageType(true, "image/gif", "gif", true);
        WEBP = new ImageType(true, "image/webp", "webp", true);
        TIFF = new ImageType(true, "image/tiff", "tif.tiff", true);
        BMP = new ImageType(true, "image/bmp", "bmp", true);
        WBMP = new ImageType(true, "image/vnd.wap.wbmp", "wbmp", true);
        SVG = new ImageType(true, "image/svg+xml", "svg.svgz", false);
        a = new ImageType[]{UNKNOWN, ALL_IMAGES, PNG, JPEG, GIF, WEBP, TIFF, BMP, WBMP, SVG};
        HashMap<String, ImageType> hashMap = new HashMap<String, ImageType>();
        ImageType[] imageTypeArray = ImageType.values();
        int n2 = imageTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            imageType = imageTypeArray[n3];
            if (imageType.extensionsNoDot != null) {
                for (String string : imageType.extensionsNoDot) {
                    hashMap.put(string, imageType);
                }
            }
            ++n3;
        }
        a = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap();
        imageTypeArray = ImageType.values();
        n2 = imageTypeArray.length;
        n3 = 0;
        while (n3 < n2) {
            imageType = imageTypeArray[n3];
            if (imageType.mediaType != null) {
                hashMap.put(imageType.mediaType, imageType);
            }
            ++n3;
        }
        b = Collections.unmodifiableMap(hashMap);
    }

    private ImageType(boolean bl, String string2, String string3, boolean bl2) {
        this.isValidExtension = bl;
        this.mediaType = string2;
        this.extensions = string3;
        this.isBitmap = bl2;
        Set set = null;
        String string4 = null;
        if (string3 != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                linkedHashSet.add(string5);
                if (string4 != null) continue;
                string4 = string5;
            }
            set = Collections.unmodifiableSet(linkedHashSet);
        }
        this.firstExtension = string4;
        this.extensionsNoDot = set;
    }

    public static ImageType fromExtension(String string) {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        return string2.isEmpty() ? null : a.get(string2.charAt(0) == '.' ? string2.substring(1) : string2);
    }

    public static ImageType fromMediaType(String string) {
        return b.get(string);
    }

    public static ImageType[] values() {
        ImageType[] imageTypeArray = a;
        int n2 = imageTypeArray.length;
        ImageType[] imageTypeArray2 = new ImageType[n2];
        System.arraycopy(a, 0, imageTypeArray2, 0, n2);
        return imageTypeArray2;
    }

    public static ImageType valueOf(String string) {
        return Enum.valueOf(ImageType.class, string);
    }
}

