/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class LinkedResourcesService {
    public static String[] getLinkedResources(IResource iResource, int n2) {
        return LinkedResourcesService.getLinkedResourcesHelper(iResource, n2, new HashSet<IPath>());
    }

    private static String[] getLinkedResourcesHelper(IResource object, int n2, Set<IPath> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        IPath iPath = object.getFullPath();
        if (!set.add(iPath)) {
            return new String[0];
        }
        if (object.isLinked()) {
            if ((object = object.getLocation()) != null) {
                arrayList.add(object.toOSString());
            }
        } else if (object instanceof IContainer && n2 > 0) {
            try {
                IResource[] iResourceArray = ((IContainer)object).members();
                int n3 = iResourceArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    object = iResourceArray[n4];
                    arrayList.addAll(Arrays.asList(LinkedResourcesService.getLinkedResourcesHelper(object, n2 - 1, set)));
                    ++n4;
                }
            }
            catch (CoreException coreException) {
                object = coreException;
                coreException.printStackTrace();
            }
        }
        return arrayList.toArray(new String[0]);
    }
}

