/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.preferences;

import java.util.Optional;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SharedPreferences {
    public static final String LOG_FILE_PATH_KEY = "logFilePath";
    public static final String LOG_LEVEL_KEY = "logLevel";
    public static final String IGNORE_SSL_ERRORS_KEY = "ignoreSSLErrors";
    public static final String SUGGESTION_COLOR_KEY = "suggestionColor";
    public static final Color SUGGESTION_COLOR_DEFAULT = new Color((Device)Display.getCurrent(), 127, 127, 127);
    public static final String CHAT_CONVERSATIONS_KEY = "com.tabnine.chat.conversations.v2";
    public static final String CHAT_SETTINGS_KEY = "com.tabnine.chat.settings";
    private static IPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.tabnine.eclipse");

    public static String getLogFilePath() {
        return store.getString(LOG_FILE_PATH_KEY);
    }

    public static String getLogLevel() {
        return store.getString(LOG_LEVEL_KEY);
    }

    public static String getIgnoreSSLErrors() {
        return store.getString(IGNORE_SSL_ERRORS_KEY);
    }

    public static Optional<String> getRawConversationsData() {
        return Optional.ofNullable(store.getString(CHAT_CONVERSATIONS_KEY));
    }

    public static void setRawConversationsData(String string) {
        store.setValue(CHAT_CONVERSATIONS_KEY, string);
    }

    public static Optional<String> getRawChatSettings() {
        return Optional.ofNullable(store.getString(CHAT_SETTINGS_KEY));
    }

    public static void setRawChatSettings(String string) {
        store.setValue(CHAT_SETTINGS_KEY, string);
    }

    public static Color getSuggestionColor() {
        return new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)store, (String)SUGGESTION_COLOR_KEY));
    }

    public static void initializeDefaults() {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)SUGGESTION_COLOR_KEY, (RGB)SUGGESTION_COLOR_DEFAULT.getRGB());
    }

    public static IPreferenceStore getPreferenceStore() {
        return store;
    }
}

