/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.oauth.services;

import com.github.scribejava.apis.LinkedInApi20;
import com.github.scribejava.core.builder.ScopeBuilder;
import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.iizix.ILog;
import com.iizix.Size;
import com.iizix.comm.oauth.AuthenticationProvider;
import com.iizix.server.oauth.AbstractOAuthService;
import com.iizix.server.oauth.OAuthSession;
import com.iizix.server.oauth.services.IServiceCreator;
import com.iizix.user.ProfilePictureInfo;
import com.iizix.user.UserProfileInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class LinkedIn
extends AbstractOAuthService {
    public static final String SCOPE_r_liteprofile = "r_liteprofile";
    public static final String SCOPE_r_emailaddress = "r_emailaddress";
    public static final String[] DEFAULT_SCOPES = new String[]{"r_liteprofile", "r_emailaddress"};

    public static IServiceCreator<LinkedIn> initialize(String string, String string2, String ... stringArray) {
        LinkedIn.validate(string, string2, stringArray);
        return oAuthSession -> new LinkedIn(oAuthSession, string, string2, stringArray);
    }

    public LinkedIn(OAuthSession oAuthSession, String string, String string2, String ... stringArray) {
        super(oAuthSession, LinkedIn.createServiceBuilder(string, string2).defaultScope(new ScopeBuilder(stringArray == null || stringArray.length == 0 ? DEFAULT_SCOPES : stringArray)).callback(oAuthSession.getCallbackURL()).build((DefaultApi20)LinkedInApi20.instance()));
    }

    public AuthenticationProvider getAuthenticationProvider() {
        return AuthenticationProvider.LinkedIn;
    }

    public Size getApproximateSize() {
        return new Size(750, 550);
    }

    @Override
    public String getLogoutURL() {
        return "https://www.linkedin.com/m/logout/";
    }

    @Override
    public UserProfileInfo getUserProfileInfo() throws IOException, InterruptedException, ExecutionException {
        Response response;
        Throwable throwable;
        Object object;
        OAuthRequest oAuthRequest;
        OAuth2AccessToken oAuth2AccessToken;
        String string = this.service2.getDefaultScope();
        if (!string.contains("profile")) {
            throw new IllegalStateException("No profile requested in the scopes");
        }
        String string2 = null;
        if (string.contains(SCOPE_r_emailaddress)) {
            oAuth2AccessToken = this.getAccessToken2();
            oAuthRequest = new OAuthRequest(Verb.GET, "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))");
            oAuthRequest.addHeader("x-li-format", "json");
            oAuthRequest.setCharset("utf-8");
            oAuthRequest.addHeader("Accept-Language", "en-US");
            this.service2.signRequest(oAuth2AccessToken, oAuthRequest);
            object = null;
            try {
                throwable = null;
                response = null;
                try (Response response2 = this.service2.execute(oAuthRequest);){
                    int n = response2.getCode();
                    System.out.println(n);
                    if (n != 200) {
                        ILog.WARNING(this.getClass(), (String)("Failed retrieving LinkedIn 'r_emailaddress', HTTP response " + n + ": " + response2.getMessage()));
                    } else {
                        object = response2.getBody();
                        string2 = this.a((String)object);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (JSONException jSONException) {
                ILog.SEVERE(this.getClass(), (String)("Failed parsing 'r_emailaddress' request body: " + jSONException.getMessage() + ": " + object), (Throwable)jSONException);
            }
        }
        oAuth2AccessToken = this.getAccessToken2();
        oAuthRequest = new OAuthRequest(Verb.GET, "https://api.linkedin.com/v2/me?projection=(id,firstName,lastName,localizedFirstName,localizedLastName,profilePicture(displayImage~digitalmediaAsset:playableStreams))");
        oAuthRequest.addHeader("x-li-format", "json");
        oAuthRequest.setCharset("utf-8");
        oAuthRequest.addHeader("Accept-Language", "en-US");
        this.service2.signRequest(oAuth2AccessToken, oAuthRequest);
        object = null;
        throwable = null;
        try {
            response = this.service2.execute(oAuthRequest);
            try {
                int n = response.getCode();
                if (n != 200) {
                    String string3 = "Failed retrieving LinkedIn 'r_liteprofile', HTTP response " + n + ": " + response.getMessage();
                    ILog.WARNING(this.getClass(), (String)string3);
                    throw new IOException(string3);
                }
                String string4 = response.getBody();
                UserProfileInfo userProfileInfo = this.a(string4, string2);
                if (userProfileInfo != null) {
                    return userProfileInfo;
                }
                throw new IOException("Failed parsing body JSON response: " + string4);
            }
            finally {
                if (response != null) {
                    response.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (object == null) {
                object = throwable3;
            } else if (object != throwable3) {
                ((Throwable)object).addSuppressed(throwable3);
            }
            throw object;
        }
    }

    private String a(String string) {
        JSONObject jSONObject = new JSONObject(new JSONTokener(string));
        try {
            return jSONObject.getJSONArray("elements").getJSONObject(0).getJSONObject("handle~").getString("emailAddress");
        }
        catch (JSONException jSONException) {
            ILog.SEVERE(this.getClass(), (String)("Failed parsing 'r_emailaddress' response from JSON body: " + jSONException.getMessage() + "\n" + jSONObject.toString(2)));
            return null;
        }
    }

    private UserProfileInfo a(String string, String string2) {
        JSONObject jSONObject = new JSONObject(new JSONTokener(string));
        try {
            JSONObject jSONObject2;
            String string3 = jSONObject.getString("id");
            String string4 = null;
            String string5 = jSONObject.optString("localizedFirstName", null);
            String string6 = jSONObject.optString("localizedLastName", null);
            String string7 = null;
            String string8 = null;
            ProfilePictureInfo[] profilePictureInfoArray = null;
            JSONObject jSONObject3 = jSONObject.optJSONObject("lastName");
            JSONObject jSONObject4 = null;
            if (jSONObject3 != null || (jSONObject4 = jSONObject.optJSONObject("firstName")) != null) {
                Object object = jSONObject3 != null ? jSONObject3.optJSONObject("preferredLocale") : (jSONObject2 = jSONObject4 != null ? jSONObject4.optJSONObject("preferredLocale") : null);
                if (jSONObject2 != null) {
                    string7 = jSONObject2.optString("country", null);
                    string8 = jSONObject2.optString("language", null);
                }
            }
            if ((jSONObject3 = jSONObject.optJSONObject("profilePicture")) != null && (jSONObject3 = jSONObject3.optJSONObject("displayImage~")) != null && (jSONObject2 = jSONObject3.optJSONArray("elements")) != null) {
                ArrayList<ProfilePictureInfo> arrayList = new ArrayList<ProfilePictureInfo>();
                int n = 0;
                int n2 = jSONObject2.length();
                while (n < n2) {
                    jSONObject3 = jSONObject2.optJSONObject(n);
                    if (jSONObject3 != null) {
                        JSONArray jSONArray = jSONObject3.optJSONArray("identifiers");
                        JSONObject jSONObject5 = jSONObject3.optJSONObject("data");
                        if (jSONArray != null && jSONObject5 != null && "PUBLIC".equals(jSONObject3.optString("authorizationMethod"))) {
                            int n3 = -1;
                            int n4 = -1;
                            if ((jSONObject5 = jSONObject5.optJSONObject("com.linkedin.digitalmedia.mediaartifact.StillImage")) != null && (jSONObject5 = jSONObject5.optJSONObject("storageSize")) != null) {
                                n3 = jSONObject5.optInt("width", -1);
                                n4 = jSONObject5.optInt("height", -1);
                            }
                            int n5 = 0;
                            int n6 = jSONArray.length();
                            while (n5 < n6) {
                                jSONObject5 = jSONArray.optJSONObject(n5);
                                if (jSONObject5 != null) {
                                    String string9 = jSONObject5.optString("identifier", null);
                                    String string10 = jSONObject5.optString("mediaType", null);
                                    if (string9 != null && string10 != null) {
                                        try {
                                            arrayList.add(new ProfilePictureInfo(string9, string10, n3, n4));
                                        }
                                        catch (MalformedURLException | URISyntaxException exception) {
                                            ILog.SEVERE(this.getClass(), (String)("Failed adding ProfilePictureInfo, url = " + string9 + ": " + exception.getMessage()));
                                        }
                                    }
                                }
                                ++n5;
                            }
                        }
                    }
                    ++n;
                }
                n = arrayList.size();
                if (n > 0) {
                    profilePictureInfoArray = arrayList.toArray(new ProfilePictureInfo[n]);
                }
            }
            return new UserProfileInfo(string3, string4, null, string5, null, string6, string2, null, string7, string8, profilePictureInfoArray);
        }
        catch (JSONException jSONException) {
            ILog.SEVERE(this.getClass(), (String)("Failed parsing 'r_liteprofile' response from JSON body: " + jSONException.getMessage() + "\n" + jSONObject.toString(2)));
            return null;
        }
    }
}

