/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.app.builder;

import com.iizix.app.builder.IIDirectory;
import com.iizix.app.builder.IIResource;
import com.iizix.app.builder.JavaFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class JavaDirectory
implements IIDirectory {
    private File a;

    public JavaDirectory(File file) throws IOException {
        this.a = file.getCanonicalFile();
        if (!this.a.isDirectory()) {
            throw new IOException("File '" + this.a.getPath() + "' is not a directory");
        }
    }

    @Override
    public String getFullPath() {
        return this.a.getPath();
    }

    @Override
    public File getFile(Object object) {
        return this.a;
    }

    @Override
    public List<IIResource> listDirectory(Object object) throws IOException {
        ArrayList<IIResource> arrayList = new ArrayList<IIResource>();
        File[] fileArray = this.a.listFiles();
        if (fileArray == null) {
            throw new FileNotFoundException("Directory '" + this.getFullPath() + "' does not exist");
        }
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray2[n2];
            if (file.isDirectory()) {
                arrayList.add(new JavaDirectory(file));
            } else {
                arrayList.add(new JavaFile(file));
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public String getName() {
        return this.a.getName();
    }

    public boolean equals(Object object) {
        try {
            return object instanceof IIResource && ((IIResource)object).getFullPath().equals(this.getFullPath());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

