/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.txp.impl;

import com.iizix.txp.ITXPCoordinator;
import com.iizix.txp.ITXPMonitor;
import com.iizix.txp.ITXPNode;
import com.iizix.txp.ITXPPolicy;
import com.iizix.txp.ITXProcess;
import com.iizix.txp.TXPException;
import com.iizix.txp.TXPHeuristicMixedException;
import com.iizix.txp.TXPNodesBusyException;
import com.iizix.txp.TXPRollbackException;
import com.iizix.txp.impl.ITXPLogger;
import com.iizix.txp.impl.TXPLogger;
import com.iizix.txp.impl.TXPPolicyImpl;
import com.iizix.txp.impl.TXPidFactory;
import com.iizix.txp.impl.TXProcessImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TXPCoordinatorImpl
implements ITXPCoordinator {
    ArrayList<TXProcessImpl> a;
    private final LinkedHashSet<ITXPMonitor> a;
    private ITXPMonitor[] a;
    ITXPPolicy a;
    ITXPLogger a = new TXPLogger();
    private static volatile /* synthetic */ int[] a;

    public TXPCoordinatorImpl() {
        this.a().info("TXP Coordinator: [" + String.valueOf(this) + "] started");
        this.a = this.a().usePolicy(new TXPPolicyImpl());
    }

    public TXPCoordinatorImpl(ITXPPolicy iTXPPolicy) {
        this.a().info("TXP Coordinator: [" + String.valueOf(this) + "] started");
        this.a = this.a().usePolicy(iTXPPolicy);
    }

    public void setLogger(ITXPLogger iTXPLogger) {
        this.a = iTXPLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ITXPMonitor[] a() {
        ITXPMonitor[] iTXPMonitorArray = this.a;
        if (iTXPMonitorArray == null) {
            ArrayList<TXProcessImpl> arrayList = this.a;
            synchronized (arrayList) {
                this.a = iTXPMonitorArray = ((HashSet)((Object)this.a)).toArray((ITXPMonitor[])new ITXPMonitor[((HashSet)((Object)this.a)).size()]);
            }
        }
        return iTXPMonitorArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ITXProcess newProcess() {
        TXProcessImpl tXProcessImpl = new TXProcessImpl(TXPidFactory.newPid(), this);
        ArrayList<TXProcessImpl> arrayList = this.a;
        synchronized (arrayList) {
            this.a.add(tXProcessImpl);
        }
        tXProcessImpl.a(ITXProcess.State.READY);
        this.onBeganProcess(tXProcessImpl);
        return tXProcessImpl;
    }

    public void ready(ITXProcess iTXProcess, ITXPNode iTXPNode, ITXPNode.State state) {
        this.onNodeReady(iTXProcess, iTXPNode, state);
        if (state == ITXPNode.State.FAILED) {
            TXProcessImpl tXProcessImpl = (TXProcessImpl)iTXProcess;
            ITXPPolicy.Action action = ITXPPolicy.Action.SET_ROLLBACK;
            try {
                action = this.a(iTXProcess).onNodeReadyFailed(iTXProcess, iTXPNode);
            }
            catch (Throwable throwable) {
                this.a().error("Retrieving policy action failed", throwable);
            }
            this.onNodeReadyFailedPolicyAction(iTXProcess, iTXPNode, action);
            switch (TXPCoordinatorImpl.a()[action.ordinal()]) {
                case 2: {
                    tXProcessImpl.a(iTXPNode);
                    break;
                }
                default: {
                    tXProcessImpl.a(ITXProcess.State.ROLLBACK);
                }
            }
        }
    }

    public void commit(ITXProcess iTXProcess) throws TXPException {
        this.onCommitInitiated(iTXProcess);
        if (iTXProcess.getState() == ITXProcess.State.ROLLBACK || iTXProcess.getState() == ITXProcess.State.TIMED_OUT) {
            TXPRollbackException tXPRollbackException = new TXPRollbackException(iTXProcess.getState() == ITXProcess.State.TIMED_OUT ? "Process timed out" : "One or more nodes have failed and requested rollback of the process");
            this.onCommitCanceled(iTXProcess, (TXPException)tXPRollbackException);
            this.rollback(iTXProcess);
            throw tXPRollbackException;
        }
        TXProcessImpl tXProcessImpl = (TXProcessImpl)iTXProcess;
        if (!tXProcessImpl.a()) {
            TXPNodesBusyException tXPNodesBusyException = new TXPNodesBusyException("Not all nodes have finnished yet");
            this.onCommitCanceled(iTXProcess, (TXPException)tXPNodesBusyException);
            throw tXPNodesBusyException;
        }
        tXProcessImpl.a();
        ITXPPolicy.Action action = ITXPPolicy.Action.IGNORE;
        boolean bl = false;
        for (ITXPNode iTXPNode : tXProcessImpl.a()) {
            ITXPNode.State state = iTXPNode.commit((ITXProcess)tXProcessImpl);
            if (state != ITXPNode.State.COMPLETED) {
                action = this.a(iTXProcess).onNodeCommitFailed(iTXProcess, iTXPNode);
                this.onNodeCommitFailedPolicyAction(iTXProcess, iTXPNode, action);
            }
            if (action == ITXPPolicy.Action.ROLLBACK_REST) {
                bl = true;
                break;
            }
            if (action != ITXPPolicy.Action.CONTINUE) continue;
            bl = true;
        }
        if (bl) {
            this.a().heuristicMixed((TXProcessImpl)iTXProcess);
        }
        if (action == ITXPPolicy.Action.ROLLBACK_REST) {
            try {
                this.rollback(iTXProcess);
            }
            catch (TXPHeuristicMixedException tXPHeuristicMixedException) {
                throw new TXPHeuristicMixedException("Some nodes failed rolling back after an other one failed commit", (Throwable)tXPHeuristicMixedException);
            }
        } else {
            tXProcessImpl.a(ITXProcess.State.COMPLETED);
        }
        if (bl) {
            throw new TXPHeuristicMixedException("Some nodes have failed commit and rolled back their work");
        }
    }

    public void rollback(ITXProcess iTXProcess) throws TXPException {
        this.onRollbackInitiated(iTXProcess);
        TXProcessImpl tXProcessImpl = (TXProcessImpl)iTXProcess;
        if (!tXProcessImpl.a()) {
            TXPNodesBusyException tXPNodesBusyException = new TXPNodesBusyException("Not all nodes have finnished yet");
            this.onRollbackCanceled(iTXProcess, (TXPException)tXPNodesBusyException);
            throw tXPNodesBusyException;
        }
        tXProcessImpl.a();
        ITXPPolicy.Action action = ITXPPolicy.Action.IGNORE;
        boolean bl = false;
        for (ITXPNode iTXPNode : tXProcessImpl.a()) {
            ITXPNode.State state = iTXPNode.rollback((ITXProcess)tXProcessImpl);
            if (state != ITXPNode.State.COMPLETED) {
                action = this.a(iTXProcess).onNodeRollbackFailed(iTXProcess, iTXPNode);
                this.onNodeRollbackFailedPolicyAction(iTXProcess, iTXPNode, action);
            }
            if (action != ITXPPolicy.Action.CONTINUE) continue;
            bl = true;
        }
        if (bl) {
            this.a().heuristicMixed((TXProcessImpl)iTXProcess);
        }
        tXProcessImpl.a(ITXProcess.State.COMPLETED);
        if (bl) {
            throw new TXPHeuristicMixedException("Some nodes have failed rollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(ITXPMonitor iTXPMonitor) {
        if (iTXPMonitor == null) {
            throw new NullPointerException();
        }
        ArrayList<TXProcessImpl> arrayList = this.a;
        synchronized (arrayList) {
            if (((HashSet)((Object)this.a)).add((TXProcessImpl)iTXPMonitor)) {
                this.a = null;
            }
        }
        this.onMonitorAdded(iTXPMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMonitor(ITXPMonitor iTXPMonitor) {
        ArrayList<TXProcessImpl> arrayList = this.a;
        synchronized (arrayList) {
            if (((HashSet)((Object)this.a)).remove(iTXPMonitor)) {
                this.a = null;
            }
        }
        this.onMonitorRemoved(iTXPMonitor);
    }

    public ITXPCoordinator getCoordinator() {
        return this;
    }

    public void onMonitorAdded(ITXPMonitor iTXPMonitor) {
        this.a().monitorAdded(iTXPMonitor);
        ITXPMonitor[] iTXPMonitorArray = this.a();
        int n2 = iTXPMonitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ITXPMonitor iTXPMonitor2 = iTXPMonitorArray[n3];
            iTXPMonitor2.onMonitorAdded(iTXPMonitor);
            ++n3;
        }
    }

    public void onMonitorRemoved(ITXPMonitor iTXPMonitor) {
        this.a().monitorRemoved(iTXPMonitor);
        ITXPMonitor[] iTXPMonitorArray = this.a();
        int n2 = iTXPMonitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ITXPMonitor iTXPMonitor2 = iTXPMonitorArray[n3];
            iTXPMonitor2.onMonitorRemoved(iTXPMonitor);
            ++n3;
        }
    }

    public void onBeganProcess(ITXProcess iTXProcess) {
        this.a().newProcess((TXProcessImpl)iTXProcess);
        ITXPMonitor[] iTXPMonitorArray = this.a();
        int n2 = iTXPMonitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
            iTXPMonitor.onBeganProcess(iTXProcess);
            ++n3;
        }
    }

    public void onNodeAssociated(ITXProcess iTXProcess, ITXPNode iTXPNode, ITXPNode.State state) {
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onNodeAssociated(iTXProcess, iTXPNode, state);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            this.a().error("Error notifying monitors of a new node asscociation:", throwable);
        }
    }

    public void onNodeDisassociated(ITXProcess iTXProcess, ITXPNode iTXPNode) {
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onNodeDisassociated(iTXProcess, iTXPNode);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onNodeReady(ITXProcess iTXProcess, ITXPNode iTXPNode, ITXPNode.State state) {
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onNodeReady(iTXProcess, iTXPNode, state);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onNodeTimeoutSignaled(ITXProcess iTXProcess, ITXPNode iTXPNode) {
        ITXPMonitor iTXPMonitor;
        ITXPMonitor[] iTXPMonitorArray = this.a();
        int n2 = iTXPMonitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            iTXPMonitor = iTXPMonitorArray[n3];
            iTXPMonitor.onNodeTimeoutSignaled(iTXProcess, iTXPNode);
            ++n3;
        }
        iTXPMonitor = this.a(iTXProcess).onNodeTimeoutSignaled(iTXProcess, iTXPNode);
        this.onNodeTimeoutSignaledPolicyAction(iTXProcess, iTXPNode, (ITXPPolicy.Action)iTXPMonitor);
        switch (TXPCoordinatorImpl.a()[iTXPMonitor.ordinal()]) {
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                ((TXProcessImpl)iTXProcess).a(ITXProcess.State.ROLLBACK);
            }
        }
    }

    public void onProcessTimeoutSignaled(ITXProcess iTXProcess) {
        ITXPMonitor iTXPMonitor;
        ITXPMonitor[] iTXPMonitorArray = this.a();
        int n2 = iTXPMonitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            iTXPMonitor = iTXPMonitorArray[n3];
            iTXPMonitor.onProcessTimeoutSignaled(iTXProcess);
            ++n3;
        }
        iTXPMonitor = this.a(iTXProcess).onProcessTimeoutSignaled(iTXProcess);
        this.onProcessTimeoutSignaledPolicyAction(iTXProcess, (ITXPPolicy.Action)iTXPMonitor);
        switch (TXPCoordinatorImpl.a()[iTXPMonitor.ordinal()]) {
            case 4: {
                break;
            }
            case 6: {
                break;
            }
            default: {
                ((TXProcessImpl)iTXProcess).a(ITXProcess.State.TIMED_OUT);
            }
        }
    }

    public void onCommitInitiated(ITXProcess iTXProcess) {
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onCommitInitiated(iTXProcess);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onCommitCanceled(ITXProcess iTXProcess, TXPException tXPException) {
        this.a().commitCanceled((TXProcessImpl)iTXProcess, tXPException);
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onCommitCanceled(iTXProcess, tXPException);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onRollbackInitiated(ITXProcess iTXProcess) {
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onRollbackInitiated(iTXProcess);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onRollbackCanceled(ITXProcess iTXProcess, TXPException tXPException) {
        this.a().rollbackCanceled((TXProcessImpl)iTXProcess, tXPException);
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onRollbackCanceled(iTXProcess, tXPException);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onNodeReadyFailedPolicyAction(ITXProcess iTXProcess, ITXPNode iTXPNode, ITXPPolicy.Action action) {
        this.a().nodeReadyFailedPolicyAction((TXProcessImpl)iTXProcess, iTXPNode, action);
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onNodeReadyFailedPolicyAction(iTXProcess, iTXPNode, action);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onNodeCommitFailedPolicyAction(ITXProcess iTXProcess, ITXPNode iTXPNode, ITXPPolicy.Action action) {
        this.a().nodeCommitFailedPolicyAction((TXProcessImpl)iTXProcess, iTXPNode, action);
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onNodeCommitFailedPolicyAction(iTXProcess, iTXPNode, action);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onNodeRollbackFailedPolicyAction(ITXProcess iTXProcess, ITXPNode iTXPNode, ITXPPolicy.Action action) {
        this.a().nodeRollbackFailedPolicyAction((TXProcessImpl)iTXProcess, iTXPNode, action);
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onNodeRollbackFailedPolicyAction(iTXProcess, iTXPNode, action);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onNodeTimeoutSignaledPolicyAction(ITXProcess iTXProcess, ITXPNode iTXPNode, ITXPPolicy.Action action) {
        this.a().nodeTimeoutSignaledPolicyAction((TXProcessImpl)iTXProcess, iTXPNode, action);
        ITXPMonitor[] iTXPMonitorArray = this.a();
        int n2 = iTXPMonitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
            iTXPMonitor.onNodeTimeoutSignaledPolicyAction(iTXProcess, iTXPNode, action);
            ++n3;
        }
    }

    public void onProcessTimeoutSignaledPolicyAction(ITXProcess iTXProcess, ITXPPolicy.Action action) {
        this.a().processTimeoutSignaledPolicyAction((TXProcessImpl)iTXProcess, action);
        ITXPMonitor[] iTXPMonitorArray = this.a();
        int n2 = iTXPMonitorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
            iTXPMonitor.onProcessTimeoutSignaledPolicyAction(iTXProcess, action);
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProcessCreated(ITXProcess iTXProcess) {
        this.a().processCreated((TXProcessImpl)iTXProcess);
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onProcessCreated(iTXProcess);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            ArrayList<TXProcessImpl> arrayList = this.a;
            synchronized (arrayList) {
                this.a.remove(iTXProcess);
            }
            throw throwable;
        }
        ArrayList<TXProcessImpl> arrayList = this.a;
        synchronized (arrayList) {
            this.a.remove(iTXProcess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onProcessCompleted(ITXProcess iTXProcess) {
        this.a().processCompleted((TXProcessImpl)iTXProcess);
        try {
            ITXPMonitor[] iTXPMonitorArray = this.a();
            int n2 = iTXPMonitorArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ITXPMonitor iTXPMonitor = iTXPMonitorArray[n3];
                iTXPMonitor.onProcessCompleted(iTXProcess);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            ArrayList<TXProcessImpl> arrayList = this.a;
            synchronized (arrayList) {
                this.a.remove(iTXProcess);
            }
            throw throwable;
        }
        ArrayList<TXProcessImpl> arrayList = this.a;
        synchronized (arrayList) {
            this.a.remove(iTXProcess);
        }
    }

    ITXPPolicy a(ITXProcess iTXProcess) {
        ITXPPolicy iTXPPolicy = iTXProcess.getLocalPolicy();
        return iTXPPolicy == null ? this.a : iTXPPolicy;
    }

    void a(TXProcessImpl tXProcessImpl, ITXPPolicy iTXPPolicy) {
        this.a().localPolicySet(tXProcessImpl, iTXPPolicy);
    }

    ITXPLogger a() {
        return this.a;
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[ITXPPolicy.Action.values().length];
        try {
            nArray[ITXPPolicy.Action.CONTINUE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITXPPolicy.Action.DISASSOCIATE_NODE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITXPPolicy.Action.IGNORE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITXPPolicy.Action.ROLLBACK_REST.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITXPPolicy.Action.SET_ROLLBACK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[ITXPPolicy.Action.SET_TIMED_OUT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }
}

