/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.gyro;

import com.iizix.text.KString;

@FunctionalInterface
public interface IToaster {
    public static final int TOASTER_DEFAULT_DURATION = 2000;
    public static final int TOASTER_MAX_DURATION = 10000;
    public static final int TOASTER_MIN_DURATION = 0;

    default public void toast(String string) {
        this.toast(string, null, null, null);
    }

    default public void toast(KString kString) {
        this.toast(kString, null, null, null);
    }

    default public void toast(String string, Type type) {
        this.toast(string, null, null, type);
    }

    default public void toast(KString kString, Type type) {
        this.toast(kString, null, null, type);
    }

    default public void toast(String string, Position position, Direction direction, Type type) {
        this.toast(KString.newPlainKString(string), position, direction, type);
    }

    default public void toast(KString kString, Position position, Direction direction, Type type) {
        this.toast(kString, position, direction, type, 2000);
    }

    default public void toast(String string, Position position, Direction direction, Type type, int n2) {
        this.toast(KString.newPlainKString(string), position, direction, type, n2);
    }

    public void toast(KString var1, Position var2, Direction var3, Type var4, int var5);

    public static enum Direction {
        LEFT("left"),
        RIGHT("right"),
        UP("up"),
        DOWN("down");

        public final String direction;

        private Direction(String string2) {
            this.direction = string2;
        }
    }

    public static enum Position {
        BOTTOM_LEFT("bl"),
        BOTTOM_CENTER("bc"),
        BOTTOM_RIGHT("br"),
        TOP_LEFT("tl"),
        TOP_CENTER("tc"),
        TOP_RIGHT("tr");

        public final String position;

        private Position(String string2) {
            this.position = string2;
        }
    }

    public static enum Type {
        MESSAGE("message"),
        WARNING("warning"),
        ERROR("error"),
        FATAL("fatal");

        public final String type;

        private Type(String string2) {
            this.type = string2;
        }
    }
}

