/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.quickfix.fixer;

import com.iizigo.Activator;
import com.iizigo.editor.PropEditorPart;
import com.iizigo.editor.PropHelper;
import com.iizigo.project.ModuleFolder;
import com.iizigo.prop.DesignerProp;
import com.iizigo.prop.FilePropCnr;
import com.iizigo.prop.IPropDesigner;
import com.iizigo.prop.PropMarker;
import com.iizigo.quickfix.IQuickFix;
import com.iizigo.quickfix.QuickFixAdapter;
import com.iizix.ILog;
import com.iizix.prop.GProp;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;

public abstract class GotoProperty
extends QuickFixAdapter
implements IQuickFix {
    private String a;
    protected GProp<?> property;
    protected String location;
    protected String editorName;
    protected boolean isRoot;
    protected boolean isFolder;

    public GotoProperty() {
    }

    protected GotoProperty(GProp<?> gProp) {
        this.a = gProp.getReferencePropName();
    }

    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("com.iizigo.propref", this.a);
        return hashMap;
    }

    @Override
    public void run(IMarker iMarker) {
        GProp<?> gProp = PropMarker.getProperty(iMarker);
        if (gProp == null) {
            Activator.messageBox("Property Reference", "Cannot find the Property Reference '" + this.a + "'.", 33);
            return;
        }
        if (this.isRoot || this.isFolder) {
            try {
                IViewPart iViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.iizigo.navigator", null, 1);
                CommonNavigator commonNavigator = (CommonNavigator)iViewPart;
                PropHelper.selectPropsAndFocusTreeViewer(new GProp[]{this.property}, (StructuredViewer)commonNavigator.getCommonViewer());
            }
            catch (Exception exception) {
                ILog.SEVERE(this.getClass(), (String)"Failed to open IIZI Explorer", (Throwable)exception);
                Activator.openError("Open IIZI Explorer", "Failed to open IIZI Explorer", exception);
            }
            return;
        }
        FilePropCnr filePropCnr = FilePropCnr.fromProperty(gProp);
        if (filePropCnr == null) {
            Activator.messageBox("Property Reference", "Cannot find the Editor for the Property Reference '" + this.a + "'.", 33);
            return;
        }
        IEditorPart iEditorPart = PropHelper.doOpen((IFile)filePropCnr.getDesigner().getIResource());
        if (iEditorPart == null) {
            return;
        }
        if (!(iEditorPart instanceof PropEditorPart)) {
            Activator.messageBox("Open Editor", "The Editor for the Property Reference '" + this.a + "' is not of correct type, cannot open the Reference.", 40);
            return;
        }
        String string = iMarker.getAttribute("com.iizigo.childName", "");
        ((PropEditorPart)iEditorPart).doOpen(gProp, -1, string.isEmpty() ? null : string);
    }

    @Override
    public void setMarker(IMarker iMarker) {
        super.setMarker(iMarker);
        this.property = PropMarker.getProperty(iMarker);
        if (this.property != null) {
            DesignerProp designerProp;
            ModuleFolder moduleFolder;
            if (this.property.isPropRoot()) {
                this.isRoot = true;
                this.location = "Module Root";
                return;
            }
            if (this.property instanceof IPropDesigner && (moduleFolder = (designerProp = ((IPropDesigner)this.property).getDesigner()).getFolder()) != null) {
                this.location = moduleFolder.title;
                if (this.property.isPropFolder()) {
                    this.isFolder = true;
                } else {
                    this.editorName = moduleFolder.itemTitle;
                }
            }
        }
    }
}

