/*
 * Decompiled with CFR 0.152.
 */
package com.tabnine.eclipse.shared.api.services;

import com.tabnine.eclipse.shared.api.DependencyContainer;
import com.tabnine.eclipse.shared.api.binary.BinaryRequestFacade;
import com.tabnine.eclipse.shared.api.binary.requests.CapabilitiesResponse;
import com.tabnine.eclipse.shared.api.binary.requests.CapabilitiesResponse$Capability;
import com.tabnine.eclipse.shared.api.binary.requests.CapabiltiesRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class CapabilitiesService {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2);
    private BinaryRequestFacade binaryRequestFacade = DependencyContainer.instanceOfBinaryRequestFacade();
    private Optional<CapabilitiesResponse> lastResponse = Optional.empty();
    private List<Consumer<CapabilitiesResponse>> listeners = new ArrayList<Consumer<CapabilitiesResponse>>();
    private static CapabilitiesService instance;

    public static CapabilitiesService getInstance() {
        if (instance == null) {
            instance = new CapabilitiesService();
        }
        return instance;
    }

    public boolean isReady() {
        return this.lastResponse.map(capabilitiesResponse -> capabilitiesResponse.getExperimentSource().isRemoteBased()).orElse(Boolean.FALSE);
    }

    public boolean isEnabled(CapabilitiesResponse$Capability capabilitiesResponse$Capability) {
        return this.lastResponse.flatMap(capabilitiesResponse -> capabilitiesResponse.getFeatures()).map(list -> list.contains((Object)capabilitiesResponse$Capability)).orElse(Boolean.FALSE);
    }

    public void subscribe(Consumer<CapabilitiesResponse> consumer) {
        this.lastResponse.ifPresent(consumer::accept);
        this.listeners.add(consumer);
    }

    public void unsubscribe(Consumer<CapabilitiesResponse> consumer) {
        this.listeners.remove(consumer);
    }

    public void notifyListeners(CapabilitiesResponse capabilitiesResponse) {
        for (Consumer<CapabilitiesResponse> consumer : new CopyOnWriteArrayList<Consumer<CapabilitiesResponse>>(this.listeners)) {
            try {
                consumer.accept(capabilitiesResponse);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
            }
        }
    }

    public Optional<CapabilitiesResponse> getLastResponse() {
        return this.lastResponse;
    }

    private void updateCapabilties() {
        Optional.ofNullable(this.binaryRequestFacade.executeRequest(new CapabiltiesRequest())).ifPresent(capabilitiesResponse -> {
            if (this.lastResponse.map(capabilitiesResponse2 -> !capabilitiesResponse2.equals(capabilitiesResponse)).orElse(Boolean.TRUE).booleanValue()) {
                this.lastResponse = Optional.of(capabilitiesResponse);
                this.notifyListeners((CapabilitiesResponse)capabilitiesResponse);
            }
        });
    }

    public void start() {
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.updateCapabilties();
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                throwable.printStackTrace();
                return;
            }
        }, 0L, 10L, TimeUnit.SECONDS);
    }
}

