/**
 * Function ignore(_e)
 * 
 * <p>Ignore mouse and keyboard events.
 * 
 * @type Function
 */
function ignore(_e)
  {
  // Let it pass for the entry fields.
  document.body.style.cursor='default';
  var e=_e || window.event;
  e.cancelBubble=true; // IE
  if ( e.stopPropagation ) e.stopPropagation();
  if ( e.preventDefault  ) e.preventDefault();    
  return false;
  }
  
// Disable mouse and keyboard.
document.onmousedown=
document.onmousemove=
document.onmouseup=
document.oncontextmenu=
document.body.onkeydown=
document.body.onkeypress=
document.body.onkeyup=ignore;

/**
 * Function setPreviewsContent(s)
 * 
 * <p>Setup for the content of the previews.
 * 
 * @type Function
 * 
 * @param {String} s  The content string.
 */
function setPreviewsContent(s)
  {
  // Set "iconN" where N is 1-7.
  for ( var ii=8; --ii; )
    document.getElementById('icon'+ii).innerHTML=s;
  }

/**
 * Function setStateContent(s)
 * 
 * <p>Setup for the content of the previews.
 * 
 * @type Function
 * 
 * @param {String} s  The content string.
 */
function setStateContent(s)
  {
  document.getElementById('icon_normal' ).innerHTML=
  document.getElementById('icon_disable').innerHTML=
  document.getElementById('icon_press'  ).innerHTML=
  document.getElementById('icon_focus'  ).innerHTML=
  document.getElementById('icon_hover'  ).innerHTML=
  document.getElementById('icon_capture').innerHTML=s;
  }

/**
 * Function setSVG(s)
 *
 * <p>Assigns the SVG to all div's.
 *
 * @param {String}  s  The SVG string.
 */
function setSVG(s)
  {
  document.getElementById('icon_normal' ).innerHTML=
  document.getElementById('icon_rtl'    ).innerHTML=
  document.getElementById('icon_disable').innerHTML=
  document.getElementById('icon_press'  ).innerHTML=
  document.getElementById('icon_focus'  ).innerHTML=
  document.getElementById('icon_select' ).innerHTML=
  document.getElementById('icon_hover'  ).innerHTML=
  document.getElementById('icon_capture').innerHTML=s;
  }

///
/// --- Initialize in a jiffy ---
///

// Asynchronous events are only fired if the browser is ready.
// The browser is not ready when loading.
setTimeout(function()
  {
  // Callback to Eclipse when done.
  onJSInitialized();
  },0);

// Test with Apple logo.
function onJSInitialized()
  {
  setSVG('<svg width="32" height="32" viewBox="0 0 32 32"><path d="M24.734 17.003c-0.040-4.053 3.305-5.996 3.454-6.093-1.88-2.751-4.808-3.127-5.851-3.171-2.492-0.252-4.862 1.467-6.127 1.467-1.261 0-3.213-1.43-5.28-1.392-2.716 0.040-5.221 1.579-6.619 4.012-2.822 4.897-0.723 12.151 2.028 16.123 1.344 1.944 2.947 4.127 5.051 4.049 2.026-0.081 2.793-1.311 5.242-1.311s3.138 1.311 5.283 1.271c2.18-0.041 3.562-1.981 4.897-3.931 1.543-2.255 2.179-4.439 2.216-4.551-0.048-0.022-4.252-1.632-4.294-6.473zM20.705 5.11c1.117-1.355 1.871-3.235 1.665-5.11-1.609 0.066-3.559 1.072-4.713 2.423-1.036 1.199-1.942 3.113-1.699 4.951 1.796 0.14 3.629-0.913 4.747-2.264z"></path></svg>');
  }
