/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.prop;

import com.iizix.prop.Atom;
import com.iizix.prop.PropCnr;
import com.iizix.prop.StringMapProp;
import com.iizix.server.app.AppFactory;
import com.iizix.server.gyro.AppSessionGyro;
import com.iizix.server.monitor.EndPointPropCnr;
import com.iizix.server.prop.AllowedDomains;
import com.iizix.server.prop.IServerApplicationSetupPropCnr;
import com.iizix.server.prop.ServerApplicationSetupException;
import com.iizix.server.prop.ServerPluginConfig;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ServerConfigEnvProps
extends PropCnr {
    public static final String ALLOW_PARALLEL_SESSIONS = "allowParallelSessions";
    public static final String MAX_CLIENTS_PER_APP_SESSION = "maxClientsPerAppSession";
    public static final String APP_TIMEOUT = "appTimeout";
    public static final String CUSTOM_APP_SETTINGS = "customApp";
    public static final String ALLOWED_DOMAINS = "allowedDomains";
    public static final String REQUIRE_TLS = "requireTLS";
    private ServerPluginConfig[] a;
    private AllowedDomains a;
    private int a = -1;

    public ServerConfigEnvProps() {
    }

    public ServerConfigEnvProps(Atom atom) {
        super(atom);
    }

    public ServerConfigEnvProps clone() {
        try {
            ServerConfigEnvProps serverConfigEnvProps = (ServerConfigEnvProps)super.clone();
            serverConfigEnvProps.a = null;
            serverConfigEnvProps.a = null;
            serverConfigEnvProps.a = -1;
            return serverConfigEnvProps;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Shouldn't be", cloneNotSupportedException);
        }
    }

    protected void onPropInvalidateCache() {
        this.a = null;
        this.a = -1;
    }

    public String getDescription() {
        return this.getString(Atom.DESCR);
    }

    public ServerPluginConfig[] getPluginConfigs() {
        if (this.a == null) {
            this.a = (ServerPluginConfig[])this.getProps(ServerPluginConfig.class);
        }
        return this.a;
    }

    public IServerApplicationSetupPropCnr[] getServerApplicationSetup(String string) {
        ServerPluginConfig[] serverPluginConfigArray = this.getPluginConfigs();
        int n = serverPluginConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerPluginConfig serverPluginConfig = serverPluginConfigArray[n2];
            if (serverPluginConfig.getPropName().equals(string)) {
                return serverPluginConfig.getServerApplicationSetup();
            }
            ++n2;
        }
        return null;
    }

    public boolean isUserParallelSessionsAllowed() {
        return this.getBool(ALLOW_PARALLEL_SESSIONS, true);
    }

    public int getMaxClientsPerAppSession() {
        return Math.max(0, this.getInt(MAX_CLIENTS_PER_APP_SESSION, 0));
    }

    public long getAppTimeout() {
        return Math.max(-1L, this.getLong(APP_TIMEOUT, 3600000L));
    }

    public String getCustomAppValue(String string) {
        StringMapProp stringMapProp = (StringMapProp)this.getProp(CUSTOM_APP_SETTINGS, StringMapProp.class);
        return stringMapProp != null ? stringMapProp.getValue(string) : null;
    }

    void a(AppFactory appFactory) throws ServerApplicationSetupException {
        ServerPluginConfig[] serverPluginConfigArray = this.getPluginConfigs();
        int n = serverPluginConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerPluginConfig serverPluginConfig = serverPluginConfigArray[n2];
            serverPluginConfig.a(appFactory);
            ++n2;
        }
    }

    void b(AppFactory appFactory) {
        ServerPluginConfig[] serverPluginConfigArray = this.getPluginConfigs();
        int n = serverPluginConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerPluginConfig serverPluginConfig = serverPluginConfigArray[n2];
            serverPluginConfig.b(appFactory);
            ++n2;
        }
    }

    void a(AppSessionGyro appSessionGyro) {
        ServerPluginConfig[] serverPluginConfigArray = this.getPluginConfigs();
        int n = serverPluginConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerPluginConfig serverPluginConfig = serverPluginConfigArray[n2];
            serverPluginConfig.a(appSessionGyro);
            ++n2;
        }
    }

    void b(AppSessionGyro appSessionGyro) {
        ServerPluginConfig[] serverPluginConfigArray = this.getPluginConfigs();
        int n = serverPluginConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerPluginConfig serverPluginConfig = serverPluginConfigArray[n2];
            serverPluginConfig.b(appSessionGyro);
            ++n2;
        }
    }

    public void onAppSessionEndPoint(EndPointPropCnr endPointPropCnr, AppSessionGyro appSessionGyro) {
        ServerPluginConfig[] serverPluginConfigArray = this.getPluginConfigs();
        int n = serverPluginConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ServerPluginConfig serverPluginConfig = serverPluginConfigArray[n2];
            serverPluginConfig.a(endPointPropCnr, appSessionGyro);
            ++n2;
        }
    }

    public String getAllowedDomains() {
        String string = this.getString(ALLOWED_DOMAINS);
        return string != null ? string.trim().toLowerCase() : null;
    }

    public Set<String> getAllowedDomainSet() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string = this.getAllowedDomains();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                if (string2.isEmpty()) continue;
                linkedHashSet.add(string2);
            }
        }
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllowedDomains a() {
        AllowedDomains allowedDomains = this.a;
        if (allowedDomains == null) {
            ServerConfigEnvProps serverConfigEnvProps = this;
            synchronized (serverConfigEnvProps) {
                if (this.a == null) {
                    this.a = new AllowedDomains(this.getAllowedDomains());
                }
                allowedDomains = this.a;
            }
        }
        return allowedDomains;
    }

    public boolean isTLSRequired() {
        int n = this.a;
        if (n < 0) {
            this.a = this.getBool(REQUIRE_TLS) ? 1 : 0;
            n = this.a;
        }
        return n == 1;
    }

    public boolean isDomainAccessAllowed(String string, boolean bl) {
        if (this.isTLSRequired() && !bl) {
            return false;
        }
        return this.a().a(string);
    }
}

