/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.server.app;

import com.iizix.AutoLock;
import com.iizix.GenericListener;
import com.iizix.ILog;
import com.iizix.Utilities;
import com.iizix.prop.PropException;
import com.iizix.server.IAppLoader;
import com.iizix.server.ServerShell;
import com.iizix.server.app.AppFactory;
import com.iizix.server.app.DBApp;
import com.iizix.server.app.HotDeploy;
import com.iizix.server.app.IAppChangedListener;
import com.iizix.server.devel.ModuleProject;
import com.iizix.server.prop.ServerApplicationSetupException;
import com.iizix.server.prop.ServerSettings;
import com.iizix.server.wsfile.WSFileProvider;
import com.iizix.urn.URNResourceType;
import com.iizix.util.IJarFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AppDefinition {
    public final String id;
    private final String a;
    private final File a;
    private final IJarFile a;
    private final LinkedHashSet<File> a;
    private AppFactory a;
    private HotDeploy a;
    private boolean a;
    private ServerShell a;
    private WSFileProvider a;
    private final AutoLock a;
    private final GenericListener<IAppChangedListener> a = new GenericListener(IAppChangedListener.class);

    public AppDefinition(DBApp dBApp, boolean bl) {
        this.id = dBApp.appID;
        this.a = dBApp.environment;
        this.a = Utilities.getCanonicalFile((File)new File(dBApp.path));
        this.a = dBApp.jar;
        this.a = null;
        this.a = bl && this.a == null ? new HotDeploy(this) : null;
    }

    public AppDefinition(String string, String string2, File file, boolean bl) {
        this.id = string;
        this.a = string2;
        this.a = file;
        this.a = null;
        this.a = file == null ? new LinkedHashSet() : null;
        this.a = bl ? new HotDeploy(this) : null;
    }

    public void dispose() {
        this.disposeHotDeploy();
        AppFactory appFactory = this.a;
        this.a.forEach(iAppChangedListener -> iAppChangedListener.onAppDisposed(this, appFactory));
        this.a = null;
        WSFileProvider wSFileProvider = this.a;
        if (wSFileProvider != null) {
            wSFileProvider.disposeNoThrow(true);
        }
    }

    public boolean addListener(IAppChangedListener iAppChangedListener) {
        return this.a.addListener((Object)iAppChangedListener);
    }

    public boolean removeListener(IAppChangedListener iAppChangedListener) {
        return this.a.removeListener((Object)iAppChangedListener);
    }

    public AppFactory getFactory() {
        return this.a;
    }

    public void addModuleDirectory(File file) throws IOException {
        if (this.a == null) {
            throw new IOException("Application definition '" + this.id + "' is a compiled iiziApp and cannot accept Module project directory '" + String.valueOf(file) + "'");
        }
        if (!((HashSet)((Object)this.a)).add(file)) {
            throw new IOException("Module project directory '" + String.valueOf(file) + "' is already specified");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAppChanged() {
        Object object;
        if (this.a != null) {
            object = null;
            Object var2_3 = null;
            try (AutoLock autoLock = this.a.lock();){
                if (this.a.getJarFile().hasChanged()) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
        }
        if ((object = this.a) == null) return false;
        if (!((HotDeploy)object).a()) return false;
        return true;
    }

    public String getServerEnvironmentName() {
        return this.a;
    }

    public void loadApplication(ServerShell serverShell) throws PropException, IOException, ServerApplicationSetupException {
        HotDeploy hotDeploy = this.a;
        this.a = this.a(serverShell, hotDeploy);
        serverShell.registerApplication(this.id, this);
        this.a = serverShell;
        if (hotDeploy != null) {
            hotDeploy.a();
        }
    }

    public boolean isHotDeployEnabled() {
        return this.a != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean reload(ServerShell serverShell, boolean bl) throws PropException, IOException, ServerApplicationSetupException {
        AppFactory appFactory;
        HotDeploy hotDeploy;
        AutoLock autoLock;
        if (this.a != null) {
            return false;
        }
        long l = System.currentTimeMillis();
        Object object = null;
        Object var10_7 = null;
        try {
            autoLock = this.a.lock();
            try {
                if (this.a && !bl && !this.hasAppChanged()) {
                    return false;
                }
                hotDeploy = this.a;
            }
            finally {
                if (autoLock != null) {
                    autoLock.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
                throw object;
            }
            if (object == throwable) throw object;
            ((Throwable)object).addSuppressed(throwable);
            throw object;
        }
        ILog.INFO(this.getClass(), (String)(bl ? "Forced reload of application ID " + this.id : (this.a ? "Hot deploy reloading application ID " + this.id : "Attempting reload of previous failed loading of application ID " + this.id)));
        HotDeploy hotDeploy2 = hotDeploy != null ? new HotDeploy(this) : null;
        AppFactory appFactory2 = this.a(serverShell, hotDeploy2);
        object = null;
        var10_7 = null;
        try {
            autoLock = this.a.lock();
            try {
                if (hotDeploy != null) {
                    this.a = hotDeploy2;
                    hotDeploy.b();
                }
                appFactory = this.a;
                this.a = appFactory2;
            }
            finally {
                if (autoLock != null) {
                    autoLock.close();
                }
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
                throw object;
            }
            if (object == throwable) throw object;
            ((Throwable)object).addSuppressed(throwable);
            throw object;
        }
        object = serverShell.getServerProperties().getServerSettings();
        ((ServerSettings)((Object)object)).onApplicationLoad(appFactory2);
        if (hotDeploy2 != null) {
            hotDeploy2.a();
        }
        if (appFactory != null) {
            appFactory.dispose();
            ((ServerSettings)((Object)object)).onApplicationUnload(appFactory);
        }
        ILog.INFO(this.getClass(), (String)("Application ID " + this.id + " has been hot deploy reloaded from " + this.a.getAppFileSystemLocation() + "\n\n***\n***\n*** APPLICATION HOT DEPLOY AUTOMATICALLY RELOADED: APP ID = " + this.id + "  @" + (System.currentTimeMillis() - l) + " ms ***\n***\n***\n"));
        this.a.forEach(iAppChangedListener -> iAppChangedListener.onAppLoaded(this, appFactory2, appFactory));
        return true;
    }

    private AppFactory a(ServerShell serverShell, HotDeploy hotDeploy) throws PropException, IOException, ServerApplicationSetupException {
        if (this.a != null) {
            AppFactory appFactory = new AppFactory(this.id, this.a, (IAppLoader)serverShell, this.a, this);
            try {
                appFactory.initialize(serverShell);
            }
            finally {
                appFactory.dispose();
            }
            return appFactory;
        }
        if (this.a == null && this.a != null && ((HashSet)((Object)this.a)).isEmpty()) {
            throw new IOException("Application Module(s) not defined");
        }
        boolean bl = true;
        AppFactory appFactory = new AppFactory(this.id, this.a, (IAppLoader)serverShell, this.a, this);
        try {
            appFactory.initialize(serverShell);
            if (this.a != null || this.a != null) {
                Serializable serializable;
                if (this.a != null && hotDeploy != null) {
                    hotDeploy.addFile(this.a);
                }
                if (this.a != null) {
                    Iterator iterator = ((HashSet)((Object)this.a)).iterator();
                    while (iterator.hasNext()) {
                        serializable = (File)iterator.next();
                        appFactory.addModuleProject(ModuleProject.loadModuleProject(serverShell, serializable, hotDeploy, true));
                    }
                }
                serializable = new LinkedHashSet<File>();
                appFactory.prepare(serverShell.getClass().getClassLoader(), (Set<File>)((Object)serializable));
                bl = false;
                this.a = true;
                if (hotDeploy != null) {
                    hotDeploy.a((Set<File>)((Object)serializable));
                }
            }
        }
        finally {
            if (bl) {
                if (hotDeploy != null) {
                    hotDeploy.b();
                }
                appFactory.dispose();
            }
        }
        return appFactory;
    }

    public void disposeHotDeploy() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (AutoLock autoLock = this.a.lock();){
            HotDeploy hotDeploy = this.a;
            this.a = null;
            if (hotDeploy != null) {
                hotDeploy.b();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public WSFileProvider getAppSessionFileProvider() throws IOException {
        ServerShell serverShell = this.a;
        if (serverShell == null) {
            throw new IllegalStateException("Application is not yet loaded");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (AutoLock autoLock = this.a.lock();){
            if (this.a == null) {
                String string = "Application ID " + this.id;
                this.a = serverShell.getFileProviderEngine().getCreateFileProvider(URNResourceType.APPLICATION_VOLATILE, string, this.id, this.id, true, serverShell.getServerSettings());
            }
            return this.a;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

