/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.util.xjar;

import com.iizix.util.AbstractJarURLConnection;
import com.iizix.util.IJarFile;
import com.iizix.util.XJarFile;
import com.iizix.util.xjar.Handler;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class XJarURLConnection
extends AbstractJarURLConnection {
    private XJarFile a;
    private JarEntry a;

    protected XJarURLConnection(URL uRL) throws MalformedURLException {
        this(uRL, null);
    }

    protected XJarURLConnection(URL uRL, XJarFile xJarFile) throws MalformedURLException {
        super(uRL);
        this.a = xJarFile;
    }

    @Override
    public IJarFile getJarFile() throws IOException {
        if (this.a == null) {
            URL uRL = this.getJarFileURL();
            String string = null;
            try {
                URI uRI = uRL.toURI();
                string = uRI.getPath();
                this.a = XJarFile.getJarFile(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                try {
                    string = uRL.getPath();
                    this.a = XJarFile.getJarFile(string);
                }
                catch (IOException iOException) {
                    if (Handler.DEBUG) {
                        System.out.println("XJarURLConnection (inner): URL " + string + " (" + String.valueOf(uRL) + "): " + String.valueOf(iOException));
                    }
                    throw iOException;
                }
            }
            catch (IOException iOException) {
                if (Handler.DEBUG) {
                    System.out.println("XJarURLConnection: URL " + string + " (" + String.valueOf(uRL) + "): " + String.valueOf(iOException));
                }
                throw iOException;
            }
        }
        return this.a;
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        this.getJarFile();
        String string = this.getEntryName();
        if (string == null || string.isEmpty()) {
            throw new FileNotFoundException("No entryName for Jar " + this.a.getName() + " is set");
        }
        this.a = this.a.getJarEntry(string);
        if (this.a == null) {
            if (Handler.DEBUG) {
                System.out.println("XJarURLConnection: " + string + " not found in Jar " + this.a.getName());
            }
            throw new FileNotFoundException(string + " not found in Jar " + this.a.getName());
        }
        if (this.a.isDirectory()) {
            if (Handler.DEBUG) {
                System.out.println("XJarURLConnection: " + string + " is a directory in Jar " + this.a.getName());
            }
            throw new FileNotFoundException(string + " is a directory in Jar " + this.a.getName());
        }
        this.jarFileURLConnection = this;
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        if (Handler.DEBUG) {
            System.out.println("XJarURLConnection: class " + String.valueOf(this.a) + " in XJarFile " + this.a.getName() + ": getting class data");
        }
        return this.a.getInputStream(this.a);
    }
}

