/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop.ui.datetime;

import com.iizix.LocaleInfo;
import com.iizix.prop.GDateTime;
import com.iizix.prop.ui.datetime.UIDateTimeDataType;
import com.iizix.prop.ui.datetime.UIDateTimeType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public interface IUIDateTime {
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$iizix$prop$ui$datetime$UIDateTimeType;
    public static final /* synthetic */ int[] $SWITCH_TABLE$com$iizix$prop$GDateTime$Type;

    public UIDateTimeType getUIDateTimeType();

    public UIDateTimeDataType getDataType();

    public GDateTime.Type getGDateTimeType();

    public boolean isDataTypeEnforced();

    public boolean setType(UIDateTimeType var1, UIDateTimeDataType var2, boolean var3);

    public boolean isNullAllowed();

    public boolean setNullAllowed(boolean var1);

    public boolean setValueToNull();

    default public boolean setValue(GDateTime gDateTime) {
        return this.setValue(gDateTime, null);
    }

    public boolean setValue(GDateTime var1, LocaleInfo var2);

    public GDateTime getValue();

    default public GDateTime getDefaultValue() {
        return this.getDefaultValue(null);
    }

    default public GDateTime getDefaultValue(LocaleInfo localeInfo) {
        switch (this.getUIDateTimeType()) {
            case Date: {
                return GDateTime.EPOCH_DATE;
            }
            case Time: {
                return GDateTime.MIDNIGHT;
            }
            case DateTime: {
                return new GDateTime(LocalDateTime.of(GDateTime.EPOCH_DATE.getLocalDate(), LocalTime.MIDNIGHT));
            }
            case ZoneId: {
                return new GDateTime(LocaleInfo.getCurrent(false).getZoneId());
            }
        }
        throw new InternalError("Unknown type: " + String.valueOf((Object)this.getUIDateTimeType()));
    }

    default public boolean isTimeValueSupported() {
        switch (this.getUIDateTimeType()) {
            case Time: 
            case DateTime: {
                return true;
            }
        }
        return false;
    }

    default public boolean isTimeValueRequired() {
        return !this.isNullAllowed() && this.isTimeValueSupported();
    }

    default public LocalTime getLocalTime() {
        GDateTime gDateTime = this.getValue();
        if (gDateTime == null) {
            return null;
        }
        return gDateTime.toLocalTime();
    }

    default public boolean setTime(LocalTime localTime) {
        return this.setTime(localTime, null);
    }

    default public boolean setTime(LocalTime localTime, LocaleInfo localeInfo) {
        if (localTime == null) {
            throw new NullPointerException("localTime is null");
        }
        switch (this.getUIDateTimeType()) {
            case Date: {
                throw new IllegalArgumentException("Value is a date and has no time part");
            }
            case Time: {
                GDateTime gDateTime = this.getValue();
                if (gDateTime != null) {
                    switch (gDateTime.getType()) {
                        case OffsetTime: {
                            return this.setValue(new GDateTime(OffsetTime.of(localTime, gDateTime.getOffset())));
                        }
                    }
                }
                return this.setValue(new GDateTime(localTime), localeInfo);
            }
            case DateTime: {
                GDateTime gDateTime = this.getValue();
                if (gDateTime == null) {
                    throw new NullPointerException("Current value is null and thus does not have a date part");
                }
                switch (gDateTime.getType()) {
                    case LocalDateTime: {
                        LocalDateTime localDateTime = gDateTime.toLocalDateTime();
                        return this.setValue(new GDateTime(LocalDateTime.of(localDateTime.toLocalDate(), localTime)));
                    }
                    case OffsetDateTime: {
                        OffsetDateTime offsetDateTime = gDateTime.toOffsetDateTime(localeInfo);
                        return this.setValue(new GDateTime(OffsetDateTime.of(offsetDateTime.toLocalDate(), localTime, offsetDateTime.getOffset())));
                    }
                    case ZonedDateTime: {
                        ZonedDateTime zonedDateTime = gDateTime.toZonedDateTime(localeInfo);
                        return this.setValue(new GDateTime(ZonedDateTime.of(zonedDateTime.toLocalDate(), localTime, zonedDateTime.getZone())));
                    }
                }
                throw new IllegalArgumentException("Current value does not have a time part: " + String.valueOf(gDateTime));
            }
            case ZoneId: {
                throw new IllegalArgumentException("Value type ZoneId does not have a time part");
            }
        }
        throw new InternalError("Unknown type: " + String.valueOf((Object)this.getUIDateTimeType()));
    }

    default public boolean isDateValueSupported() {
        switch (this.getUIDateTimeType()) {
            case Date: 
            case DateTime: {
                return true;
            }
        }
        return false;
    }

    default public boolean isDateValueRequired() {
        return !this.isNullAllowed() && this.isTimeValueSupported();
    }

    default public LocalDate getLocalDate() {
        GDateTime gDateTime = this.getValue();
        if (gDateTime == null) {
            return null;
        }
        return gDateTime.toLocalDate();
    }

    default public boolean setDate(LocalDate localDate) {
        return this.setDate(localDate, null);
    }

    default public boolean setDate(LocalDate localDate, LocaleInfo localeInfo) {
        if (localDate == null) {
            throw new NullPointerException("localDate is null");
        }
        switch (this.getUIDateTimeType()) {
            case Time: {
                throw new IllegalArgumentException("Value is a time and has no date part");
            }
            case Date: {
                GDateTime gDateTime = this.getValue();
                if (gDateTime != null) {
                    switch (gDateTime.getType()) {
                        case LocalDate: {
                            return this.setValue(new GDateTime(localDate));
                        }
                    }
                }
                return this.setValue(new GDateTime(localDate), localeInfo);
            }
            case DateTime: {
                GDateTime gDateTime = this.getValue();
                if (gDateTime == null) {
                    throw new NullPointerException("Current value is null and thus does not have a date part");
                }
                switch (gDateTime.getType()) {
                    case LocalDateTime: {
                        LocalDateTime localDateTime = gDateTime.toLocalDateTime();
                        return this.setValue(new GDateTime(LocalDateTime.of(localDate, localDateTime.toLocalTime())));
                    }
                    case OffsetDateTime: {
                        OffsetDateTime offsetDateTime = gDateTime.toOffsetDateTime(localeInfo);
                        return this.setValue(new GDateTime(OffsetDateTime.of(localDate, offsetDateTime.toLocalTime(), offsetDateTime.getOffset())));
                    }
                    case ZonedDateTime: {
                        ZonedDateTime zonedDateTime = gDateTime.toZonedDateTime(localeInfo);
                        return this.setValue(new GDateTime(ZonedDateTime.of(localDate, zonedDateTime.toLocalTime(), zonedDateTime.getZone())));
                    }
                }
                throw new IllegalArgumentException("Current value does not have a date part: " + String.valueOf(gDateTime));
            }
            case ZoneId: {
                throw new IllegalArgumentException("Current value does not have a date part: " + String.valueOf(this.getValue()));
            }
        }
        throw new InternalError("Unknown type: " + String.valueOf((Object)this.getUIDateTimeType()));
    }

    default public ZoneId getZoneId() {
        GDateTime gDateTime = this.getValue();
        return gDateTime != null ? gDateTime.getZone() : null;
    }

    default public boolean setZoneId(ZoneId zoneId) {
        if (zoneId == null) {
            throw new NullPointerException("zone is null");
        }
        switch (this.getUIDateTimeType()) {
            case Time: {
                throw new IllegalArgumentException("Value is a time and has no zone part");
            }
            case Date: {
                throw new IllegalArgumentException("Value is a date and has no zone part");
            }
            case DateTime: {
                GDateTime gDateTime = this.getValue();
                if (gDateTime == null) {
                    throw new NullPointerException("Current value is null and thus does not have a zone part");
                }
                switch (gDateTime.getType()) {
                    case ZonedDateTime: {
                        LocalDateTime localDateTime = gDateTime.toLocalDateTime();
                        return this.setValue(new GDateTime(ZonedDateTime.of(localDateTime, zoneId)));
                    }
                }
                throw new IllegalArgumentException("Current value does not have a zone part: " + String.valueOf(gDateTime));
            }
            case ZoneId: {
                return this.setValue(new GDateTime(zoneId));
            }
        }
        throw new InternalError("Unknown type: " + String.valueOf((Object)this.getUIDateTimeType()));
    }

    public int getFormat();

    public boolean setFormat(int var1);

    public int getMinimumYear();

    public int getMaximumYear();

    public boolean setYearRange(int var1, int var2);

    public boolean isZoneUsed();

    public boolean setUseZone(boolean var1);

    public boolean isCalendarUsed();

    public boolean setUseCalendar(boolean var1);

    public boolean hasCalendarButton();

    public boolean setUseCalendarButton(boolean var1);

    public boolean isMillisecondsUsed();

    public boolean setUseMilliseconds(boolean var1);

    public boolean isDayMonthCombined();

    public boolean setCombineDayMonth(boolean var1);
}

