/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ReadTransaction;
import com.iizix.SendTransaction;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GGradient
implements Cloneable {
    private static final String[] a = new String[]{"top left", "top", "top right", "left", "right", "bottom left", "bottom", "bottom right"};
    private static final String[] b = new String[]{"to bottom right", "to bottom", "to bottom left", "to right", "to left", "to top right", "to top", "to top left"};
    private static final String[] c = new String[]{"0% 0%", "50% 0%", "100% 0%", "0% 50%", "50% 50%", "100% 50%", "0% 100%", "50% 100%", "100% 100%"};
    public static final GGradient NONE = new GGradient();
    private final int a;
    private final int b;
    private final int c;
    private final Swatch[] a;

    public static GGradient createGGradient(String string) {
        return string == null || string.isEmpty() ? NONE : new GGradient(string);
    }

    private GGradient() {
        this.c = 0;
        this.b = 0;
        this.a = 0;
        this.a = new Swatch[0];
    }

    public GGradient(int n2, Swatch[] swatchArray) {
        this(0, n2, 0, swatchArray);
    }

    public GGradient(int n2, int n3, Swatch[] swatchArray) {
        this(1, n2, n3, swatchArray);
    }

    public GGradient(int n2, int n3, int n4, Swatch[] swatchArray) {
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("Invalid type: 0 or 1");
        }
        if (n2 == 0) {
            if (n3 < 0 || n3 > 7) {
                throw new IllegalArgumentException("Invalid start (0-7)");
            }
            n4 = 0;
        } else {
            if (n3 < 0 || n3 > 8) {
                throw new IllegalArgumentException("Invalid start (0-8)");
            }
            if (n4 < 1 || n4 > 4096) {
                throw new IllegalArgumentException("Invalid size (1-4096)");
            }
        }
        if (swatchArray.length < 2 || swatchArray.length > 32) {
            throw new IllegalArgumentException("Invalid count of swatches (2-32)");
        }
        Swatch[] swatchArray2 = swatchArray;
        int n5 = swatchArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Swatch swatch = swatchArray2[n6];
            if (swatch == null) {
                throw new NullPointerException("Swatch object in array is null");
            }
            ++n6;
        }
        this.a = n2;
        this.c = n4;
        this.b = n3;
        this.a = swatchArray;
    }

    public GGradient(String string) throws IllegalArgumentException, NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        try {
            this.a = Integer.parseInt(stringTokenizer.nextToken());
            if (this.a < 0 || this.a > 1) {
                throw new IllegalArgumentException("Invalid type: 0 or 1");
            }
            this.b = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = 0;
            if (this.a == 1) {
                if (this.b < 0 || this.b > 8) {
                    throw new IllegalArgumentException("Invalid start (0-8)");
                }
                n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 < 1 || n2 > 4096) {
                    throw new IllegalArgumentException("Invalid size (1-4096)");
                }
            } else if (this.b < 0 || this.b > 7) {
                throw new IllegalArgumentException("Invalid start (0-7)");
            }
            this.c = n2;
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            if (n3 < 2 || n3 > 32) {
                throw new IllegalArgumentException("Invalid count of swatches (2-32)");
            }
            this.a = new Swatch[n3];
            int n4 = 0;
            while (n4 < n3) {
                this.a[n4] = new Swatch(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                ++n4;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException("Parse error: missing arguments");
        }
    }

    public GGradient(ReadTransaction readTransaction) {
        int n2 = readTransaction.readByte();
        int n3 = n2 >> 2;
        this.a = n2 & 3;
        this.b = readTransaction.readByte();
        this.c = this.a == 0 ? 0 : readTransaction.readUnsigned();
        this.a = new Swatch[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.a[n4] = new Swatch(readTransaction);
            ++n4;
        }
    }

    public void appendGradient(SendTransaction sendTransaction) {
        sendTransaction.appendByte(this.a | this.a.length << 2);
        sendTransaction.appendByte(this.b);
        if (this.a == 1) {
            sendTransaction.appendUnsigned(this.c);
        }
        Swatch[] swatchArray = this.a;
        int n2 = this.a.length;
        int n3 = 0;
        while (n3 < n2) {
            Swatch swatch = swatchArray[n3];
            swatch.append(sendTransaction);
            ++n3;
        }
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GGradient && this.equals((GGradient)object);
    }

    public GGradient clone() {
        return this;
    }

    public boolean equals(GGradient gGradient) {
        return gGradient != null && gGradient.a == this.a && gGradient.b == this.b && gGradient.c == this.c && Arrays.equals(gGradient.a, this.a);
    }

    public int getSwatchCount() {
        return this.a.length;
    }

    public Swatch getSwatch(int n2) {
        return this.a[n2];
    }

    public int getType() {
        return this.a;
    }

    public int getStart() {
        return this.b;
    }

    public int getSize() {
        return this.c;
    }

    public String getString() {
        return this.paramString();
    }

    protected String paramString() {
        String string = Integer.toString(this.a) + "," + this.b + ",";
        if (this.a == 1) {
            string = string + Integer.toString(this.c) + ",";
        }
        string = string + Integer.toString(this.a.length);
        Swatch[] swatchArray = this.a;
        int n2 = this.a.length;
        int n3 = 0;
        while (n3 < n2) {
            Swatch swatch = swatchArray[n3];
            string = string + "," + swatch.color + "," + swatch.stop;
            ++n3;
        }
        return string;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.paramString() + "]";
    }

    public String getCSSValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.a == 0) {
            stringBuilder.append("linear-gradient(").append(b[this.b]);
            Swatch[] swatchArray = this.a;
            int n2 = this.a.length;
            int n3 = 0;
            while (n3 < n2) {
                Swatch swatch = swatchArray[n3];
                stringBuilder.append(',').append(swatch.paramString());
                ++n3;
            }
            stringBuilder.append(')');
        } else {
            stringBuilder.append("radial-gradient(ellipse farthest-corner at ").append(c[this.b]);
            Swatch[] swatchArray = this.a;
            int n4 = this.a.length;
            int n5 = 0;
            while (n5 < n4) {
                Swatch swatch = swatchArray[n5];
                stringBuilder.append(',').append(swatch.paramString());
                ++n5;
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static class Swatch {
        public final int color;
        public final int stop;

        public Swatch(int n2, int n3) {
            if (n2 < 0 || n2 > 0xFFFFFF) {
                throw new IllegalArgumentException("color range 0-0xFFFFFF");
            }
            if (n3 < 0 || n3 > 100) {
                throw new IllegalArgumentException("stop range 0-100");
            }
            this.color = n2;
            this.stop = n3;
        }

        public Swatch(ReadTransaction readTransaction) {
            this.color = readTransaction.readUnsigned();
            this.stop = readTransaction.readByte();
        }

        public void append(SendTransaction sendTransaction) {
            sendTransaction.appendUnsigned(this.color);
            sendTransaction.appendByte(this.stop);
        }

        public boolean equals(Object object) {
            if (object instanceof Swatch) {
                Swatch swatch = (Swatch)object;
                return swatch.stop == this.stop && swatch.color == this.color;
            }
            return false;
        }

        public String getString() {
            return this.paramString();
        }

        protected String paramString() {
            String string = Integer.toHexString(this.color);
            return "#00000".substring(0, 7 - string.length()) + string + " " + this.stop + "%";
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.paramString() + "]";
        }
    }
}

