/*
 * Decompiled with CFR 0.152.
 */
package com.iizix.prop;

import com.iizix.ILog;
import com.iizix.SendTransaction;
import com.iizix.comm.ITransactionCreator;
import com.iizix.comm.ITransactionSender;
import com.iizix.prop.AssetReferences;
import com.iizix.prop.Atom;
import com.iizix.prop.FileURIPropCnr;
import com.iizix.prop.IPropMgrInfoProvider;
import java.util.List;
import java.util.Set;

public class CSSAssetReferences
extends AssetReferences {
    protected CSSAssetReferences() {
    }

    public CSSAssetReferences(Atom atom) {
        super(atom);
    }

    @Override
    public CSSAssetReferences clone() {
        return (CSSAssetReferences)super.clone();
    }

    public void sendCustomCSS(int n2, IPropMgrInfoProvider iPropMgrInfoProvider, ITransactionCreator iTransactionCreator, ITransactionSender iTransactionSender) {
        Set<FileURIPropCnr> set = this.getDirectReferencedTargetFiles();
        if (set != null) {
            int n3 = 0;
            List<String> list = this.fixedClientResourceURLs();
            for (FileURIPropCnr fileURIPropCnr : set) {
                if (list != null || fileURIPropCnr.getURL() != null) {
                    String string = list != null ? list.get(n3) : fileURIPropCnr.getReferencePropName().replace(':', '$');
                    long l2 = fileURIPropCnr.getSize();
                    long l3 = fileURIPropCnr.getModificationTime();
                    if (l2 >= 0L && l3 > 0L) {
                        if (iPropMgrInfoProvider.cacheCustomCSS(string)) {
                            ILog.INFO(this.getClass(), "Sending custom CSS to client: " + string);
                            SendTransaction sendTransaction = iTransactionCreator.createTransaction();
                            if (sendTransaction == null) {
                                ILog.SEVERE(this.getClass(), "No send transaction created = null", new Exception("Stack Trace"));
                            } else {
                                sendTransaction.appendByte(7);
                                sendTransaction.appendByte(1);
                                sendTransaction.appendByte(n2);
                                sendTransaction.appendByte(0);
                                sendTransaction.appendUnsigned(0);
                                sendTransaction.appendString(string);
                                if (n2 > 0) {
                                    sendTransaction.appendString(Long.toString(l2));
                                    sendTransaction.appendString(Long.toString(l3));
                                }
                                iTransactionSender.sendTransaction(sendTransaction);
                            }
                        }
                    } else {
                        ILog.WARNING(this.getClass(), "Custom CSS resource is gone: no size, no last modification time: " + string);
                    }
                } else {
                    ILog.WARNING(this.getClass(), "Custom CSS resource not found: " + fileURIPropCnr.getReferencePropName());
                }
                ++n3;
            }
        }
    }

    @Override
    protected String getFileTypeDescr() {
        return "CSS file";
    }

    @Override
    protected boolean isValidFileExtension(String string) {
        return "css".equalsIgnoreCase(string);
    }

    @Override
    protected String getErrorMessage(String string) {
        return "The CSS Asset File \"" + string + "\" does not have the valid file extension \".css\"";
    }
}

