/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.prop.editor;

import com.iizigo.prop.BaseEditor;
import com.iizigo.swt.UpDownArrowSpinner;
import com.iizix.prop.GSize;
import com.iizix.prop.SizeProp;
import java.util.StringTokenizer;

public class SizePropEditor
extends BaseEditor<SizeProp, GSize> {
    @Override
    protected void create() {
        this.createGridLayout(1, 0);
        this.createText();
        UpDownArrowSpinner.enable(this.text, true);
    }

    @Override
    protected String getToolTipText() {
        return "Enter size as two comma separated positive integer values";
    }

    @Override
    public GSize getDefaultValue() {
        try {
            return new GSize(this.info.defaultPropertyValue);
        }
        catch (Exception exception) {
            return new GSize();
        }
    }

    @Override
    protected GSize getValue(String string) throws Exception {
        int n2;
        if (string.isEmpty()) {
            throw new Exception("Size must be specified");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n3 = stringTokenizer.countTokens();
        if (n3 == 0) {
            throw new Exception("Size must be specified");
        }
        if (n3 > 1) {
            throw new Exception("Size can only be two comma separated values");
        }
        String string2 = stringTokenizer.nextToken();
        try {
            n2 = Integer.parseInt(string2.trim());
            if (n2 < 0 || n2 > 0x1FFFFFFF) {
                throw new Exception("Invalid width: number range (0 to 536870911, hex 1FFF FFFF): " + string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Invalid width: " + string2);
        }
        if (n3 == 1) {
            return new GSize(n2, n2);
        }
        string2 = stringTokenizer.nextToken();
        try {
            int n4 = Integer.parseInt(string2.trim());
            if (n4 < 0 || n4 > 0x1FFFFFFF) {
                throw new Exception("Invalid height: number range (0 to 536870911, hex 1FFF FFFF): " + string2);
            }
            return new GSize(n2, n4);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Invalid height: " + string2);
        }
    }

    @Override
    public String formatValue(GSize gSize) {
        return gSize.toString();
    }
}

