/*
 * Decompiled with CFR 0.152.
 */
package com.iizigo.panel.prop;

import com.iizigo.editor.PropHelper;
import com.iizigo.panel.prop.IELayoutProp;
import com.iizigo.panel.prop.IEUICompCommon;
import com.iizigo.prop.editor.IDefaultGUnitProvider;
import com.iizigo.prop.group.LayoutDataFormatter;
import com.iizigo.prop.tooltip.TooltipItem;
import com.iizix.prop.Atom;
import com.iizix.prop.BoolProp;
import com.iizix.prop.GProp;
import com.iizix.prop.GRect;
import com.iizix.prop.GUnit;
import com.iizix.prop.PropCnr;
import com.iizix.prop.PropException;
import com.iizix.prop.PropVerification;
import com.iizix.prop.PropVerificationError;
import com.iizix.prop.UnitProp;
import com.iizix.prop.ui.BorderData;
import com.iizix.prop.ui.UIComp;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EBorderData
extends BorderData
implements IELayoutProp,
IDefaultGUnitProvider {
    static final String[] a = new String[]{"region", "resize", "minSize", "maxSize", "cx", "cy", "assumeWidth", "assumeHeight", "alignX", "alignY"};
    private static final List<TooltipItem> a;

    static {
        a = List.of(TooltipItem.newNormal("Region", "region", (propCnr, gProp, object) -> {
            if (object instanceof Integer) {
                Integer n2 = (Integer)object;
                return switch (n2) {
                    case 5 -> "center";
                    case 8 -> "top";
                    case 2 -> "bottom";
                    case 4 -> "left";
                    case 44 -> "leading";
                    case 6 -> "right";
                    case 66 -> "trailing";
                    default -> "UNKNOWN (" + String.valueOf(n2) + ")";
                };
            }
            return null;
        }), TooltipItem.newNormal("Resizable", "resize"), TooltipItem.SPACER_4PX, TooltipItem.newNormal("Width", "cx"), TooltipItem.newNormal("Height", "cy"), TooltipItem.newNormal("Minimum size", "minSize"), TooltipItem.newNormal("Maximum size", "maxSize"), TooltipItem.SPACER_4PX, TooltipItem.newIntIndex("Horizontal align", "alignX", ALIGN_X), TooltipItem.newIntIndex("Vertical align", "alignY", ALIGN_Y), TooltipItem.SPACER_4PX, TooltipItem.newNormal("Assumed width", "assumeWidth"), TooltipItem.newNormal("Assumed height", "assumeHeight"));
    }

    public EBorderData() {
    }

    public EBorderData(Atom atom) {
        super(atom);
    }

    public EBorderData(UIComp uIComp) {
        super(Atom.LAYOUT);
    }

    public EBorderData(Atom atom, GProp<?>[] gPropArray) throws PropException {
        super(atom, gPropArray);
    }

    @Override
    public String getCNDescriptionType() {
        return "Border data";
    }

    @Override
    public String getGroupText(PropCnr[] propCnrArray, StringBuilder stringBuilder, boolean[] blArray) {
        String string;
        Integer n2;
        Object object;
        Object object2 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"region"));
        Object object3 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"resize"));
        Object object4 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"minSize"));
        Object object5 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"maxSize"));
        Object object6 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"cx"));
        Object object7 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"cy"));
        Object object8 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"alignX"));
        Object object9 = PropHelper.getPropsValue(propCnrArray, Atom.get((String)"alignY"));
        blArray[0] = true;
        stringBuilder.append("<u><b>Border layout:</b></u><br><table>");
        Object object10 = this.a(object2);
        if (object10 != null) {
            stringBuilder.append("<tr><td>Region</td><td>").append((String)object10).append("</td></tr>");
        } else {
            object10 = "default top";
        }
        if (object6 != null) {
            stringBuilder.append("<tr><td>Width</td><td>").append(LayoutDataFormatter.format(object6)).append("</td></tr>");
        }
        if (object7 != null) {
            stringBuilder.append("<tr><td>Height</td><td>").append(LayoutDataFormatter.format(object7)).append("</td></tr>");
        }
        if (object4 != null) {
            stringBuilder.append("<tr><td>Min-size</td><td>").append(LayoutDataFormatter.format(object4)).append("</td></tr>");
        }
        if (object5 != null) {
            stringBuilder.append("<tr><td>Max-size</td><td>").append(LayoutDataFormatter.format(object5)).append("</td></tr>");
        }
        if (object8 instanceof Integer && (object = this.getAlignXString(n2 = (Integer)object8)) != null) {
            if (!((String)object10).isEmpty()) {
                object10 = (String)object10 + ", ";
            }
            object10 = (String)object10 + (String)object;
            stringBuilder.append("<tr><td>Align horizontal</td><td>" + (String)object + "</td></tr>");
        }
        if (object9 instanceof Integer && (string = this.getAlignYString((Integer)(object = (Integer)object9))) != null) {
            if (!((String)object10).isEmpty()) {
                object10 = (String)object10 + ", ";
            }
            object10 = (String)object10 + string;
            stringBuilder.append("<tr><td>Align vertical</td><td>" + string + "</td></tr>");
        }
        stringBuilder.append("</table>");
        if (Boolean.TRUE.equals(object3)) {
            if (!((String)object10).isEmpty()) {
                object10 = (String)object10 + ", ";
            }
            object10 = (String)object10 + "resize";
            stringBuilder.append("\nResizable");
        }
        return object10;
    }

    private String a(Object object) {
        if (object instanceof Integer) {
            switch ((Integer)object) {
                case 5: {
                    return "center";
                }
                case 8: {
                    return "top";
                }
                case 2: {
                    return "bottom";
                }
                case 44: {
                    return "leading";
                }
                case 66: {
                    return "trailing";
                }
                case 4: {
                    return "left";
                }
                case 6: {
                    return "right";
                }
            }
        }
        return null;
    }

    @Override
    public GUnit getDefaultValue(Atom atom, GUnit gUnit) {
        String string;
        switch (string = atom.getAtomName()) {
            case "cx": 
            case "cy": {
                IEUICompCommon iEUICompCommon;
                GRect gRect;
                PropCnr propCnr = this.getParent();
                if (!(propCnr instanceof IEUICompCommon) || (gRect = (iEUICompCommon = (IEUICompCommon)propCnr).getBounds()) == null) break;
                int n2 = string.equals("cx") ? gRect.getCX() : gRect.getCY();
                gUnit = new GUnit(n2);
            }
        }
        return gUnit;
    }

    @Override
    public Object[] getTransferProps() {
        return a;
    }

    public boolean verify(PropVerification propVerification) {
        UnitProp unitProp;
        if (!super.verify(propVerification)) {
            return false;
        }
        UIComp uIComp = (UIComp)this.getParent();
        this.verifyAlignX(uIComp, propVerification);
        this.verifyAlignY(uIComp, propVerification);
        int n2 = this.getInt("region", 8);
        if ((n2 == 2 || n2 == 5 || n2 == 8) && (unitProp = (UnitProp)this.getProp("cx", UnitProp.class)) != null) {
            propVerification.add(new PropVerificationError("width", PropVerificationError.Severity.WARNING, "Width", (GProp)unitProp, "Width should not be defined for " + this.a(n2) + " region", new String[]{"DeleteProperty"}));
        }
        if ((n2 == 4 || n2 == 44 || n2 == 5 || n2 == 6 || n2 == 66) && (unitProp = (UnitProp)this.getProp("cy", UnitProp.class)) != null) {
            propVerification.add(new PropVerificationError("height", PropVerificationError.Severity.WARNING, "Height", (GProp)unitProp, "Height should not be defined for " + this.a(n2) + " region", new String[]{"DeleteProperty"}));
        }
        if (n2 != 5) {
            if (uIComp.mustHaveWidth() && !uIComp.hasImplicitWidth()) {
                unitProp = (UnitProp)this.getProp("cx", UnitProp.class);
                if (unitProp == null) {
                    propVerification.add(new PropVerificationError((PropCnr)this, "cx", PropVerificationError.Severity.WARNING, "Width", "Width must be defined for the component", new String[0]));
                } else {
                    propVerification.add(new PropVerificationError("width0", PropVerificationError.Severity.WARNING, "Width", (GProp)unitProp, "Width cannot be zero for the component", new String[0]));
                }
            }
            if (uIComp.mustHaveHeight() && !uIComp.hasImplicitHeight()) {
                unitProp = (UnitProp)this.getProp("cy", UnitProp.class);
                if (unitProp == null) {
                    propVerification.add(new PropVerificationError((PropCnr)this, "cy", PropVerificationError.Severity.WARNING, "Height", "Height must be defined for the component", new String[0]));
                } else {
                    propVerification.add(new PropVerificationError("height0", PropVerificationError.Severity.WARNING, "Height", (GProp)unitProp, "Height cannot be zero for the component", new String[0]));
                }
            }
        }
        unitProp = (BoolProp)this.getProp("resize", BoolProp.class);
        UnitProp unitProp2 = (UnitProp)this.getProp("minSize", UnitProp.class);
        UnitProp unitProp3 = (UnitProp)this.getProp("maxSize", UnitProp.class);
        if (unitProp != null && unitProp.getBool(false)) {
            if (n2 == 5) {
                propVerification.add(new PropVerificationError("no.resize", PropVerificationError.Severity.WARNING, "Resizable", (GProp)unitProp, "Center component cannot be resized", new String[]{"DeleteProperty"}));
            } else if (unitProp2 != null && unitProp3 != null) {
                GUnit gUnit = unitProp2.getUnit();
                GUnit gUnit2 = unitProp3.getUnit();
                if (gUnit != null && gUnit2 != null) {
                    boolean bl = n2 != 2 && n2 != 8;
                    double d2 = gUnit.getPixelValue(uIComp, bl);
                    double d3 = gUnit2.getPixelValue(uIComp, bl);
                    if (!Double.isNaN(d2) && !Double.isNaN(d3) && d2 > d3) {
                        propVerification.add(new PropVerificationError("minMax", PropVerificationError.Severity.ERROR, "Minimum size", (GProp)unitProp2, "Minimum size limit is larger that maximum size limit", new String[]{"DeleteProperty"}));
                    }
                }
            }
        } else {
            if (unitProp2 != null) {
                propVerification.add(new PropVerificationError("minSize", PropVerificationError.Severity.WARNING, "Minimum size", (GProp)unitProp2, "Non-resizable element should not have minimum size", new String[]{"DeleteProperty"}));
            }
            if (unitProp3 != null) {
                propVerification.add(new PropVerificationError("maxSize", PropVerificationError.Severity.WARNING, "Maximum size", (GProp)unitProp3, "Non-resizable element should not have maximum size", new String[]{"DeleteProperty"}));
            }
        }
        return true;
    }

    @Override
    public List<TooltipItem> getTooltipPropertyList() {
        return a;
    }
}

